@extends('systemadmin.layouts.app')

@section('title', 'Create Organization')
@section('page-title', 'Create New Organization')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Create New Organization</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('systemadmin.organizations.store') }}">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <x-form.input name="name" label="Organization Name" required />
                        </div>
                        
                        <div class="col-md-6">
                            <x-form.input 
                                name="slug" 
                                label="Slug" 
                                placeholder="Auto-generated from name"
                                help="Leave empty to auto-generate from name" />
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <x-form.select 
                                name="status" 
                                label="Status" 
                                required
                                :value="old('status', 'active')"
                                :options="[
                                    'active' => 'Active',
                                    'inactive' => 'Inactive',
                                    'suspended' => 'Suspended'
                                ]" />
                        </div>
                    </div>
                    
                    <hr class="my-4">
                    <h6 class="mb-3">Organization Administrator</h6>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <x-form.input name="admin_name" label="Admin Name" required />
                        </div>
                        
                        <div class="col-md-6">
                            <x-form.input type="email" name="admin_email" label="Admin Email" required />
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <x-form.input type="password" name="admin_password" label="Admin Password" required />
                        </div>
                        
                        <div class="col-md-6">
                            <x-form.input type="password" name="admin_password_confirmation" label="Confirm Password" required />
                        </div>
                    </div>
                    
                    <x-form.button-group 
                        cancelUrl="{{ route('systemadmin.organizations.index') }}"
                        submitText="Create Organization"
                        submitIcon="bi-check" />
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.getElementById('name').addEventListener('input', function() {
    const name = this.value;
    const slug = name.toLowerCase()
        .replace(/[^a-z0-9 -]/g, '')
        .replace(/\s+/g, '-')
        .replace(/-+/g, '-')
        .trim('-');
    document.getElementById('slug').value = slug;
});
</script>
@endpush