@extends('systemadmin.layouts.app')

@section('title', 'Organization Details')
@section('page-title', 'Organization: ' . $organization->name)

@section('content')
<x-page-header :title="'Organization: ' . $organization->name">
    <x-slot:breadcrumbs>
        <x-breadcrumb :items="[
            ['label' => 'Dashboard', 'url' => route('systemadmin.dashboard')],
            ['label' => 'Organizations', 'url' => route('systemadmin.organizations.index')],
            ['label' => $organization->name, 'active' => true]
        ]" />
    </x-slot:breadcrumbs>
    
    <x-slot:actions>
        <a href="{{ route('systemadmin.organizations.edit', $organization) }}" class="btn btn-outline-primary">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="{{ route('systemadmin.organizations.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </x-slot:actions>
</x-page-header>

<div class="row">
    <div class="col-md-8">
        <x-info-card title="Organization Information" icon="bi-building">
            <div class="row">
                <div class="col-md-6">
                    <x-detail-row label="Name" :value="$organization->name" />
                    <x-detail-row label="Slug">
                        <code>{{ $organization->slug }}</code>
                    </x-detail-row>
                    <x-detail-row label="Status">
                        <x-status-badge :status="$organization->status" />
                    </x-detail-row>
                </div>
                <div class="col-md-6">
                    <x-detail-row label="Created" :value="$organization->created_at->format('M d, Y H:i')" />
                    <x-detail-row label="Updated" :value="$organization->updated_at->format('M d, Y H:i')" />
                </div>
            </div>
        </x-info-card>

        <x-table-card title="Organization Users" class="mt-4">
            @if($organization->users->count() > 0)
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Roles</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($organization->users as $user)
                        <tr>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>
                                @foreach($user->roles as $role)
                                    <x-badge color="primary" class="me-1">{{ $role->name }}</x-badge>
                                @endforeach
                            </td>
                            <td>{{ $user->created_at->format('M d, Y') }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <x-empty-state 
                    icon="bi-people" 
                    message="No users found for this organization" />
            @endif
        </x-table-card>
    </div>
    
    <div class="col-md-4">
        <x-info-card title="Statistics" icon="bi-bar-chart" class="mb-3">
            <div class="row text-center">
                <div class="col-6 mb-3">
                    <div class="border-end pe-3">
                        <h3 class="text-primary mb-0">{{ $stats['total_users'] }}</h3>
                        <small class="text-muted">Total Users</small>
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="ps-3">
                        <h3 class="text-success mb-0">{{ $stats['admin_users'] }}</h3>
                        <small class="text-muted">Admin Users</small>
                    </div>
                </div>
                <div class="col-6">
                    <div class="border-end pe-3">
                        <h3 class="text-info mb-0">{{ $stats['total_employees'] }}</h3>
                        <small class="text-muted">Employees</small>
                    </div>
                </div>
                <div class="col-6">
                    <div class="ps-3">
                        <h3 class="text-warning mb-0">{{ $stats['total_departments'] }}</h3>
                        <small class="text-muted">Departments</small>
                    </div>
                </div>
            </div>
        </x-info-card>
        
        <x-info-card title="Quick Actions" icon="bi-lightning" class="mt-3">
            <div class="d-grid gap-2">
                <a href="{{ route('systemadmin.organizations.edit', $organization) }}" class="btn btn-outline-primary w-100">
                    <i class="bi bi-pencil"></i> Edit Organization
                </a>
                @if($organization->status === 'active')
                    <button class="btn btn-outline-warning w-100" onclick="changeStatus('inactive')">
                        <i class="bi bi-pause"></i> Suspend Organization
                    </button>
                @else
                    <button class="btn btn-outline-success w-100" onclick="changeStatus('active')">
                        <i class="bi bi-play"></i> Activate Organization
                    </button>
                @endif
            </div>
        </x-info-card>
    </div>
</div>

<!-- Status Change Form (hidden) -->
<form id="statusForm" method="POST" action="{{ route('systemadmin.organizations.update', $organization) }}" style="display: none;">
    @csrf
    @method('PUT')
    <input type="hidden" name="name" value="{{ $organization->name }}">
    <input type="hidden" name="slug" value="{{ $organization->slug }}">
    <input type="hidden" name="status" id="newStatus">
</form>
@endsection

@push('scripts')
<script>
function changeStatus(status) {
    if (confirm('Are you sure you want to change the organization status?')) {
        document.getElementById('newStatus').value = status;
        document.getElementById('statusForm').submit();
    }
}
</script>
@endpush