@extends('systemadmin.layouts.app')

@section('title', 'Subscription Details')

@section('content')
<x-page-header title="Subscription Details">
    <x-slot:breadcrumbs>
        <x-breadcrumb :items="[
            ['label' => 'Dashboard', 'url' => route('systemadmin.dashboard')],
            ['label' => 'Subscriptions', 'url' => route('systemadmin.subscriptions.index')],
            ['label' => $subscription->organization->name, 'active' => true]
        ]" />
    </x-slot:breadcrumbs>
    
    <x-slot:actions>
        <a href="{{ route('systemadmin.subscriptions.edit', $subscription) }}" class="btn btn-primary">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="{{ route('systemadmin.subscriptions.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </x-slot:actions>
</x-page-header>

<!-- Organization Info -->
<x-info-card title="Organization Information" icon="bi-building" class="mb-4">
    <div class="row">
        <div class="col-md-6">
            <x-detail-row label="Name" :value="$subscription->organization->name" />
            <x-detail-row label="Slug" :value="$subscription->organization->slug" />
            <x-detail-row label="Status">
                <x-status-badge :status="$subscription->organization->status" />
            </x-detail-row>
        </div>
        <div class="col-md-6">
            <x-detail-row label="Created" :value="$subscription->organization->created_at->format('M d, Y')" />
            <x-detail-row label="Employees" :value="$summary['employees']['current'] ?? 0" />
            <x-detail-row label="Users" :value="$summary['users']['current'] ?? 0" />
        </div>
    </div>
</x-info-card>

    <!-- Subscription Details -->
    <x-info-card title="Subscription Details" icon="bi-star-fill" class="mb-4">
        <div class="row">
            <div class="col-md-6">
                <h6>Plan Information</h6>
                <x-detail-row label="Plan" :value="$subscription->plan->name" />
                <x-detail-row label="Billing Cycle" :value="ucfirst($subscription->billing_cycle)" />
                <x-detail-row label="Price" :value="'KES ' . number_format($subscription->billing_cycle === 'monthly' ? $subscription->plan->price_monthly : $subscription->plan->price_annual, 2)" />
            </div>
            <div class="col-md-6">
                <h6>Status Information</h6>
                <x-detail-row label="Status">
                    <x-status-badge :status="$subscription->status" />
                </x-detail-row>
                @if($subscription->status === 'trial')
                    <x-detail-row label="Trial Ends" :value="$subscription->trial_ends_at->format('M d, Y')" />
                    <x-detail-row label="Days Remaining" :value="$subscription->trialDaysRemaining() . ' days'" />
                @endif
                @if($subscription->current_period_ends_at)
                    <x-detail-row label="Current Period Ends" :value="$subscription->current_period_ends_at->format('M d, Y')" />
                @endif
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-12">
                <h6>Dates</h6>
                <x-detail-row label="Started" :value="$subscription->started_at ? $subscription->started_at->format('M d, Y H:i') : 'Not started'" />
                @if($subscription->ends_at)
                <x-detail-row label="Ends" :value="$subscription->ends_at->format('M d, Y')" />
                @endif
                <x-detail-row label="Created" :value="$subscription->created_at->format('M d, Y H:i')" />
                <x-detail-row label="Last Updated" :value="$subscription->updated_at->format('M d, Y H:i')" />
            </div>
        </div>
    </x-info-card>

    <!-- Usage Summary -->
    <x-subscription-usage :organization="$subscription->organization" class="mb-4" />

    <!-- Actions -->
    <x-info-card title="Actions" icon="bi-gear">
        <div class="row">
            @if($subscription->status === 'trial')
            <div class="col-md-4 mb-3">
                <form method="POST" action="{{ route('systemadmin.subscriptions.extend-trial', $subscription) }}">
                    @csrf
                    <x-form.input 
                        name="days" 
                        label="Extend Trial (days)" 
                        type="number"
                        value="7"
                        min="1"
                        max="90" />
                    <button type="submit" class="btn btn-info w-100">
                        <i class="bi bi-clock"></i> Extend Trial
                    </button>
                </form>
            </div>
            @endif

            @if($subscription->status === 'active' || $subscription->status === 'trial')
            <div class="col-md-4 mb-3">
                <form method="POST" action="{{ route('systemadmin.subscriptions.suspend', $subscription) }}" 
                      onsubmit="return confirm('Are you sure you want to suspend this subscription?')">
                    @csrf
                    <button type="submit" class="btn btn-warning w-100">
                        <i class="bi bi-pause-circle"></i> Suspend Subscription
                    </button>
                </form>
            </div>
            @endif

            @if($subscription->status === 'suspended')
            <div class="col-md-4 mb-3">
                <form method="POST" action="{{ route('systemadmin.subscriptions.reactivate', $subscription) }}">
                    @csrf
                    <button type="submit" class="btn btn-success w-100">
                        <i class="bi bi-play-circle"></i> Reactivate Subscription
                    </button>
                </form>
            </div>
            @endif

            @if($subscription->status !== 'cancelled')
            <div class="col-md-4 mb-3">
                <form method="POST" action="{{ route('systemadmin.subscriptions.cancel', $subscription) }}" 
                      onsubmit="return confirm('Are you sure you want to cancel this subscription?')">
                    @csrf
                    <button type="submit" class="btn btn-danger w-100">
                        <i class="bi bi-x-circle"></i> Cancel Subscription
                    </button>
                </form>
            </div>
            @endif
        </div>
    </x-info-card>
@endsection
