@extends('layouts.app')

@section('title', 'Training Dashboard')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Dashboard</h1>
                <div>
                    <a href="{{ route('training.programs.create') }}" class="btn btn-primary me-2">
                        <i class="bi bi-plus"></i> New Program
                    </a>
                    <a href="{{ route('training.sessions.create') }}" class="btn btn-outline-primary">
                        <i class="bi bi-calendar-plus"></i> Schedule Session
                    </a>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $stats['total_programs'] }}</h4>
                                    <p class="mb-0">Active Programs</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-book fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $stats['active_sessions'] }}</h4>
                                    <p class="mb-0">Active Sessions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-calendar-alt fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $stats['total_enrollments'] }}</h4>
                                    <p class="mb-0">Total Enrollments</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-users fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $stats['completion_rate'] }}%</h4>
                                    <p class="mb-0">Completion Rate</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-chart-line fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Upcoming Sessions -->
                <div class="col-lg-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">Upcoming Sessions</h5>
                        </div>
                        <div class="card-body">
                            @if($upcomingSessions->count() > 0)
                                @foreach($upcomingSessions as $session)
                                    <div class="d-flex justify-content-between align-items-center border-bottom pb-2 mb-2">
                                        <div>
                                            <strong>{{ $session->program->title }}</strong><br>
                                            <small class="text-muted">
                                                {{ $session->start_datetime->format('M j, Y g:i A') }}
                                                @if($session->instructor)
                                                    | {{ $session->instructor->name }}
                                                @endif
                                            </small>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge badge-primary">{{ $session->enrollments->count() }} enrolled</span>
                                        </div>
                                    </div>
                                @endforeach
                                <div class="text-center mt-3">
                                    <a href="{{ route('training.sessions.index') }}" class="btn btn-sm btn-outline-primary">View All Sessions</a>
                                </div>
                            @else
                                <div class="text-center py-3">
                                    <i class="bi bi-calendar-times fa-2x text-muted mb-2"></i>
                                    <p class="text-muted">No upcoming sessions</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Popular Programs -->
                <div class="col-lg-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">Popular Programs</h5>
                        </div>
                        <div class="card-body">
                            @if($popularPrograms->count() > 0)
                                @foreach($popularPrograms as $program)
                                    <div class="d-flex justify-content-between align-items-center border-bottom pb-2 mb-2">
                                        <div>
                                            <strong>{{ $program->title }}</strong><br>
                                            <small class="text-muted">{{ $program->category->name }}</small>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge badge-success">{{ $program->enrollments_count }} enrollments</span>
                                        </div>
                                    </div>
                                @endforeach
                                <div class="text-center mt-3">
                                    <a href="{{ route('training.programs.index') }}" class="btn btn-sm btn-outline-primary">View All Programs</a>
                                </div>
                            @else
                                <div class="text-center py-3">
                                    <i class="bi bi-book fa-2x text-muted mb-2"></i>
                                    <p class="text-muted">No programs available</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activities -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Recent Enrollments</h5>
                </div>
                <div class="card-body">
                    @if($recentEnrollments->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Employee</th>
                                        <th>Program</th>
                                        <th>Session</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentEnrollments as $enrollment)
                                        <tr>
                                            <td>{{ $enrollment->employee->full_name }}</td>
                                            <td>{{ $enrollment->session->program->title }}</td>
                                            <td>{{ $enrollment->session->session_code }}</td>
                                            <td>
                                                <span class="badge badge-{{ $enrollment->status_color }}">
                                                    {{ ucfirst($enrollment->status) }}
                                                </span>
                                            </td>
                                            <td>{{ $enrollment->enrolled_at->format('M j, Y') }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-3">
                            <i class="bi bi-user-plus fa-2x text-muted mb-2"></i>
                            <p class="text-muted">No recent enrollments</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection