@extends('layouts.app')

@section('title', 'Learning Paths')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Learning Paths</h1>
                <div class="btn-group">
                    @can('create', App\Models\LearningPath::class)
                        <a href="{{ route('training.learning-paths.create') }}" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Create Learning Path
                        </a>
                    @endcan
                    <a href="{{ route('training.learning-paths.my-paths') }}" class="btn btn-outline-primary">
                        <i class="bi bi-person"></i> My Learning Paths
                    </a>
                </div>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="{{ route('training.learning-paths.index') }}">
                        <div class="row">
                            <div class="col-md-3">
                                <input type="text" name="search" class="form-control" placeholder="Search learning paths..." value="{{ request('search') }}">
                            </div>
                            <div class="col-md-3">
                                <select name="difficulty" class="form-select">
                                    <option value="">All Difficulty Levels</option>
                                    <option value="beginner" {{ request('difficulty') == 'beginner' ? 'selected' : '' }}>Beginner</option>
                                    <option value="intermediate" {{ request('difficulty') == 'intermediate' ? 'selected' : '' }}>Intermediate</option>
                                    <option value="advanced" {{ request('difficulty') == 'advanced' ? 'selected' : '' }}>Advanced</option>
                                </select>
                            </div>
                            @can('view_inactive_learning_paths')
                                <div class="col-md-3">
                                    <select name="status" class="form-select">
                                        <option value="">Active Only</option>
                                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                </div>
                            @endcan
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="bi bi-search"></i> Search
                                </button>
                                <a href="{{ route('training.learning-paths.index') }}" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Learning Paths Grid -->
            @if($learningPaths->count() > 0)
                <div class="row">
                    @foreach($learningPaths as $path)
                        <div class="col-md-6 col-lg-4 mb-4">
                            <div class="card h-100">
                                @if($path->image_path)
                                    <img src="{{ asset('storage/' . $path->image_path) }}" class="card-img-top" alt="{{ $path->title }}" style="height: 200px; object-fit: cover;">
                                @else
                                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                                        <i class="bi bi-map fs-1 text-muted"></i>
                                    </div>
                                @endif
                                
                                <div class="card-body d-flex flex-column">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h5 class="card-title">{{ $path->title }}</h5>
                                        <span class="badge bg-{{ $path->difficulty_color }}">{{ ucfirst($path->difficulty_level) }}</span>
                                    </div>
                                    
                                    <p class="card-text text-muted small flex-grow-1">{{ Str::limit($path->description, 100) }}</p>
                                    
                                    <div class="mb-3">
                                        <div class="row text-center">
                                            <div class="col-4">
                                                <small class="text-muted">Steps</small><br>
                                                <strong>{{ $path->total_steps }}</strong>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Duration</small><br>
                                                <strong>{{ $path->estimated_duration_hours }}h</strong>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Completion</small><br>
                                                <strong>{{ $path->completion_rate }}%</strong>
                                            </div>
                                        </div>
                                    </div>

                                    @if($path->learning_outcomes)
                                        <div class="mb-3">
                                            <small class="text-muted">Learning Outcomes:</small>
                                            <ul class="small mb-0">
                                                @foreach(array_slice($path->learning_outcomes, 0, 2) as $outcome)
                                                    <li>{{ $outcome }}</li>
                                                @endforeach
                                                @if(count($path->learning_outcomes) > 2)
                                                    <li class="text-muted">+{{ count($path->learning_outcomes) - 2 }} more...</li>
                                                @endif
                                            </ul>
                                        </div>
                                    @endif
                                    
                                    <div class="mt-auto">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('training.learning-paths.show', $path) }}" class="btn btn-outline-primary">
                                                    <i class="bi bi-eye"></i> View
                                                </a>
                                                @can('update', $path)
                                                    <a href="{{ route('training.learning-paths.edit', $path) }}" class="btn btn-outline-secondary">
                                                        <i class="bi bi-pencil"></i>
                                                    </a>
                                                @endcan
                                            </div>
                                            
                                            @if(in_array($path->id, $userEnrollments))
                                                <span class="badge bg-success">
                                                    <i class="bi bi-check-circle"></i> Enrolled
                                                </span>
                                            @else
                                                @can('enroll', $path)
                                                    <form method="POST" action="{{ route('training.learning-paths.enroll', $path) }}" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-primary">
                                                            <i class="bi bi-plus-circle"></i> Enroll
                                                        </button>
                                                    </form>
                                                @endcan
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $learningPaths->appends(request()->query())->links() }}
                </div>
            @else
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-map fs-1 text-muted"></i>
                        <h4 class="mt-3">No Learning Paths Found</h4>
                        <p class="text-muted">No learning paths match your current search criteria.</p>
                        @can('create', App\Models\LearningPath::class)
                            <a href="{{ route('training.learning-paths.create') }}" class="btn btn-primary">
                                <i class="bi bi-plus"></i> Create First Learning Path
                            </a>
                        @endcan
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection