@extends('layouts.app')

@section('title', 'My Trainings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">My Trainings</h1>
                <a href="{{ route('training.index') }}" class="btn btn-primary">
                    <i class="bi bi-search"></i> Browse Training Programs
                </a>
            </div>

            @if($upcomingSessions->count() > 0)
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-calendar-alt"></i> Upcoming Sessions</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($upcomingSessions as $enrollment)
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="card border-primary">
                                        <div class="card-body">
                                            <h6 class="card-title">{{ $enrollment->session->program->title }}</h6>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    <i class="bi bi-calendar"></i> {{ $enrollment->session->start_datetime->format('M j, Y') }}<br>
                                                    <i class="bi bi-clock"></i> {{ $enrollment->session->start_datetime->format('g:i A') }} - {{ $enrollment->session->end_datetime->format('g:i A') }}<br>
                                                    @if($enrollment->session->location)
                                                        <i class="bi bi-map-marker-alt"></i> {{ $enrollment->session->location }}<br>
                                                    @endif
                                                    @if($enrollment->session->instructor)
                                                        <i class="bi bi-user"></i> {{ $enrollment->session->instructor->name }}
                                                    @endif
                                                </small>
                                            </p>
                                            <span class="badge badge-{{ $enrollment->status == 'enrolled' ? 'primary' : 'success' }}">
                                                {{ ucfirst($enrollment->status) }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif

            @if($completedTrainings->count() > 0)
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-trophy"></i> Recently Completed</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($completedTrainings as $enrollment)
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="card border-success">
                                        <div class="card-body">
                                            <h6 class="card-title">{{ $enrollment->session->program->title }}</h6>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    <i class="bi bi-calendar-check"></i> Completed: {{ $enrollment->completed_at->format('M j, Y') }}<br>
                                                    <i class="bi bi-tag"></i> {{ $enrollment->session->program->category->name }}
                                                    @if($enrollment->completion_score)
                                                        <br><i class="bi bi-star"></i> Score: {{ $enrollment->completion_score }}%
                                                    @endif
                                                </small>
                                            </p>
                                            <span class="badge badge-success">Completed</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-list"></i> All Training History</h5>
                </div>
                <div class="card-body">
                    @if($enrollments->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Program</th>
                                        <th>Category</th>
                                        <th>Session</th>
                                        <th>Status</th>
                                        <th>Enrolled Date</th>
                                        <th>Completion</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($enrollments as $enrollment)
                                        <tr>
                                            <td>
                                                <strong>{{ $enrollment->session->program->title }}</strong><br>
                                                <small class="text-muted">{{ Str::limit($enrollment->session->program->description, 50) }}</small>
                                            </td>
                                            <td>
                                                <span class="badge" style="background-color: {{ $enrollment->session->program->category->color }}">
                                                    {{ $enrollment->session->program->category->name }}
                                                </span>
                                            </td>
                                            <td>
                                                <strong>{{ $enrollment->session->session_code }}</strong><br>
                                                <small class="text-muted">
                                                    {{ $enrollment->session->start_datetime->format('M j, Y g:i A') }}
                                                </small>
                                            </td>
                                            <td>
                                                <span class="badge badge-{{ $enrollment->status_color }}">
                                                    {{ ucfirst(str_replace('_', ' ', $enrollment->status)) }}
                                                </span>
                                            </td>
                                            <td>{{ $enrollment->enrolled_at->format('M j, Y') }}</td>
                                            <td>
                                                @if($enrollment->completion_score)
                                                    <span class="badge badge-success">{{ $enrollment->completion_score }}%</span>
                                                @elseif($enrollment->completed_at)
                                                    <span class="badge badge-success">Completed</span>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('training.programs.show', $enrollment->session->program) }}" class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-center">
                            {{ $enrollments->links() }}
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-graduation-cap fa-3x text-muted mb-3"></i>
                            <h4>No Training History</h4>
                            <p class="text-muted">You haven't enrolled in any training programs yet.</p>
                            <a href="{{ route('training.index') }}" class="btn btn-primary">
                                <i class="bi bi-search"></i> Browse Training Programs
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection