@extends('layouts.app')

@section('title', 'Record Training Performance Impact')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header 
                title="Record Training Performance Impact"
                backUrl="{{ route('training.performance.index') }}"
                backText="Back to Performance Impact" />

            <div class="card">
                <div class="card-body">
                    <form method="POST" action="{{ route('training.performance.store') }}">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <x-form.select 
                                    name="employee_id" 
                                    label="Employee" 
                                    required
                                    :value="old('employee_id', $selectedEmployee?->id)"
                                    :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' - ' . $e->position?->title])->toArray()" />
                            </div>
                            
                            <div class="col-md-6">
                                <x-form.select 
                                    name="training_program_id" 
                                    label="Training Program" 
                                    required
                                    :value="old('training_program_id', $selectedProgram?->id)"
                                    :options="$trainingPrograms->mapWithKeys(fn($p) => [$p->id => $p->title . ' (' . $p->category->name . ')'])->toArray()" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.select 
                                    name="performance_review_id" 
                                    label="Related Performance Review"
                                    :options="$performanceReviews->mapWithKeys(fn($r) => [$r->id => $r->employee->full_name . ' - ' . $r->review_period_start->format('M Y') . ' to ' . $r->review_period_end->format('M Y')])->toArray()" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.input 
                                    type="number" 
                                    name="performance_score_before" 
                                    label="Performance Score Before Training" 
                                    required
                                    min="0"
                                    max="5"
                                    step="0.1"
                                    help="Scale: 0.0 - 5.0" />
                            </div>
                            
                            <div class="col-md-6">
                                <x-form.input 
                                    type="number" 
                                    name="performance_score_after" 
                                    label="Performance Score After Training" 
                                    required
                                    min="0"
                                    max="5"
                                    step="0.1"
                                    help="Scale: 0.0 - 5.0" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.input 
                                    type="date" 
                                    name="training_completed_date" 
                                    label="Training Completed Date" 
                                    required />
                            </div>
                            
                            <div class="col-md-6">
                                <x-form.input 
                                    type="date" 
                                    name="performance_measured_date" 
                                    label="Performance Measured Date" 
                                    required
                                    help="Must be on or after training completion date" />
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Skill Improvements</label>
                            <div id="skill-improvements">
                                @if(old('skill_improvements'))
                                    @foreach(old('skill_improvements') as $skill => $improvement)
                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <input type="text" class="form-control" name="skill_improvements_skill[]" 
                                                       value="{{ $skill }}" placeholder="Skill name">
                                            </div>
                                            <div class="col-md-4">
                                                <input type="number" class="form-control" name="skill_improvements_value[]" 
                                                       value="{{ $improvement }}" min="-5" max="5" step="0.1" 
                                                       placeholder="Improvement (+/-)">
                                            </div>
                                            <div class="col-md-2">
                                                <button type="button" class="btn btn-outline-danger remove-skill">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="row mb-2">
                                        <div class="col-md-6">
                                            <input type="text" class="form-control" name="skill_improvements_skill[]" 
                                                   placeholder="Skill name">
                                        </div>
                                        <div class="col-md-4">
                                            <input type="number" class="form-control" name="skill_improvements_value[]" 
                                                   min="-5" max="5" step="0.1" placeholder="Improvement (+/-)">
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-outline-danger remove-skill">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-skill">
                                <i class="bi bi-plus"></i> Add Skill Improvement
                            </button>
                        </div>

                        <x-form.textarea 
                            name="impact_notes" 
                            label="Impact Notes"
                            rows="4"
                            placeholder="Additional notes about the training impact, observations, feedback..." />

                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            <strong>Performance Impact Calculation:</strong>
                            <div id="impact-preview" class="mt-2">
                                <span class="badge bg-secondary">Enter scores to see impact calculation</span>
                            </div>
                        </div>

                        <x-form.button-group 
                            cancelUrl="{{ route('training.performance.index') }}"
                            submitText="Record Impact"
                            submitIcon="bi-check" />
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const beforeScore = document.getElementById('performance_score_before');
    const afterScore = document.getElementById('performance_score_after');
    const impactPreview = document.getElementById('impact-preview');
    
    function updateImpactPreview() {
        const before = parseFloat(beforeScore.value) || 0;
        const after = parseFloat(afterScore.value) || 0;
        
        if (before > 0 && after > 0) {
            const improvement = after - before;
            const percentage = ((improvement / before) * 100).toFixed(1);
            
            let badgeClass = 'bg-secondary';
            let icon = 'dash';
            
            if (improvement > 0) {
                badgeClass = 'bg-success';
                icon = 'arrow-up';
            } else if (improvement < 0) {
                badgeClass = 'bg-danger';
                icon = 'arrow-down';
            }
            
            impactPreview.innerHTML = `
                <span class="badge ${badgeClass}">
                    <i class="bi bi-${icon}"></i> 
                    ${improvement > 0 ? '+' : ''}${improvement.toFixed(2)} points 
                    (${improvement > 0 ? '+' : ''}${percentage}%)
                </span>
            `;
        }
    }
    
    beforeScore.addEventListener('input', updateImpactPreview);
    afterScore.addEventListener('input', updateImpactPreview);
    
    // Add skill improvement
    document.getElementById('add-skill').addEventListener('click', function() {
        const container = document.getElementById('skill-improvements');
        const div = document.createElement('div');
        div.className = 'row mb-2';
        div.innerHTML = `
            <div class="col-md-6">
                <input type="text" class="form-control" name="skill_improvements_skill[]" 
                       placeholder="Skill name">
            </div>
            <div class="col-md-4">
                <input type="number" class="form-control" name="skill_improvements_value[]" 
                       min="-5" max="5" step="0.1" placeholder="Improvement (+/-)">
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-outline-danger remove-skill">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
        `;
        container.appendChild(div);
    });
    
    // Remove skill improvement
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-skill')) {
            const skills = document.querySelectorAll('#skill-improvements .row');
            if (skills.length > 1) {
                e.target.closest('.row').remove();
            }
        }
    });
    
    // Validate performance measured date
    const trainingDate = document.getElementById('training_completed_date');
    const measuredDate = document.getElementById('performance_measured_date');
    
    trainingDate.addEventListener('change', function() {
        measuredDate.min = this.value;
        if (measuredDate.value && measuredDate.value < this.value) {
            measuredDate.value = this.value;
        }
    });
});
</script>
@endpush
@endsection
