@extends('layouts.app')
@section('title', 'Training Performance Impact Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Training Performance', 'url' => route('training.performance.index')],
    ['label' => 'Details']
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Performance Impact Details</h1>
                <div class="btn-group">
                    <a href="{{ route('training.performance.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to List
                    </a>
                    @can('update', $impact)
                        <a href="{{ route('training.performance.edit', $impact) }}" class="btn btn-primary">
                            <i class="bi bi-pencil"></i> Edit
                        </a>
                    @endcan
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <x-info-card title="Performance Impact Details" icon="graph-up">
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <h6 class="text-muted">Employee</h6>
                                <p class="mb-0">
                                    <strong>{{ $impact->employee->full_name }}</strong><br>
                                    <small class="text-muted">{{ $impact->employee->position?->title }}</small><br>
                                    <small class="text-muted">{{ $impact->employee->department?->name }}</small>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <h6 class="text-muted">Training Program</h6>
                                <p class="mb-0">
                                    <strong>{{ $impact->trainingProgram->title }}</strong><br>
                                    <small class="text-muted">{{ $impact->trainingProgram->category->name }}</small><br>
                                    <small class="text-muted">{{ $impact->trainingProgram->duration_hours }} hours</small>
                                </p>
                            </div>
                        </div>

                        <table class="table table-borderless">
                            <x-detail-row label="Training Completed" :value="$impact->training_completed_date->format('M j, Y')" />
                            <x-detail-row label="Performance Measured" :value="$impact->performance_measured_date->format('M j, Y')" />
                            @if($impact->performanceReview)
                                <x-detail-row label="Related Performance Review">
                                    {{ $impact->performanceReview->review_period_start->format('M Y') }} - 
                                    {{ $impact->performanceReview->review_period_end->format('M Y') }}
                                </x-detail-row>
                            @endif
                            @if($impact->impact_notes)
                                <x-detail-row label="Impact Notes" :value="$impact->impact_notes" />
                            @endif
                            <x-detail-row label="Measured By">
                                {{ $impact->measuredBy->name }}<br>
                                <small class="text-muted">{{ $impact->created_at->format('M j, Y g:i A') }}</small>
                            </x-detail-row>
                        </table>
                    </x-info-card>
                </div>

                <div class="col-md-4">
                    <x-info-card title="Performance Scores" icon="speedometer2" class="mb-4">
                        <div class="text-center mb-3">
                            <div class="row">
                                <div class="col-6">
                                    <h6 class="text-muted">Before Training</h6>
                                    <h3 class="text-secondary">{{ number_format($impact->performance_score_before, 2) }}</h3>
                                </div>
                                <div class="col-6">
                                    <h6 class="text-muted">After Training</h6>
                                    <h3 class="text-primary">{{ number_format($impact->performance_score_after, 2) }}</h3>
                                </div>
                            </div>
                        </div>

                        <div class="text-center">
                            @php
                                $improvement = $impact->performance_score_after - $impact->performance_score_before;
                                $percentage = $impact->performance_score_before > 0 ? (($improvement / $impact->performance_score_before) * 100) : 0;
                                $badgeClass = $improvement > 0 ? 'bg-success' : ($improvement < 0 ? 'bg-danger' : 'bg-secondary');
                                $icon = $improvement > 0 ? 'arrow-up' : ($improvement < 0 ? 'arrow-down' : 'dash');
                            @endphp
                            <h6 class="text-muted mb-2">Performance Change</h6>
                            <span class="badge {{ $badgeClass }} fs-5">
                                <i class="bi bi-{{ $icon }}"></i> 
                                {{ $improvement > 0 ? '+' : '' }}{{ number_format($improvement, 2) }} points 
                                ({{ $improvement > 0 ? '+' : '' }}{{ number_format($percentage, 1) }}%)
                            </span>
                        </div>
                    </x-info-card>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
