@extends('layouts.app')

@section('title', 'Create Training Program')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-breadcrumb :items="[
                ['label' => 'Training Programs', 'url' => route('training.programs.index')],
                ['label' => 'Create Program']
            ]" />
            
            <x-page-header title="Create Training Program" description="Set up a new training program" />

            <form method="POST" action="{{ route('training.programs.store') }}">
                @csrf
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">Basic Information</h5>
                            </div>
                            <div class="card-body">
                                <x-form.input name="title" label="Program Title" required />

                                <x-form.textarea name="description" label="Description" required rows="4" />

                                <x-form.textarea name="content_outline" label="Content Outline" rows="6" />

                                <div class="mb-3">
                                    <label for="learning_objectives" class="form-label">Learning Objectives</label>
                                    <div id="learning-objectives-container">
                                        @if(old('learning_objectives'))
                                            @foreach(old('learning_objectives') as $index => $objective)
                                                <div class="input-group mb-2">
                                                    <input type="text" class="form-control" name="learning_objectives[]" value="{{ $objective }}">
                                                    <button type="button" class="btn btn-outline-danger remove-objective">
                                                        <i class="bi bi-x-circle"></i>
                                                    </button>
                                                </div>
                                            @endforeach
                                        @else
                                            <div class="input-group mb-2">
                                                <input type="text" class="form-control" name="learning_objectives[]" placeholder="Enter learning objective">
                                                <button type="button" class="btn btn-outline-danger remove-objective">
                                                    <i class="bi bi-x-circle"></i>
                                                </button>
                                            </div>
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-primary" id="add-objective">
                                        <i class="bi bi-plus"></i> Add Objective
                                    </button>
                                </div>

                                <div class="mb-3">
                                    <label for="prerequisites" class="form-label">Prerequisites</label>
                                    <div id="prerequisites-container">
                                        @if(old('prerequisites'))
                                            @foreach(old('prerequisites') as $index => $prerequisite)
                                                <div class="input-group mb-2">
                                                    <input type="text" class="form-control" name="prerequisites[]" value="{{ $prerequisite }}">
                                                    <button type="button" class="btn btn-outline-danger remove-prerequisite">
                                                        <i class="bi bi-x-circle"></i>
                                                    </button>
                                                </div>
                                            @endforeach
                                        @else
                                            <div class="input-group mb-2">
                                                <input type="text" class="form-control" name="prerequisites[]" placeholder="Enter prerequisite">
                                                <button type="button" class="btn btn-outline-danger remove-prerequisite">
                                                    <i class="bi bi-x-circle"></i>
                                                </button>
                                            </div>
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-primary" id="add-prerequisite">
                                        <i class="bi bi-plus"></i> Add Prerequisite
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">Program Settings</h5>
                            </div>
                            <div class="card-body">
                                <x-form.select 
                                    name="training_category_id" 
                                    label="Category" 
                                    required
                                    :options="$categories->pluck('name', 'id')->toArray()" />

                                <x-form.select 
                                    name="type" 
                                    label="Type" 
                                    required
                                    :options="[
                                        'internal' => 'Internal',
                                        'external' => 'External',
                                        'online' => 'Online',
                                        'workshop' => 'Workshop',
                                        'seminar' => 'Seminar',
                                        'certification' => 'Certification'
                                    ]" />

                                <x-form.select 
                                    name="delivery_method" 
                                    label="Delivery Method" 
                                    required
                                    :options="[
                                        'in_person' => 'In Person',
                                        'virtual' => 'Virtual',
                                        'hybrid' => 'Hybrid',
                                        'self_paced' => 'Self Paced'
                                    ]" />

                                <x-form.select 
                                    name="difficulty_level" 
                                    label="Difficulty Level" 
                                    required
                                    :options="[
                                        'beginner' => 'Beginner',
                                        'intermediate' => 'Intermediate',
                                        'advanced' => 'Advanced'
                                    ]" />

                                <x-form.input 
                                    type="number" 
                                    name="duration_hours" 
                                    label="Duration (Hours)" 
                                    required
                                    min="0.5"
                                    step="0.5" />

                                <div class="mb-3">
                                    <label for="cost_per_participant" class="form-label">Cost per Participant</label>
                                    <div class="input-group">
                                        <span class="input-group-text">$</span>
                                        <input type="number" class="form-control @error('cost_per_participant') is-invalid @enderror" 
                                               id="cost_per_participant" name="cost_per_participant" 
                                               value="{{ old('cost_per_participant', 0) }}" min="0" step="0.01">
                                    </div>
                                    @error('cost_per_participant')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <x-form.input 
                                    type="number" 
                                    name="max_participants" 
                                    label="Max Participants"
                                    min="1" />

                                <x-form.checkbox name="is_mandatory" label="Mandatory Training" />
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">Instructor Information</h5>
                            </div>
                            <div class="card-body">
                                <x-form.input name="instructor_name" label="Instructor Name" />

                                <x-form.input type="email" name="instructor_email" label="Instructor Email" />

                                <x-form.input name="provider_name" label="Training Provider" />
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-body">
                                <x-form.button-group 
                                    cancelUrl="{{ route('training.programs.index') }}"
                                    submitText="Create Program"
                                    submitIcon="bi-save" />
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add learning objective
    document.getElementById('add-objective').addEventListener('click', function() {
        const container = document.getElementById('learning-objectives-container');
        const div = document.createElement('div');
        div.className = 'input-group mb-2';
        div.innerHTML = `
            <input type="text" class="form-control" name="learning_objectives[]" placeholder="Enter learning objective">
            <button type="button" class="btn btn-outline-danger remove-objective">
                <i class="bi bi-x-circle"></i>
            </button>
        `;
        container.appendChild(div);
    });

    // Remove learning objective
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-objective')) {
            e.target.closest('.input-group').remove();
        }
    });

    // Add prerequisite
    document.getElementById('add-prerequisite').addEventListener('click', function() {
        const container = document.getElementById('prerequisites-container');
        const div = document.createElement('div');
        div.className = 'input-group mb-2';
        div.innerHTML = `
            <input type="text" class="form-control" name="prerequisites[]" placeholder="Enter prerequisite">
            <button type="button" class="btn btn-outline-danger remove-prerequisite">
                <i class="bi bi-x-circle"></i>
            </button>
        `;
        container.appendChild(div);
    });

    // Remove prerequisite
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-prerequisite')) {
            e.target.closest('.input-group').remove();
        }
    });
});
</script>
@endsection