@extends('layouts.app')

@section('title', 'Manage Training Programs')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Manage Training Programs</h1>
                @can('create', App\Models\TrainingProgram::class)
                    <a href="{{ route('training.programs.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus"></i> Create Program
                    </a>
                @endcan
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="{{ route('training.programs.index') }}">
                        <div class="row">
                            <div class="col-md-3">
                                <select name="category" class="form-select">
                                    <option value="">All Categories</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="type" class="form-select">
                                    <option value="">All Types</option>
                                    <option value="internal" {{ request('type') == 'internal' ? 'selected' : '' }}>Internal</option>
                                    <option value="external" {{ request('type') == 'external' ? 'selected' : '' }}>External</option>
                                    <option value="online" {{ request('type') == 'online' ? 'selected' : '' }}>Online</option>
                                    <option value="workshop" {{ request('type') == 'workshop' ? 'selected' : '' }}>Workshop</option>
                                    <option value="seminar" {{ request('type') == 'seminar' ? 'selected' : '' }}>Seminar</option>
                                    <option value="certification" {{ request('type') == 'certification' ? 'selected' : '' }}>Certification</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="status" class="form-select">
                                    <option value="">All Status</option>
                                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                            <div class="col-md-5">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" placeholder="Search programs..." value="{{ request('search') }}">
                                    <button class="btn btn-outline-secondary" type="submit">
                                        <i class="bi bi-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Programs Table -->
            <div class="card">
                <div class="card-body">
                    @if($programs->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Program</th>
                                        <th>Category</th>
                                        <th>Type</th>
                                        <th>Duration</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($programs as $program)
                                        <tr>
                                            <td>
                                                <div>
                                                    <strong>{{ $program->title }}</strong>
                                                    @if($program->is_mandatory)
                                                        <span class="badge badge-warning ms-1">Mandatory</span>
                                                    @endif
                                                    <br>
                                                    <small class="text-muted">{{ Str::limit($program->description, 60) }}</small>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="badge" style="background-color: {{ $program->category->color }}">
                                                    {{ $program->category->name }}
                                                </span>
                                            </td>
                                            <td>{{ ucfirst($program->type) }}</td>
                                            <td>{{ $program->formatted_duration }}</td>
                                            <td>
                                                <span class="badge badge-{{ $program->is_active ? 'success' : 'secondary' }}">
                                                    {{ $program->is_active ? 'Active' : 'Inactive' }}
                                                </span>
                                            </td>
                                            <td>{{ $program->created_at->format('M j, Y') }}</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    @can('view', $program)
                                                        <a href="{{ route('training.programs.show', $program) }}" class="btn btn-sm btn-outline-primary">
                                                            <i class="bi bi-eye"></i>
                                                        </a>
                                                    @endcan
                                                    @can('update', $program)
                                                        <a href="{{ route('training.programs.edit', $program) }}" class="btn btn-sm btn-outline-secondary">
                                                            <i class="bi bi-pencil"></i>
                                                        </a>
                                                    @endcan
                                                    @can('create', App\Models\TrainingSession::class)
                                                        <a href="{{ route('training.sessions.create', ['program_id' => $program->id]) }}" class="btn btn-sm btn-outline-success">
                                                            <i class="bi bi-calendar-plus"></i>
                                                        </a>
                                                    @endcan
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-center">
                            {{ $programs->withQueryString()->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-book fa-3x text-muted mb-3"></i>
                            <h4>No Training Programs Found</h4>
                            <p class="text-muted">No training programs match your current filters.</p>
                            @can('create', App\Models\TrainingProgram::class)
                                <a href="{{ route('training.programs.create') }}" class="btn btn-primary">
                                    <i class="bi bi-plus"></i> Create First Program
                                </a>
                            @endcan
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection