@extends('layouts.app')
@section('title', $program->title)
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Training Programs', 'url' => route('training.programs.index')],
    ['label' => $program->title]
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">{{ $program->title }}</h1>
                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="bi bi-cog"></i> Actions
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="{{ route('training.programs.edit', $program) }}">
                            <i class="bi bi-pencil"></i> Edit Program
                        </a></li>
                        <li><a class="dropdown-item" href="{{ route('training.sessions.create', ['program_id' => $program->id]) }}">
                            <i class="bi bi-calendar-plus"></i> Schedule Session
                        </a></li>
                    </ul>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-8">
                    <x-info-card>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5 class="mb-0">Program Details</h5>
                            <span class="badge" style="background-color: {{ $program->category->color }}">
                                {{ $program->category->name }}
                            </span>
                        </div>
                        <p class="card-text">{{ $program->description }}</p>

                        @if($program->content_outline)
                            <h6>Content Outline</h6>
                            <div class="mb-3">{{ $program->content_outline }}</div>
                        @endif

                        @if($program->learning_objectives && count($program->learning_objectives) > 0)
                            <h6>Learning Objectives</h6>
                            <ul class="list-unstyled">
                                @foreach($program->learning_objectives as $objective)
                                    <li><i class="bi bi-check-circle text-success me-2"></i>{{ $objective }}</li>
                                @endforeach
                            </ul>
                        @endif

                        @if($program->prerequisites && count($program->prerequisites) > 0)
                            <h6>Prerequisites</h6>
                            <ul class="list-unstyled">
                                @foreach($program->prerequisites as $prerequisite)
                                    <li><i class="bi bi-info-circle text-info me-2"></i>{{ $prerequisite }}</li>
                                @endforeach
                            </ul>
                        @endif
                    </x-info-card>

                    @if($program->materials->count() > 0)
                        <x-info-card title="Training Materials" class="mt-4">
                            @foreach($program->materials as $material)
                                <div class="d-flex align-items-center mb-2">
                                    <i class="{{ $material->type_icon }} me-2"></i>
                                    <div class="flex-grow-1">
                                        <strong>{{ $material->title }}</strong>
                                        @if($material->description)
                                            <br><small class="text-muted">{{ $material->description }}</small>
                                        @endif
                                    </div>
                                    @if($material->is_required)
                                        <span class="badge bg-warning me-2">Required</span>
                                    @endif
                                    @if($material->file_url)
                                        <a href="{{ $material->file_url }}" class="btn btn-sm btn-outline-primary" target="_blank">
                                            <i class="bi bi-download"></i>
                                        </a>
                                    @endif
                                </div>
                            @endforeach
                        </x-info-card>
                    @endif

                    <x-info-card title="Enrollment Statistics" class="mt-4">
                        <div class="row text-center">
                            <div class="col-md-3">
                                <h4 class="text-primary">{{ $enrollmentStats['total_enrollments'] }}</h4>
                                <small class="text-muted">Total Enrollments</small>
                            </div>
                            <div class="col-md-3">
                                <h4 class="text-success">{{ $enrollmentStats['completed'] }}</h4>
                                <small class="text-muted">Completed</small>
                            </div>
                            <div class="col-md-3">
                                <h4 class="text-warning">{{ $enrollmentStats['in_progress'] }}</h4>
                                <small class="text-muted">In Progress</small>
                            </div>
                            <div class="col-md-3">
                                <h4 class="text-info">{{ number_format($enrollmentStats['completion_rate'], 1) }}%</h4>
                                <small class="text-muted">Completion Rate</small>
                            </div>
                        </div>
                    </x-info-card>
                </div>

                <div class="col-lg-4">
                    <x-info-card title="Program Information">
                        <table class="table table-sm table-borderless">
                            <x-detail-row label="Type" :value="ucfirst($program->type)" />
                            <x-detail-row label="Delivery" :value="ucfirst(str_replace('_', ' ', $program->delivery_method))" />
                            <x-detail-row label="Duration" :value="$program->formatted_duration" />
                            @if($program->max_participants)
                            <x-detail-row label="Max Participants" :value="$program->max_participants" />
                            @endif
                            @if($program->cost_per_participant > 0)
                            <x-detail-row label="Cost" :value="'Ksh' . number_format($program->cost_per_participant, 2)" />
                            @endif
                            <x-detail-row label="Status">
                                <x-status-badge :status="$program->is_active ? 'active' : 'inactive'" />
                            </x-detail-row>
                        </table>
                    </x-info-card>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
