@extends('layouts.app')

@section('title', 'Create Training Recommendation')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header 
                title="Create Training Recommendation"
                backUrl="{{ route('training.recommendations.index') }}"
                backText="Back to Recommendations" />

            <div class="card">
                <div class="card-body">
                    <form method="POST" action="{{ route('training.recommendations.store') }}">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <x-form.select 
                                    name="employee_id" 
                                    label="Employee" 
                                    required
                                    :value="old('employee_id', $selectedEmployee?->id)"
                                    :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' - ' . $e->position?->title])->toArray()" />
                            </div>
                            
                            <div class="col-md-6">
                                <x-form.select 
                                    name="training_program_id" 
                                    label="Training Program" 
                                    required
                                    :value="old('training_program_id', $selectedProgram?->id)"
                                    :options="$trainingPrograms->mapWithKeys(fn($p) => [$p->id => $p->title . ' (' . $p->category->name . ')'])->toArray()" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.select 
                                    name="recommendation_type" 
                                    label="Recommendation Type" 
                                    required
                                    :options="[
                                        'skill_gap' => 'Skill Gap',
                                        'performance_improvement' => 'Performance Improvement',
                                        'career_development' => 'Career Development',
                                        'mandatory' => 'Mandatory Training',
                                        'peer_suggestion' => 'Peer Suggestion'
                                    ]" />
                            </div>
                            
                            <div class="col-md-6">
                                <x-form.input 
                                    type="number" 
                                    name="priority_score" 
                                    label="Priority Score (1-100)" 
                                    required
                                    min="1"
                                    max="100"
                                    :value="old('priority_score', 50)"
                                    help="1-49: Low Priority, 50-79: Medium Priority, 80-100: High Priority" />
                            </div>
                        </div>

                        <x-form.textarea 
                            name="reason" 
                            label="Reason for Recommendation" 
                            required
                            rows="4"
                            placeholder="Explain why this training is recommended for the employee..." />

                        <div class="mb-3">
                            <label class="form-label">Supporting Data (Optional)</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <x-form.textarea 
                                        name="supporting_data[skill_gap]" 
                                        label="Skill Gap Details"
                                        rows="2"
                                        placeholder="Current skill level vs required level..." />
                                </div>
                                <div class="col-md-6">
                                    <x-form.textarea 
                                        name="supporting_data[performance_data]" 
                                        label="Performance Data"
                                        rows="2"
                                        placeholder="Performance review scores, feedback..." />
                                </div>
                            </div>
                        </div>

                        <x-form.button-group 
                            cancelUrl="{{ route('training.recommendations.index') }}"
                            submitText="Create Recommendation"
                            submitIcon="bi-check" />
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('recommendation_type');
    const priorityInput = document.getElementById('priority_score');
    
    typeSelect.addEventListener('change', function() {
        // Auto-adjust priority based on type
        switch(this.value) {
            case 'mandatory':
                priorityInput.value = 90;
                break;
            case 'performance_improvement':
                priorityInput.value = 80;
                break;
            case 'skill_gap':
                priorityInput.value = 70;
                break;
            case 'career_development':
                priorityInput.value = 60;
                break;
            case 'peer_suggestion':
                priorityInput.value = 40;
                break;
        }
    });
});
</script>
@endpush
@endsection
