@extends('layouts.app')
@section('title', 'Training Recommendation Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Training Recommendations', 'url' => route('training.recommendations.index')],
    ['label' => 'Details']
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <x-info-card>
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="mb-0">Training Recommendation</h4>
                    <div>
                        @can('update', $recommendation)
                        <a href="{{ route('training.recommendations.edit', $recommendation) }}" class="btn btn-outline-primary">
                            <i class="bi bi-pencil"></i> Edit
                        </a>
                        @endcan
                        <a href="{{ route('training.recommendations.index') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-md-6">
                        <h6 class="text-muted">Employee</h6>
                        <p class="mb-0">
                            <strong>{{ $recommendation->employee->full_name }}</strong><br>
                            <small class="text-muted">{{ $recommendation->employee->position?->title }}</small><br>
                            <small class="text-muted">{{ $recommendation->employee->department?->name }}</small>
                        </p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-muted">Recommended Program</h6>
                        <p class="mb-0">
                            <strong>{{ $recommendation->trainingProgram->title }}</strong><br>
                            <small class="text-muted">{{ $recommendation->trainingProgram->category->name }}</small>
                        </p>
                    </div>
                </div>

                <table class="table table-borderless">
                    <x-detail-row label="Recommended By" :value="$recommendation->recommendedBy->name" />
                    <x-detail-row label="Recommendation Date" :value="$recommendation->recommendation_date->format('M d, Y')" />
                    <x-detail-row label="Priority">
                        <span class="badge bg-{{ $recommendation->priority == 'high' ? 'danger' : ($recommendation->priority == 'medium' ? 'warning' : 'secondary') }}">
                            {{ ucfirst($recommendation->priority) }}
                        </span>
                    </x-detail-row>
                    <x-detail-row label="Status">
                        <x-status-badge :status="$recommendation->status" />
                    </x-detail-row>
                    @if($recommendation->target_completion_date)
                    <x-detail-row label="Target Completion" :value="$recommendation->target_completion_date->format('M d, Y')" />
                    @endif
                </table>

                @if($recommendation->reason)
                <div class="mb-3">
                    <h6 class="text-muted">Reason for Recommendation</h6>
                    <div class="bg-light p-3 rounded">
                        {{ $recommendation->reason }}
                    </div>
                </div>
                @endif

                @if($recommendation->expected_outcomes)
                <div class="mb-3">
                    <h6 class="text-muted">Expected Outcomes</h6>
                    <div class="bg-light p-3 rounded">
                        {{ $recommendation->expected_outcomes }}
                    </div>
                </div>
                @endif

                @if($recommendation->notes)
                <div class="mb-3">
                    <h6 class="text-muted">Additional Notes</h6>
                    <div class="bg-light p-3 rounded">
                        {{ $recommendation->notes }}
                    </div>
                </div>
                @endif

                @if($recommendation->status == 'approved' && $recommendation->approved_by)
                <div class="mt-4">
                    <x-alert type="success" dismissible="false">
                        <strong>Approved</strong> by {{ $recommendation->approver->name }} 
                        on {{ $recommendation->approved_at->format('M d, Y') }}
                    </x-alert>
                </div>
                @endif

                @if($recommendation->status == 'rejected' && $recommendation->rejection_reason)
                <div class="mt-4">
                    <x-alert type="danger" dismissible="false">
                        <strong>Rejected:</strong> {{ $recommendation->rejection_reason }}
                    </x-alert>
                </div>
                @endif
            </x-info-card>
        </div>
    </div>
</div>
@endsection
