@extends('layouts.app')

@section('title', 'Edit Training Session')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Edit Training Session</h1>
                <a href="{{ route('training.sessions.show', $session) }}" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Session
                </a>
            </div>

            <div class="row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Session Details</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('training.sessions.update', $session) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="mb-3">
                                    <label for="training_program_id" class="form-label">Training Program <span class="text-danger">*</span></label>
                                    <select class="form-select @error('training_program_id') is-invalid @enderror" 
                                            id="training_program_id" name="training_program_id" required>
                                        <option value="">Select Program</option>
                                        @foreach($programs as $program)
                                            <option value="{{ $program->id }}" 
                                                    {{ old('training_program_id', $session->training_program_id) == $program->id ? 'selected' : '' }}>
                                                {{ $program->title }} ({{ $program->category->name }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('training_program_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="start_datetime" class="form-label">Start Date & Time <span class="text-danger">*</span></label>
                                            <input type="datetime-local" 
                                                   class="form-control @error('start_datetime') is-invalid @enderror" 
                                                   id="start_datetime" name="start_datetime" 
                                                   value="{{ old('start_datetime', $session->start_datetime->format('Y-m-d\TH:i')) }}" required>
                                            @error('start_datetime')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="end_datetime" class="form-label">End Date & Time <span class="text-danger">*</span></label>
                                            <input type="datetime-local" 
                                                   class="form-control @error('end_datetime') is-invalid @enderror" 
                                                   id="end_datetime" name="end_datetime" 
                                                   value="{{ old('end_datetime', $session->end_datetime->format('Y-m-d\TH:i')) }}" required>
                                            @error('end_datetime')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="location" class="form-label">Location</label>
                                            <input type="text" class="form-control @error('location') is-invalid @enderror" 
                                                   id="location" name="location" 
                                                   value="{{ old('location', $session->location) }}"
                                                   placeholder="e.g., Conference Room A, Building 1">
                                            @error('location')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="virtual_meeting_link" class="form-label">Virtual Meeting Link</label>
                                            <input type="url" class="form-control @error('virtual_meeting_link') is-invalid @enderror" 
                                                   id="virtual_meeting_link" name="virtual_meeting_link" 
                                                   value="{{ old('virtual_meeting_link', $session->virtual_meeting_link) }}"
                                                   placeholder="https://zoom.us/j/...">
                                            @error('virtual_meeting_link')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="max_participants" class="form-label">Max Participants</label>
                                            <input type="number" min="1" 
                                                   class="form-control @error('max_participants') is-invalid @enderror" 
                                                   id="max_participants" name="max_participants" 
                                                   value="{{ old('max_participants', $session->max_participants) }}"
                                                   placeholder="Leave empty to use program default">
                                            @error('max_participants')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="instructor_id" class="form-label">Instructor</label>
                                            <select class="form-select @error('instructor_id') is-invalid @enderror" 
                                                    id="instructor_id" name="instructor_id">
                                                <option value="">Select Instructor</option>
                                                @foreach($instructors as $instructor)
                                                    <option value="{{ $instructor->id }}" 
                                                            {{ old('instructor_id', $session->instructor_id) == $instructor->id ? 'selected' : '' }}>
                                                        {{ $instructor->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('instructor_id')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <select class="form-select @error('status') is-invalid @enderror" 
                                            id="status" name="status" required>
                                        <option value="scheduled" {{ old('status', $session->status) == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                        <option value="in_progress" {{ old('status', $session->status) == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                                        <option value="completed" {{ old('status', $session->status) == 'completed' ? 'selected' : '' }}>Completed</option>
                                        <option value="cancelled" {{ old('status', $session->status) == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="session_notes" class="form-label">Session Notes</label>
                                    <textarea class="form-control @error('session_notes') is-invalid @enderror" 
                                              id="session_notes" name="session_notes" rows="4"
                                              placeholder="Any special instructions or notes for this session...">{{ old('session_notes', $session->session_notes) }}</textarea>
                                    @error('session_notes')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="d-flex justify-content-end gap-2">
                                    <a href="{{ route('training.sessions.show', $session) }}" class="btn btn-secondary">Cancel</a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save"></i> Update Session
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h6 class="mb-0">Session Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <small class="text-muted">Session Code</small><br>
                                <strong>{{ $session->session_code }}</strong>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Current Status</small><br>
                                <span class="badge badge-{{ $session->status == 'scheduled' ? 'primary' : ($session->status == 'completed' ? 'success' : ($session->status == 'in_progress' ? 'warning' : 'secondary')) }}">
                                    {{ ucfirst(str_replace('_', ' ', $session->status)) }}
                                </span>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Created by</small><br>
                                <strong>{{ $session->creator->name }}</strong>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Created on</small><br>
                                <strong>{{ $session->created_at->format('M j, Y g:i A') }}</strong>
                            </div>
                            <div class="mb-3">
                                <small class="text-muted">Total Enrollments</small><br>
                                <strong>{{ $session->enrollments->count() }}</strong>
                            </div>
                        </div>
                    </div>

                    @if($session->enrollments->count() > 0)
                        <div class="card">
                            <div class="card-header">
                                <h6 class="mb-0">Enrollment Warning</h6>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-warning">
                                    <i class="bi bi-exclamation-triangle"></i>
                                    <strong>{{ $session->enrollments->count() }} employees</strong> are enrolled in this session.
                                    Changes to date/time will affect all participants.
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-calculate end time based on program duration when program changes
    const programSelect = document.getElementById('training_program_id');
    const startDatetime = document.getElementById('start_datetime');
    const endDatetime = document.getElementById('end_datetime');
    
    programSelect.addEventListener('change', function() {
        if (this.value && startDatetime.value) {
            // You could fetch program duration via AJAX and auto-calculate end time
            // For now, we'll just ensure end time is after start time
            updateEndTime();
        }
    });
    
    startDatetime.addEventListener('change', function() {
        updateEndTime();
    });
    
    function updateEndTime() {
        if (startDatetime.value && !endDatetime.value) {
            const startDate = new Date(startDatetime.value);
            const endDate = new Date(startDate.getTime() + (2 * 60 * 60 * 1000)); // Add 2 hours default
            endDatetime.value = endDate.toISOString().slice(0, 16);
        }
    }
});
</script>
@endpush
@endsection