<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SystemAdmin\AuditLogController as SystemAdminAuditController;
use App\Http\Controllers\Organization\AuditLogController as OrganizationAuditController;

/*
|--------------------------------------------------------------------------
| Audit Routes
|--------------------------------------------------------------------------
|
| Routes for audit log functionality, separated by user type
|
*/

// System Admin Audit Routes
Route::middleware(['auth', 'system_admin', 'permission:view_system_audit_logs'])->prefix('system-admin')->name('system-admin.')->group(function () {
    Route::get('/audit-logs', [SystemAdminAuditController::class, 'index'])->name('audit-logs.index');
    Route::get('/audit-logs/dashboard', [SystemAdminAuditController::class, 'dashboard'])->name('audit-logs.dashboard');
    Route::get('/audit-logs/{auditLog}', [SystemAdminAuditController::class, 'show'])->name('audit-logs.show');
    Route::post('/audit-logs/export', [SystemAdminAuditController::class, 'export'])->name('audit-logs.export');
    Route::get('/audit-logs/api/statistics', [SystemAdminAuditController::class, 'statistics'])->name('audit-logs.statistics');
    Route::get('/audit-logs/api/organization-comparison', [SystemAdminAuditController::class, 'organizationComparison'])->name('audit-logs.organization-comparison');
});

// Organization Audit Routes
Route::middleware(['auth', 'permission:view_organization_audit_logs'])->prefix('organization')->name('organization.')->group(function () {
    Route::get('/audit-logs', [OrganizationAuditController::class, 'index'])->name('audit-logs.index');
    Route::get('/audit-logs/dashboard', [OrganizationAuditController::class, 'dashboard'])->name('audit-logs.dashboard');
    Route::get('/audit-logs/{auditLog}', [OrganizationAuditController::class, 'show'])->name('audit-logs.show');
    Route::post('/audit-logs/export', [OrganizationAuditController::class, 'export'])->name('audit-logs.export');
    Route::get('/audit-logs/api/statistics', [OrganizationAuditController::class, 'statistics'])->name('audit-logs.statistics');
    Route::get('/audit-logs/api/user-activity-comparison', [OrganizationAuditController::class, 'userActivityComparison'])->name('audit-logs.user-activity-comparison');
});

// Legacy/General Admin Routes (for backward compatibility)
Route::middleware(['auth', 'permission:view_audit_logs'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/audit-logs', [App\Http\Controllers\Admin\AuditLogController::class, 'index'])->name('audit-logs.index');
    Route::get('/audit-logs/{auditLog}', [App\Http\Controllers\Admin\AuditLogController::class, 'show'])->name('audit-logs.show');
    Route::post('/audit-logs/export', [App\Http\Controllers\Admin\AuditLogController::class, 'export'])->name('audit-logs.export');
    Route::get('/audit-logs/api/statistics', [App\Http\Controllers\Admin\AuditLogController::class, 'statistics'])->name('audit-logs.statistics');
});