<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\Web\PayrollController as WebPayrollController;
use App\Http\Controllers\PayrollSettingsController;
use App\Http\Controllers\P9FormController;
use App\Http\Controllers\PerformanceReviewController;
use App\Http\Controllers\PerformanceGoalController;
use App\Http\Controllers\PerformanceSelfAssessmentController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\EmployeeDocumentController;
use App\Http\Controllers\Auth\LoginController;
// use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\SytemAdminController;
use App\Http\Controllers\OrganizationController;
use App\Http\Controllers\OrganizationSettingsController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\JobPostingController;
use App\Http\Controllers\PublicApplicationController;
use App\Http\Controllers\ApplicationController;
use App\Http\Controllers\RecruitmentReportsController;

// SytemAdmin routes
Route::prefix('systemadmin')->name('systemadmin.')->group(function () {
    // SytemAdmin authentication with stricter rate limiting
    Route::middleware('guest')->group(function () {
        Route::get('/login', [SytemAdminController::class, 'showLogin'])->name('login');
        Route::post('/login', [SytemAdminController::class, 'login'])
            ->middleware('throttle:3,15'); // 3 attempts per 15 minutes (stricter than org login)
    });
    
    // SytemAdmin authenticated routes
    Route::middleware(['auth', 'system_admin'])->group(function () {
        Route::get('/dashboard', [SytemAdminController::class, 'dashboard'])->name('dashboard');
        Route::resource('organizations', OrganizationController::class);
        
        // Subscription Management
        Route::prefix('subscriptions')->name('subscriptions.')->group(function () {
            Route::get('/', [App\Http\Controllers\SystemAdmin\SubscriptionManagementController::class, 'index'])->name('index');
            Route::get('/{subscription}', [App\Http\Controllers\SystemAdmin\SubscriptionManagementController::class, 'show'])->name('show');
            Route::get('/{subscription}/edit', [App\Http\Controllers\SystemAdmin\SubscriptionManagementController::class, 'edit'])->name('edit');
            Route::put('/{subscription}', [App\Http\Controllers\SystemAdmin\SubscriptionManagementController::class, 'update'])->name('update');
            Route::post('/{subscription}/extend-trial', [App\Http\Controllers\SystemAdmin\SubscriptionManagementController::class, 'extendTrial'])->name('extend-trial');
            Route::post('/{subscription}/suspend', [App\Http\Controllers\SystemAdmin\SubscriptionManagementController::class, 'suspend'])->name('suspend');
            Route::post('/{subscription}/reactivate', [App\Http\Controllers\SystemAdmin\SubscriptionManagementController::class, 'reactivate'])->name('reactivate');
            Route::post('/{subscription}/cancel', [App\Http\Controllers\SystemAdmin\SubscriptionManagementController::class, 'cancel'])->name('cancel');
        });
        
        Route::post('/logout', [SytemAdminController::class, 'logout'])->name('logout');
    });
});

// Guest routes (authentication)
Route::middleware('guest')->group(function () {
    Route::get('/', function () {
        return view('landing');
    });
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [LoginController::class, 'login'])->middleware('throttle:5,1');
    
    // Password Reset Routes
    Route::get('/forgot-password', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'showLinkRequestForm'])
         ->name('password.request');
    Route::post('/forgot-password', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'sendResetLinkEmail'])
         ->name('password.email')
         ->middleware('throttle:5,1');
    Route::get('/reset-password/{token}', [App\Http\Controllers\Auth\ResetPasswordController::class, 'showResetForm'])
         ->name('password.reset');
    Route::post('/reset-password', [App\Http\Controllers\Auth\ResetPasswordController::class, 'reset'])
         ->name('password.update')
         ->middleware('throttle:5,1');
    
    // Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register');
    // Route::post('/register', [RegisterController::class, 'register']);
});

// Email Verification Routes
Route::middleware('auth')->group(function () {
    Route::get('/email/verify', [App\Http\Controllers\Auth\VerificationController::class, 'show'])
         ->name('verification.notice');
    Route::post('/email/verify', [App\Http\Controllers\Auth\VerificationController::class, 'verifyOtp'])
         ->name('verification.verify.otp');
    Route::get('/email/verify/{id}/{hash}', [App\Http\Controllers\Auth\VerificationController::class, 'verify'])
         ->middleware(['signed', 'throttle:6,1'])
         ->name('verification.verify');
    Route::post('/email/verification-notification', [App\Http\Controllers\Auth\VerificationController::class, 'resend'])
         ->middleware('throttle:6,1')
         ->name('verification.send');
});

// Onboarding Routes
Route::middleware(['auth', 'email.verified'])->prefix('onboarding')->name('onboarding.')->group(function () {
    Route::get('/', [App\Http\Controllers\OnboardingController::class, 'index'])->name('index');
    Route::get('/welcome', [App\Http\Controllers\OnboardingController::class, 'welcome'])->name('welcome');
    Route::get('/select-plan', [App\Http\Controllers\OnboardingController::class, 'selectPlan'])->name('select-plan');
    Route::post('/select-plan', [App\Http\Controllers\OnboardingController::class, 'storePlan'])->name('store-plan');
    Route::get('/payment', [App\Http\Controllers\OnboardingController::class, 'payment'])->name('payment');
    Route::get('/complete', [App\Http\Controllers\OnboardingController::class, 'complete'])->name('complete');
    Route::get('/finish', [App\Http\Controllers\OnboardingController::class, 'finish'])->name('finish');
});

// Two-Factor Authentication Routes
Route::middleware('auth')->group(function () {
    Route::get('/two-factor', [App\Http\Controllers\Auth\TwoFactorController::class, 'show'])
         ->name('two-factor.show');
    Route::post('/two-factor/enable', [App\Http\Controllers\Auth\TwoFactorController::class, 'enable'])
         ->name('two-factor.enable');
    Route::delete('/two-factor/disable', [App\Http\Controllers\Auth\TwoFactorController::class, 'disable'])
         ->name('two-factor.disable');
    Route::post('/two-factor/recovery-codes', [App\Http\Controllers\Auth\TwoFactorController::class, 'generateRecoveryCodes'])
         ->name('two-factor.recovery-codes');
});

// Two-Factor Challenge Routes (for users not fully authenticated)
Route::middleware('guest')->group(function () {
    Route::get('/two-factor/challenge', [App\Http\Controllers\Auth\TwoFactorController::class, 'challenge'])
         ->name('two-factor.challenge');
    Route::post('/two-factor/verify', [App\Http\Controllers\Auth\TwoFactorController::class, 'verify'])
         ->name('two-factor.verify')
         ->middleware('throttle:5,1');
});

// Authenticated routes with tenant scoping
Route::middleware(['auth', 'tenant_scope'])->group(function () {

// Organization Subscription Routes (org_admin only)
Route::prefix('subscription')->name('subscription.')->middleware('role:org_admin')->group(function () {
    Route::get('/', [App\Http\Controllers\Organization\SubscriptionController::class, 'show'])->name('show');
    Route::get('/plans', [App\Http\Controllers\Organization\SubscriptionController::class, 'plans'])->name('plans');
    Route::get('/upgrade/{plan}', [App\Http\Controllers\Organization\SubscriptionController::class, 'upgrade'])->name('upgrade');
    Route::post('/upgrade/{plan}', [App\Http\Controllers\Organization\SubscriptionController::class, 'processUpgrade'])->name('process-upgrade');
    Route::get('/cancel', [App\Http\Controllers\Organization\SubscriptionController::class, 'cancelForm'])->name('cancel');
    Route::post('/cancel', [App\Http\Controllers\Organization\SubscriptionController::class, 'processCancel'])->name('process-cancel');
    
    // Status pages
    Route::get('/trial-expired', [App\Http\Controllers\Organization\SubscriptionController::class, 'trialExpired'])->name('trial-expired');
    Route::get('/required', [App\Http\Controllers\Organization\SubscriptionController::class, 'required'])->name('required');
    Route::get('/expired', [App\Http\Controllers\Organization\SubscriptionController::class, 'expired'])->name('expired');
    Route::get('/suspended', [App\Http\Controllers\Organization\SubscriptionController::class, 'suspended'])->name('suspended');
    Route::get('/cancelled', [App\Http\Controllers\Organization\SubscriptionController::class, 'show'])->name('cancelled');
});

// Organization Payment Routes (org_admin only)
Route::prefix('organization/payments')->name('organization.payments.')->middleware('role:org_admin')->group(function () {
    Route::get('/', [App\Http\Controllers\Organization\SubscriptionPaymentController::class, 'index'])->name('index');
    Route::get('/{invoice}/pay', [App\Http\Controllers\Organization\SubscriptionPaymentController::class, 'show'])->name('show');
    Route::post('/{invoice}/pay', [App\Http\Controllers\Organization\SubscriptionPaymentController::class, 'initiate'])->name('initiate');
    Route::get('/{payment}/status', [App\Http\Controllers\Organization\SubscriptionPaymentController::class, 'checkStatus'])->name('status');
    Route::post('/{payment}/query', [App\Http\Controllers\Organization\SubscriptionPaymentController::class, 'queryStatus'])->name('query');
    Route::get('/history', [App\Http\Controllers\Organization\SubscriptionPaymentController::class, 'history'])->name('history');
});

// Dashboard
Route::middleware(['auth', 'onboarding'])->get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

// Employee Loans
Route::middleware(['permission:view_payroll'])->group(function () {
    Route::get('/loans', [App\Http\Controllers\EmployeeLoanController::class, 'index'])->name('loans.index');
    Route::get('/loans/{loan}', [App\Http\Controllers\EmployeeLoanController::class, 'show'])->name('loans.show');
});

// Employee Self-Service Loans
Route::middleware(['auth'])->group(function () {
    Route::get('/my-loans', [App\Http\Controllers\EmployeeLoanController::class, 'myLoans'])->name('loans.my-loans');
    Route::get('/my-loans/request', [App\Http\Controllers\EmployeeLoanController::class, 'requestForm'])->name('loans.request');
    Route::post('/my-loans/request', [App\Http\Controllers\EmployeeLoanController::class, 'submitRequest'])->name('loans.submit-request');
});

Route::middleware(['permission:manage_payroll'])->group(function () {
    Route::get('/loans/create', [App\Http\Controllers\EmployeeLoanController::class, 'create'])->name('loans.create');
    Route::post('/loans', [App\Http\Controllers\EmployeeLoanController::class, 'store'])->name('loans.store');
    Route::get('/loans/{loan}/edit', [App\Http\Controllers\EmployeeLoanController::class, 'edit'])->name('loans.edit');
    Route::put('/loans/{loan}', [App\Http\Controllers\EmployeeLoanController::class, 'update'])->name('loans.update');
    Route::post('/loans/{loan}/approve', [App\Http\Controllers\EmployeeLoanController::class, 'approve'])->name('loans.approve');
    Route::post('/loans/{loan}/disburse', [App\Http\Controllers\EmployeeLoanController::class, 'disburse'])->name('loans.disburse');
    Route::post('/loans/{loan}/activate', [App\Http\Controllers\EmployeeLoanController::class, 'activate'])->name('loans.activate');
    Route::post('/loans/{loan}/reject', [App\Http\Controllers\EmployeeLoanController::class, 'reject'])->name('loans.reject');
    Route::delete('/loans/{loan}', [App\Http\Controllers\EmployeeLoanController::class, 'destroy'])->name('loans.destroy');
});

// Employees
Route::middleware(['permission:view_employees'])->group(function () {
    Route::get('/employees', [EmployeeController::class, 'index'])->name('employees.index');
    Route::get('/employees/export', [EmployeeController::class, 'export'])->name('employees.export');
});

Route::middleware(['permission:create_employees'])->group(function () {
    Route::get('/employees/import', [EmployeeController::class, 'importView'])->name('employees.import.view');
    Route::post('/employees/import', [EmployeeController::class, 'import'])->name('employees.import');
    Route::get('/employees/template', [EmployeeController::class, 'downloadTemplate'])->name('employees.template');
    Route::get('/employees/create', [EmployeeController::class, 'create'])->name('employees.create');
    Route::post('/employees', [EmployeeController::class, 'store'])->name('employees.store');
});

Route::middleware(['permission:edit_employees'])->group(function () {
    Route::get('/employees/{employee}/edit', [EmployeeController::class, 'edit'])->name('employees.edit');
    Route::put('/employees/{employee}', [EmployeeController::class, 'update'])->name('employees.update');
});

Route::middleware(['permission:delete_employees'])->group(function () {
    Route::delete('/employees/{employee}', [EmployeeController::class, 'destroy'])->name('employees.destroy');
});

// This should come after all specific routes
Route::middleware(['permission:view_employees'])->group(function () {
    Route::get('/employees/{employee}', [EmployeeController::class, 'show'])->name('employees.show');
});

// Employee Documents (inherit employee permissions)
Route::middleware(['permission:view_employees'])->group(function () {
    Route::get('/employees/{employee}/documents', [EmployeeDocumentController::class, 'index'])->name('employees.documents.index');
    Route::get('/employees/{employee}/documents/{document}/download', [EmployeeDocumentController::class, 'download'])->name('employees.documents.download');
});

Route::middleware(['permission:create_employees'])->group(function () {
    Route::get('/employees/{employee}/documents/create', [EmployeeDocumentController::class, 'create'])->name('employees.documents.create');
    Route::post('/employees/{employee}/documents', [EmployeeDocumentController::class, 'store'])->name('employees.documents.store');
});

Route::middleware(['permission:delete_employees'])->group(function () {
    Route::delete('/employees/{employee}/documents/{document}', [EmployeeDocumentController::class, 'destroy'])->name('employees.documents.destroy');
});

// Departments
Route::middleware(['permission:view_departments'])->group(function () {
    Route::get('/departments', [DepartmentController::class, 'index'])->name('departments.index');
    Route::get('/departments/{department}', [DepartmentController::class, 'show'])->name('departments.show');
});

Route::middleware(['permission:create_departments'])->group(function () {
    Route::get('/departments/create', [DepartmentController::class, 'create'])->name('departments.create');
    Route::post('/departments', [DepartmentController::class, 'store'])->name('departments.store');
});

Route::middleware(['permission:edit_departments'])->group(function () {
    Route::get('/departments/{department}/edit', [DepartmentController::class, 'edit'])->name('departments.edit');
    Route::put('/departments/{department}', [DepartmentController::class, 'update'])->name('departments.update');
});

Route::middleware(['permission:delete_departments'])->group(function () {
    Route::delete('/departments/{department}', [DepartmentController::class, 'destroy'])->name('departments.destroy');
});

// Announcements
Route::middleware(['permission:view_announcements'])->group(function () {
    Route::get('/announcements', [App\Http\Controllers\AnnouncementController::class, 'index'])->name('announcements.index');
});

Route::middleware(['permission:create_announcements'])->group(function () {
    Route::get('/announcements/create', [App\Http\Controllers\AnnouncementController::class, 'create'])->name('announcements.create');
    Route::post('/announcements', [App\Http\Controllers\AnnouncementController::class, 'store'])->name('announcements.store');
});

Route::middleware(['permission:view_announcements'])->group(function () {
    Route::get('/announcements/{announcement}', [App\Http\Controllers\AnnouncementController::class, 'show'])->name('announcements.show');
});

Route::middleware(['permission:edit_announcements|manage_announcements'])->group(function () {
    Route::get('/announcements/{announcement}/edit', [App\Http\Controllers\AnnouncementController::class, 'edit'])->name('announcements.edit');
    Route::put('/announcements/{announcement}', [App\Http\Controllers\AnnouncementController::class, 'update'])->name('announcements.update');
    Route::post('/announcements/{announcement}/toggle-pin', [App\Http\Controllers\AnnouncementController::class, 'togglePin'])->name('announcements.toggle-pin');
    Route::post('/announcements/{announcement}/publish', [App\Http\Controllers\AnnouncementController::class, 'publish'])->name('announcements.publish');
    Route::post('/announcements/{announcement}/archive', [App\Http\Controllers\AnnouncementController::class, 'archive'])->name('announcements.archive');
});

Route::middleware(['permission:delete_announcements|manage_announcements'])->group(function () {
    Route::delete('/announcements/{announcement}', [App\Http\Controllers\AnnouncementController::class, 'destroy'])->name('announcements.destroy');
});

// Test routes for error pages (remove in production)
Route::middleware(['auth'])->group(function () {
    Route::get('/test-errors/{code}', function ($code) {
        abort($code);
    })->name('test.errors');
});

// Attendance
Route::get('/attendance', [AttendanceController::class, 'index'])->name('attendance.index');
Route::get('/attendance/create', [AttendanceController::class, 'create'])->name('attendance.create');
Route::post('/attendance', [AttendanceController::class, 'store'])->name('attendance.store');
Route::get('/attendance/{attendance}', [AttendanceController::class, 'show'])->name('attendance.show');
Route::get('/attendance/{attendance}/edit', [AttendanceController::class, 'edit'])->name('attendance.edit');
Route::put('/attendance/{attendance}', [AttendanceController::class, 'update'])->name('attendance.update');
Route::post('/attendance/employee/check-in', [AttendanceController::class, 'checkIn'])->name('attendance.employee.checkIn');
Route::post('/attendance/employee/check-out', [AttendanceController::class, 'checkOut'])->name('attendance.employee.checkOut');
Route::post('/attendance/check-in', [AttendanceController::class, 'checkIn'])->name('attendance.checkIn');
Route::post('/attendance/check-out', [AttendanceController::class, 'checkOut'])->name('attendance.checkOut');
Route::post('/attendance/{attendance}/checkout', [AttendanceController::class, 'checkout'])->name('attendance.checkout');
Route::delete('/attendance/{attendance}', [AttendanceController::class, 'destroy'])->name('attendance.destroy');
Route::get('/attendance/report', [AttendanceController::class, 'report'])->name('attendance.report');

// Leaves
Route::get('/leaves', [LeaveController::class, 'index'])->name('leaves.index');
Route::get('/leaves/calendar', [LeaveController::class, 'calendar'])->name('leaves.calendar');
Route::get('/leaves/calendar/data', [LeaveController::class, 'calendarData'])->name('leaves.calendar.data');
Route::get('/leaves/balances', [LeaveController::class, 'balances'])->name('leaves.balances');
Route::get('/leaves/balance/{employee}', [LeaveController::class, 'getBalance'])->name('leaves.getBalance');
Route::get('/leaves/create', [LeaveController::class, 'create'])->name('leaves.create');
Route::post('/leaves', [LeaveController::class, 'store'])->name('leaves.store');
Route::get('/leaves/{leaveRequest}', [LeaveController::class, 'show'])->name('leaves.show');
Route::get('/leaves/{leaveRequest}/edit', [LeaveController::class, 'edit'])->name('leaves.edit');
Route::put('/leaves/{leaveRequest}', [LeaveController::class, 'update'])->name('leaves.update');
Route::post('/leaves/{leave}/approve', [LeaveController::class, 'approve'])->name('leaves.approve');
Route::post('/leaves/{leave}/reject', [LeaveController::class, 'reject'])->name('leaves.reject');
Route::post('/leaves/{leave}/cancel', [LeaveController::class, 'cancel'])->name('leaves.cancel');

// Payroll
Route::get('/payroll', [WebPayrollController::class, 'index'])->name('payroll.index');
Route::get('/payroll/bulk', [WebPayrollController::class, 'bulk'])->name('payroll.bulk');
Route::post('/payroll/bulk', [WebPayrollController::class, 'bulkStore'])->name('payroll.bulkStore');
Route::get('/payroll/create', [WebPayrollController::class, 'create'])->name('payroll.create');
Route::post('/payroll', [WebPayrollController::class, 'store'])->name('payroll.store');
Route::get('/payroll/calculator', [WebPayrollController::class, 'calculator'])->name('payroll.calculator');
Route::post('/payroll/calculate-preview', [WebPayrollController::class, 'calculatePreview'])->name('payroll.calculatePreview');

// Payroll Settings (must come before dynamic routes)
Route::get('/payroll/settings', [PayrollSettingsController::class, 'index'])->name('payroll.settings.index');
Route::get('/payroll/settings/edit', [PayrollSettingsController::class, 'edit'])->name('payroll.settings.edit');
Route::put('/payroll/settings', [PayrollSettingsController::class, 'update'])->name('payroll.settings.update');
Route::post('/payroll/settings/reset', [PayrollSettingsController::class, 'reset'])->name('payroll.settings.reset');
Route::post('/payroll/settings/test', [PayrollSettingsController::class, 'testCalculations'])->name('payroll.settings.test');

// Loan Settings
Route::get('/loan-settings', [App\Http\Controllers\LoanSettingsController::class, 'index'])->name('loan-settings.index');
Route::get('/loan-settings/edit', [App\Http\Controllers\LoanSettingsController::class, 'edit'])->name('loan-settings.edit');
Route::put('/loan-settings', [App\Http\Controllers\LoanSettingsController::class, 'update'])->name('loan-settings.update');
Route::post('/loan-settings/reset', [App\Http\Controllers\LoanSettingsController::class, 'reset'])->name('loan-settings.reset');

Route::get('/payroll/{payroll}', [WebPayrollController::class, 'show'])->name('payroll.show');
Route::post('/payroll/{payroll}/approve', [WebPayrollController::class, 'approve'])->name('payroll.approve');
Route::post('/payroll/{payroll}/reject', [WebPayrollController::class, 'reject'])->name('payroll.reject');
Route::post('/payroll/{payroll}/process', [WebPayrollController::class, 'process'])->name('payroll.process');
Route::post('/payroll/{payroll}/mark-paid', [WebPayrollController::class, 'markPaid'])->name('payroll.markPaid');
Route::delete('/payroll/{payroll}', [WebPayrollController::class, 'destroy'])->name('payroll.destroy');

// P9 Forms (Kenya Tax Certificates)
Route::get('/p9-forms', [P9FormController::class, 'index'])->name('p9-forms.index');
Route::get('/p9-forms/create', [P9FormController::class, 'create'])->name('p9-forms.create');
Route::post('/p9-forms/generate', [P9FormController::class, 'generate'])->name('p9-forms.generate');
Route::get('/p9-forms/bulk-create', [P9FormController::class, 'bulkCreate'])->name('p9-forms.bulk-create');
Route::post('/p9-forms/bulk-generate', [P9FormController::class, 'bulkGenerate'])->name('p9-forms.bulk-generate');
Route::get('/p9-forms/{p9Form}', [P9FormController::class, 'show'])->name('p9-forms.show');
Route::get('/p9-forms/{p9Form}/pdf', [P9FormController::class, 'downloadPdf'])->name('p9-forms.pdf');

// Performance Reviews
Route::resource('performance', PerformanceReviewController::class);

// Performance Goals
Route::resource('performance-goals', PerformanceGoalController::class)->names([
    'index' => 'performance.goals.index',
    'create' => 'performance.goals.create',
    'store' => 'performance.goals.store',
    'show' => 'performance.goals.show',
    'edit' => 'performance.goals.edit',
    'update' => 'performance.goals.update',
    'destroy' => 'performance.goals.destroy',
]);
Route::post('performance-goals/{performanceGoal}/progress', [PerformanceGoalController::class, 'updateProgress'])->name('performance.goals.progress');

// Performance Self Assessments
Route::resource('performance-self-assessments', PerformanceSelfAssessmentController::class)->names([
    'index' => 'performance.self-assessments.index',
    'create' => 'performance.self-assessments.create',
    'store' => 'performance.self-assessments.store',
    'show' => 'performance.self-assessments.show',
    'edit' => 'performance.self-assessments.edit',
    'update' => 'performance.self-assessments.update',
    'destroy' => 'performance.self-assessments.destroy',
]);
Route::post('performance-self-assessments/{performanceSelfAssessment}/submit', [PerformanceSelfAssessmentController::class, 'submit'])->name('performance.self-assessments.submit');

// Reports
Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
Route::get('/reports/attendance', [ReportController::class, 'attendance'])->name('reports.attendance');
Route::get('/reports/leave', [ReportController::class, 'leave'])->name('reports.leave');
Route::get('/reports/payroll', [ReportController::class, 'payroll'])->name('reports.payroll');
Route::get('/reports/employee', [ReportController::class, 'employee'])->name('reports.employee');
Route::get('/reports/training', [ReportController::class, 'training'])->name('reports.training');
Route::get('/reports/attendance/pdf', [ReportController::class, 'exportAttendancePdf'])->name('reports.attendance.pdf');
Route::get('/reports/leave/pdf', [ReportController::class, 'exportLeavePdf'])->name('reports.leave.pdf');
Route::get('/reports/payroll/pdf', [ReportController::class, 'exportPayrollPdf'])->name('reports.payroll.pdf');
Route::get('/reports/employee/pdf', [ReportController::class, 'exportEmployeePdf'])->name('reports.employee.pdf');
Route::get('/reports/training/pdf', [ReportController::class, 'exportTrainingPdf'])->name('reports.export-training-pdf');

// Settings
Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
Route::get('/settings/organization', [OrganizationSettingsController::class, 'show'])->name('settings.organization');
Route::put('/settings/organization', [OrganizationSettingsController::class, 'update'])->name('settings.organization.update');

// Email Settings
Route::get('/settings/email-setup', [App\Http\Controllers\OrganizationEmailSettingsController::class, 'index'])->name('settings.email.index');
Route::put('/settings/email-setup', [App\Http\Controllers\OrganizationEmailSettingsController::class, 'update'])->name('settings.email.update');
Route::post('/settings/email-setup/test', [App\Http\Controllers\OrganizationEmailSettingsController::class, 'test'])->name('settings.email.test');

Route::get('/settings/attendance', [SettingsController::class, 'attendance'])->name('settings.attendance');
Route::post('/settings/attendance', [SettingsController::class, 'updateAttendance'])->name('settings.updateAttendance');
Route::get('/settings/leave-types', [SettingsController::class, 'leaveTypes'])->name('settings.leave-types');
Route::post('/settings/leave-types', [SettingsController::class, 'storeLeaveType'])->name('settings.storeLeaveType');
Route::put('/settings/leave-types/{leaveType}', [SettingsController::class, 'updateLeaveType'])->name('settings.updateLeaveType');
Route::delete('/settings/leave-types/{leaveType}', [SettingsController::class, 'deleteLeaveType'])->name('settings.deleteLeaveType');
Route::get('/settings/positions', [SettingsController::class, 'positions'])->name('settings.positions');
Route::post('/settings/positions', [SettingsController::class, 'storePosition'])->name('settings.storePosition');
Route::put('/settings/positions/{position}', [SettingsController::class, 'updatePosition'])->name('settings.updatePosition');
Route::delete('/settings/positions/{position}', [SettingsController::class, 'deletePosition'])->name('settings.deletePosition');
Route::get('/settings/holidays', [SettingsController::class, 'holidays'])->name('settings.holidays');
Route::post('/settings/holidays', [SettingsController::class, 'storeHoliday'])->name('settings.storeHoliday');
Route::put('/settings/holidays/{holiday}', [SettingsController::class, 'updateHoliday'])->name('settings.updateHoliday');
Route::delete('/settings/holidays/{holiday}', [SettingsController::class, 'deleteHoliday'])->name('settings.deleteHoliday');

// Theme Management (Organization Admins only)
Route::middleware(['role:org_admin'])->group(function () {
    Route::get('/settings/theme', [App\Http\Controllers\Settings\ThemeController::class, 'index'])->name('settings.theme.index');
    Route::post('/settings/theme', [App\Http\Controllers\Settings\ThemeController::class, 'update'])->name('settings.theme.update');
    Route::post('/settings/theme/reset', [App\Http\Controllers\Settings\ThemeController::class, 'reset'])->name('settings.theme.reset');
    Route::post('/settings/theme/upload-logo', [App\Http\Controllers\Settings\ThemeController::class, 'uploadLogo'])->name('settings.theme.uploadLogo');
    Route::delete('/settings/theme/delete-logo/{type}', [App\Http\Controllers\Settings\ThemeController::class, 'deleteLogo'])->name('settings.theme.deleteLogo');
});

// Permissions Management
Route::middleware(['permission:view_permissions'])->group(function () {
    Route::get('/permissions', [PermissionController::class, 'index'])->name('permissions.index');
});

Route::middleware(['permission:create_permissions'])->group(function () {
    Route::get('/permissions/create', [PermissionController::class, 'create'])->name('permissions.create');
    Route::post('/permissions', [PermissionController::class, 'store'])->name('permissions.store');
});

Route::middleware(['permission:edit_permissions'])->group(function () {
    Route::get('/permissions/{permission}/edit', [PermissionController::class, 'edit'])->name('permissions.edit');
    Route::put('/permissions/{permission}', [PermissionController::class, 'update'])->name('permissions.update');
});

Route::middleware(['permission:delete_permissions'])->group(function () {
    Route::delete('/permissions/{permission}', [PermissionController::class, 'destroy'])->name('permissions.destroy');
});

// Roles & Permissions (Permission-based access)
Route::middleware(['permission:view_roles'])->group(function () {
    Route::get('/roles', [RoleController::class, 'index'])->name('roles.index');
    Route::get('/roles/{role}', [RoleController::class, 'show'])->name('roles.show');
});

Route::middleware(['permission:create_roles'])->group(function () {
    Route::get('/roles/create', [RoleController::class, 'create'])->name('roles.create');
    Route::post('/roles', [RoleController::class, 'store'])->name('roles.store');
});

Route::middleware(['permission:edit_roles'])->group(function () {
    Route::get('/roles/{role}/edit', [RoleController::class, 'edit'])->name('roles.edit');
    Route::put('/roles/{role}', [RoleController::class, 'update'])->name('roles.update');
});

Route::middleware(['permission:delete_roles'])->group(function () {
    Route::delete('/roles/{role}', [RoleController::class, 'destroy'])->name('roles.destroy');
});

// User Management (Permission-based access)
Route::middleware(['permission:view_users'])->group(function () {
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::get('/users/{user}', [UserController::class, 'show'])->name('users.show');
});

Route::middleware(['permission:create_users'])->group(function () {
    Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
});

Route::middleware(['permission:edit_users'])->group(function () {
    Route::get('/users/{user}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::put('/users/{user}', [UserController::class, 'update'])->name('users.update');
    Route::put('/users/{user}/password', [UserController::class, 'updatePassword'])->name('users.updatePassword');
});

Route::middleware(['permission:delete_users'])->group(function () {
    Route::delete('/users/{user}', [UserController::class, 'destroy'])->name('users.destroy');
});

// Profile Management
Route::get('/profile', [ProfileController::class, 'show'])->name('profile.show');
Route::get('/profile/edit', [ProfileController::class, 'edit'])->name('profile.edit');
Route::put('/profile', [ProfileController::class, 'update'])->name('profile.update');
Route::get('/profile/password', [ProfileController::class, 'editPassword'])->name('profile.password.edit');
Route::put('/profile/password', [ProfileController::class, 'updatePassword'])->name('profile.password.update');

// Security Dashboard (Admin only)
Route::middleware(['permission:view_security_dashboard'])->group(function () {
    Route::get('/security', [App\Http\Controllers\SecurityDashboardController::class, 'index'])->name('security.dashboard');
    Route::get('/security/logs', [App\Http\Controllers\SecurityDashboardController::class, 'logs'])->name('security.logs');
    Route::get('/security/ip-whitelist', [App\Http\Controllers\SecurityDashboardController::class, 'ipWhitelist'])->name('security.ip-whitelist');
    Route::post('/security/ip-whitelist', [App\Http\Controllers\SecurityDashboardController::class, 'addIpToWhitelist'])->name('security.ip-whitelist.add');
    Route::delete('/security/ip-whitelist', [App\Http\Controllers\SecurityDashboardController::class, 'removeIpFromWhitelist'])->name('security.ip-whitelist.remove');
    Route::get('/security/settings', [App\Http\Controllers\SecurityDashboardController::class, 'settings'])->name('security.settings');
    Route::put('/security/settings', [App\Http\Controllers\SecurityDashboardController::class, 'updateSettings'])->name('security.settings.update');
});

// Recruitment routes (protected by auth + permissions)
Route::middleware(['auth', 'tenant_scope'])->group(function () {
    Route::resource('job-postings', JobPostingController::class);
    Route::post('job-postings/{jobPosting}/close', [JobPostingController::class, 'close'])->name('job-postings.close');
    
    // Application CV routes
    Route::get('applications/{application}/cv/view', [ApplicationController::class, 'viewCv'])->name('applications.cv.view');
    Route::get('applications/{application}/cv/download', [ApplicationController::class, 'downloadCv'])->name('applications.cv.download');
    
    // Application Status Update
    Route::post('applications/{application}/update-status', [ApplicationController::class, 'updateStatus'])->name('applications.update-status');
    
    // Interviews
    Route::post('interviews', [App\Http\Controllers\InterviewController::class, 'store'])->name('interviews.store');
    Route::get('interviews/{interview}', [App\Http\Controllers\InterviewController::class, 'show'])->name('interviews.show');
    Route::put('interviews/{interview}', [App\Http\Controllers\InterviewController::class, 'update'])->name('interviews.update');
    
    // Application Messages
    Route::get('applications/{application}/messages', [App\Http\Controllers\ApplicationMessageController::class, 'index'])->name('applications.messages');
    Route::post('applications/{application}/messages', [App\Http\Controllers\ApplicationMessageController::class, 'store'])->name('applications.messages.store');
    
    // Job Offers
    Route::get('applications/{application}/offer/create', [App\Http\Controllers\JobOfferController::class, 'create'])->name('applications.offer.create');
    Route::post('applications/{application}/offer', [App\Http\Controllers\JobOfferController::class, 'store'])->name('applications.offer.store');
    Route::resource('job-offers', App\Http\Controllers\JobOfferController::class)->except(['create', 'store']);
    Route::post('job-offers/{jobOffer}/send', [App\Http\Controllers\JobOfferController::class, 'send'])->name('job-offers.send');
    
    // Recruitment Reports
    Route::get('recruitment/reports', [RecruitmentReportsController::class, 'index'])->name('recruitment.reports.index');
    Route::get('recruitment/reports/detailed', [RecruitmentReportsController::class, 'detailed'])->name('recruitment.reports.detailed');
    Route::get('recruitment/reports/export', [RecruitmentReportsController::class, 'export'])->name('recruitment.reports.export');
    
    // Recruitment Analytics
    Route::get('recruitment/analytics', [App\Http\Controllers\RecruitmentAnalyticsController::class, 'index'])->name('recruitment.analytics');
    Route::get('recruitment/analytics/export', [App\Http\Controllers\RecruitmentAnalyticsController::class, 'export'])->name('recruitment.analytics.export');
});

// Training & Development Module
Route::prefix('training')->name('training.')->group(function () {
    // Public training catalog (accessible to all authenticated users)
    Route::middleware(['auth', 'tenant_scope'])->group(function () {
        Route::get('/', [App\Http\Controllers\TrainingController::class, 'index'])->name('index');
        
        // Employee training features
        Route::get('/my-trainings', [App\Http\Controllers\TrainingController::class, 'myTrainings'])->name('my-trainings');
        Route::post('/sessions/{session}/enroll', [App\Http\Controllers\TrainingController::class, 'enroll'])->name('enroll');
    });
    
    // Training management dashboard (admin features)
    Route::get('/dashboard', [App\Http\Controllers\TrainingController::class, 'dashboard'])->name('dashboard');
    
    // Training Programs Management
    Route::prefix('programs')->name('programs.')->group(function () {
        Route::get('/', [App\Http\Controllers\TrainingProgramController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\TrainingProgramController::class, 'create'])->name('create');
        Route::post('/', [App\Http\Controllers\TrainingProgramController::class, 'store'])->name('store');
        Route::get('/{program}', [App\Http\Controllers\TrainingProgramController::class, 'show'])->name('show');
        Route::get('/{program}/edit', [App\Http\Controllers\TrainingProgramController::class, 'edit'])->name('edit');
        Route::put('/{program}', [App\Http\Controllers\TrainingProgramController::class, 'update'])->name('update');
        Route::delete('/{program}', [App\Http\Controllers\TrainingProgramController::class, 'destroy'])->name('destroy');
        Route::post('/{program}/materials', [App\Http\Controllers\TrainingProgramController::class, 'addMaterial'])->name('add-material');
        Route::delete('/{program}/materials/{material}', [App\Http\Controllers\TrainingProgramController::class, 'removeMaterial'])->name('remove-material');
    });
    
    // Training Sessions Management
    Route::prefix('sessions')->name('sessions.')->group(function () {
        Route::get('/', [App\Http\Controllers\TrainingSessionController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\TrainingSessionController::class, 'create'])->name('create');
        Route::post('/', [App\Http\Controllers\TrainingSessionController::class, 'store'])->name('store');
        Route::get('/{session}', [App\Http\Controllers\TrainingSessionController::class, 'show'])->name('show');
        Route::get('/{session}/edit', [App\Http\Controllers\TrainingSessionController::class, 'edit'])->name('edit');
        Route::put('/{session}', [App\Http\Controllers\TrainingSessionController::class, 'update'])->name('update');
        Route::delete('/{session}', [App\Http\Controllers\TrainingSessionController::class, 'destroy'])->name('destroy');
        Route::post('/{session}/enroll-employee', [App\Http\Controllers\TrainingSessionController::class, 'enrollEmployee'])->name('enroll-employee');
        Route::post('/{session}/attendance', [App\Http\Controllers\TrainingSessionController::class, 'updateAttendance'])->name('update-attendance');
    });

    // Training Recommendations Management
    Route::prefix('recommendations')->name('recommendations.')->group(function () {
        Route::get('/', [App\Http\Controllers\TrainingRecommendationController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\TrainingRecommendationController::class, 'create'])->name('create');
        Route::post('/', [App\Http\Controllers\TrainingRecommendationController::class, 'store'])->name('store');
        Route::get('/{recommendation}', [App\Http\Controllers\TrainingRecommendationController::class, 'show'])->name('show');
        Route::post('/{recommendation}/respond', [App\Http\Controllers\TrainingRecommendationController::class, 'respond'])->name('respond');
        Route::post('/generate', [App\Http\Controllers\TrainingRecommendationController::class, 'generateRecommendations'])->name('generate');
    });

    // Learning Paths Management
    Route::prefix('learning-paths')->name('learning-paths.')->group(function () {
        Route::get('/', [App\Http\Controllers\LearningPathController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\LearningPathController::class, 'create'])->name('create');
        Route::post('/', [App\Http\Controllers\LearningPathController::class, 'store'])->name('store');
        Route::get('/my-paths', [App\Http\Controllers\LearningPathController::class, 'myPaths'])->name('my-paths');
        Route::get('/{learningPath}', [App\Http\Controllers\LearningPathController::class, 'show'])->name('show');
        Route::get('/{learningPath}/edit', [App\Http\Controllers\LearningPathController::class, 'edit'])->name('edit');
        Route::put('/{learningPath}', [App\Http\Controllers\LearningPathController::class, 'update'])->name('update');
        Route::delete('/{learningPath}', [App\Http\Controllers\LearningPathController::class, 'destroy'])->name('destroy');
        Route::post('/{learningPath}/enroll', [App\Http\Controllers\LearningPathController::class, 'enroll'])->name('enroll');
        Route::get('/enrollments/{enrollment}/progress', [App\Http\Controllers\LearningPathController::class, 'pathProgress'])->name('progress');
        Route::post('/enrollments/{enrollment}/update-progress', [App\Http\Controllers\LearningPathController::class, 'updateProgress'])->name('update-progress');
    });

    // Training Performance Impact Management
    Route::prefix('performance')->name('performance.')->group(function () {
        Route::get('/', [App\Http\Controllers\TrainingPerformanceController::class, 'index'])->name('index');
        Route::get('/create', [App\Http\Controllers\TrainingPerformanceController::class, 'create'])->name('create');
        Route::post('/', [App\Http\Controllers\TrainingPerformanceController::class, 'store'])->name('store');
        Route::get('/analytics', [App\Http\Controllers\TrainingPerformanceController::class, 'analytics'])->name('analytics');
        Route::post('/auto-track', [App\Http\Controllers\TrainingPerformanceController::class, 'autoTrack'])->name('auto-track');
        Route::get('/{impact}', [App\Http\Controllers\TrainingPerformanceController::class, 'show'])->name('show');
        Route::get('/{impact}/edit', [App\Http\Controllers\TrainingPerformanceController::class, 'edit'])->name('edit');
        Route::put('/{impact}', [App\Http\Controllers\TrainingPerformanceController::class, 'update'])->name('update');
        Route::delete('/{impact}', [App\Http\Controllers\TrainingPerformanceController::class, 'destroy'])->name('destroy');
    });
});

// Logout
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');
});

// Public recruitment routes (no auth required)
Route::get('apply/{token}', [PublicApplicationController::class, 'show'])->name('public.apply.show');
Route::post('apply/{token}', [PublicApplicationController::class, 'store'])->name('public.apply.store')
     ->middleware('throttle:5,60'); // Rate limiting: 5 attempts per hour
Route::put('apply/{token}', [PublicApplicationController::class, 'update'])->name('public.apply.update')
     ->middleware('throttle:5,60'); // Rate limiting for updates

// Interview Confirmation (no auth required)
Route::prefix('interview')->name('interview.')->group(function () {
    Route::get('{token}', [App\Http\Controllers\InterviewConfirmationController::class, 'show'])->name('show');
    Route::post('{token}/confirm', [App\Http\Controllers\InterviewConfirmationController::class, 'confirm'])->name('confirm');
    Route::post('{token}/decline', [App\Http\Controllers\InterviewConfirmationController::class, 'decline'])->name('decline');
});

// Job Offer Response (no auth required)
Route::prefix('offer')->name('offer.')->group(function () {
    Route::get('{token}', [App\Http\Controllers\OfferResponseController::class, 'show'])->name('view');
    Route::get('{token}/accept', [App\Http\Controllers\OfferResponseController::class, 'accept'])->name('accept');
    Route::post('{token}/accept', [App\Http\Controllers\OfferResponseController::class, 'storeAcceptance'])->name('accept.store');
    Route::get('{token}/decline', [App\Http\Controllers\OfferResponseController::class, 'decline'])->name('decline');
    Route::post('{token}/decline', [App\Http\Controllers\OfferResponseController::class, 'storeDecline'])->name('decline.store');
});

// Candidate Portal Routes (no auth required)
Route::prefix('track')->name('candidate.')->group(function () {
    Route::get('{token}', [App\Http\Controllers\CandidatePortalController::class, 'show'])->name('track');
    Route::get('{token}/timeline', [App\Http\Controllers\CandidatePortalController::class, 'timeline'])->name('timeline');
    Route::get('{token}/cv/download', [App\Http\Controllers\CandidatePortalController::class, 'downloadCv'])->name('cv.download');
    
    // Messages
    Route::get('{token}/messages', [App\Http\Controllers\ApplicationMessageController::class, 'candidateIndex'])->name('messages');
    Route::post('{token}/messages', [App\Http\Controllers\ApplicationMessageController::class, 'candidateStore'])->name('messages.store')
         ->middleware('throttle:10,60');
    
    // Update application
    Route::get('{token}/edit', [App\Http\Controllers\CandidatePortalController::class, 'edit'])->name('edit');
    Route::put('{token}', [App\Http\Controllers\CandidatePortalController::class, 'update'])->name('update')
         ->middleware('throttle:3,60');
    
    // Withdraw application
    Route::get('{token}/withdraw', [App\Http\Controllers\CandidatePortalController::class, 'withdraw'])->name('withdraw');
    Route::post('{token}/withdraw', [App\Http\Controllers\CandidatePortalController::class, 'confirmWithdraw'])->name('withdraw.confirm');
});
