<?php $__env->startSection('title', 'Invoices & Payments'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Invoices & Payments','description' => 'View and manage your organization\'s invoices and payment history','icon' => 'receipt']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Invoices & Payments','description' => 'View and manage your organization\'s invoices and payment history','icon' => 'receipt']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginal5194778a3a7b899dcee5619d0610f5cf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.alert','data' => ['type' => 'success','message' => session('success')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'success','message' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('success'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $attributes = $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $component = $__componentOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>

    <!-- Summary Cards -->
    <x-stats-grid :stats="[
        ['value' => 'KES ' . number_format($summary['total_paid'], 2), 'label' => 'Total Paid', 'icon' => 'check-circle', 'type' => 'primary'],
        ['value' => 'KES ' . number_format($summary['total_pending'], 2), 'label' => 'Pending', 'icon' => 'clock', 'type' => 'warning'],
        ['value' => $summary['invoice_count'], 'label' => 'Total Invoices', 'icon' => 'receipt', 'type' => 'info'],
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h6 class="card-title">Last Payment</h6>
                    <h3>
                        <?php if($summary['last_payment']): ?>
                            KES <?php echo e(number_format($summary['last_payment']['amount'], 2)); ?>

                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </h3>
                    <?php if($summary['last_payment']): ?>
                        <small><?php echo e($summary['last_payment']['date']); ?></small>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Invoices Table -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">All Invoices</h5>
        </div>
        <div class="card-body">
            <?php if($invoices->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Invoice #</th>
                                <th>Issue Date</th>
                                <th>Due Date</th>
                                <th>Description</th>
                                <th class="text-end">Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($invoice->invoice_number); ?></strong></td>
                                <td><?php echo e($invoice->issue_date->format('M d, Y')); ?></td>
                                <td><?php echo e($invoice->due_date->format('M d, Y')); ?></td>
                                <td>
                                    <?php if(count($invoice->line_items) > 0): ?>
                                        <?php echo e($invoice->line_items[0]['description']); ?>

                                        <?php if(count($invoice->line_items) > 1): ?>
                                            <small class="text-muted">(+<?php echo e(count($invoice->line_items) - 1); ?> more)</small>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end"><strong>KES <?php echo e(number_format($invoice->total, 2)); ?></strong></td>
                                <td>
                                    <?php if($invoice->status === 'paid'): ?>
                                        <span class="badge bg-success">Paid</span>
                                    <?php elseif($invoice->status === 'pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                    <?php elseif($invoice->status === 'overdue'): ?>
                                        <span class="badge bg-danger">Overdue</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e(ucfirst($invoice->status)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($invoice->status === 'pending' || $invoice->status === 'overdue'): ?>
                                        <a href="<?php echo e(route('organization.payments.show', $invoice)); ?>" class="btn btn-sm btn-success">
                                            <i class="bi bi-credit-card"></i> Pay Now
                                        </a>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('organization.payments.show', $invoice)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-eye"></i> View
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    <?php echo e($invoices->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="bi bi-receipt text-muted" style="font-size: 3rem;"></i>
                    <p class="text-muted mt-3">No invoices yet</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/organization/payments/index.blade.php ENDPATH**/ ?>