<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Error'); ?> - Qaya HRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        :root {
            --primary-orange: #FF6B35;
            --dark-black: #030213;
            --success-green: #28a745;
            --light-green: #d4edda;
            --orange-light: #fff3f0;
            --orange-dark: #e55a2b;
        }

        body {
            background: linear-gradient(135deg, var(--dark-black) 0%, #1a1a2e 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }

        .error-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .error-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            max-width: 600px;
            width: 100%;
            position: relative;
        }

        .error-header {
            background: linear-gradient(135deg, var(--primary-orange) 0%, var(--orange-dark) 100%);
            color: white;
            padding: 40px 30px 30px;
            text-align: center;
            position: relative;
        }

        .error-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.1'%3E%3Ccircle cx='30' cy='30' r='2'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
        }

        .error-code {
            font-size: 6rem;
            font-weight: 900;
            margin: 0;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
            position: relative;
            z-index: 1;
        }

        .error-title {
            font-size: 1.8rem;
            font-weight: 600;
            margin: 10px 0 0;
            position: relative;
            z-index: 1;
        }

        .error-body {
            padding: 40px 30px;
            text-align: center;
        }

        .error-message {
            font-size: 1.1rem;
            color: #666;
            margin-bottom: 30px;
            line-height: 1.6;
        }

        .error-actions {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, var(--primary-orange) 0%, var(--orange-dark) 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(255, 107, 53, 0.3);
        }

        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 107, 53, 0.4);
            color: white;
        }

        .btn-secondary-custom {
            background: var(--dark-black);
            border: 2px solid var(--dark-black);
            color: white;
            padding: 10px 28px;
            border-radius: 50px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
        }

        .btn-secondary-custom:hover {
            background: transparent;
            color: var(--dark-black);
            transform: translateY(-2px);
        }

        .btn-success-custom {
            background: linear-gradient(135deg, var(--success-green) 0%, #20c997 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
        }

        .btn-success-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
            color: white;
        }

        .error-icon {
            font-size: 4rem;
            margin-bottom: 20px;
            opacity: 0.8;
        }

        .error-details {
            background: var(--orange-light);
            border-left: 4px solid var(--primary-orange);
            padding: 20px;
            margin: 20px 0;
            border-radius: 0 10px 10px 0;
        }

        .error-details h6 {
            color: var(--orange-dark);
            font-weight: 600;
            margin-bottom: 10px;
        }

        .error-details p {
            margin: 0;
            color: #666;
            font-size: 0.9rem;
        }

        .logo-section {
            position: absolute;
            top: 15px;
            left: 20px;
            color: white;
            font-weight: 700;
            font-size: 1.2rem;
            z-index: 2;
        }

        .logo-section i {
            margin-right: 8px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .error-code {
                font-size: 4rem;
            }
            
            .error-title {
                font-size: 1.4rem;
            }
            
            .error-header {
                padding: 30px 20px 20px;
            }
            
            .error-body {
                padding: 30px 20px;
            }
            
            .error-actions {
                flex-direction: column;
                align-items: center;
            }
            
            .btn-primary-custom,
            .btn-secondary-custom,
            .btn-success-custom {
                width: 100%;
                justify-content: center;
                max-width: 250px;
            }
        }

        /* Animation */
        .error-card {
            animation: slideUp 0.6s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .error-icon {
            animation: bounce 2s infinite;
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-10px);
            }
            60% {
                transform: translateY(-5px);
            }
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <div class="error-container">
        <div class="error-card">
            <div class="error-header">
                <div class="logo-section">
                    <i class="bi bi-building"></i>
                    Qaya HRM
                </div>
                <div class="error-code"><?php echo $__env->yieldContent('code'); ?></div>
                <h1 class="error-title"><?php echo $__env->yieldContent('title'); ?></h1>
            </div>
            <div class="error-body">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/errors/layout.blade.php ENDPATH**/ ?>