<?php $__env->startSection('title', 'Performance Reviews'); ?>
<?php $__env->startSection('page-title', 'Performance Reviews'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Performance Reviews','description' => 'Manage employee performance reviews']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Performance Reviews','description' => 'Manage employee performance reviews']); ?>
         <?php $__env->slot('actions', null, []); ?> 
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_performance')): ?>
            <a href="<?php echo e(route('performance.create')); ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> New Review
            </a>
            <?php endif; ?>
         <?php $__env->endSlot(); ?>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginal5194778a3a7b899dcee5619d0610f5cf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.alert','data' => ['type' => 'success','message' => session('success')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'success','message' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('success'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $attributes = $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $component = $__componentOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>

    <!-- Statistics Cards -->
    <?php if (isset($component)) { $__componentOriginal14f00bb611be156238920ca6c4a4adca = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal14f00bb611be156238920ca6c4a4adca = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.stats-grid','data' => ['stats' => [
        ['value' => $stats['total_reviews'], 'label' => 'Total Reviews', 'icon' => 'star-fill', 'type' => 'primary'],
        ['value' => $stats['average_rating'] . '/5', 'label' => 'Average Rating', 'icon' => 'graph-up', 'type' => 'success'],
        ['value' => $stats['excellent_count'], 'label' => 'Excellent (≥4.5)', 'icon' => 'trophy-fill', 'type' => 'success'],
        ['value' => $stats['needs_improvement'], 'label' => 'Needs Improvement (<3)', 'icon' => 'exclamation-triangle-fill', 'type' => 'warning'],
        ['value' => $stats['pending_reviews'], 'label' => 'Pending', 'icon' => 'clock', 'type' => 'info'],
        ['value' => $stats['overdue_reviews'], 'label' => 'Overdue', 'icon' => 'exclamation-circle', 'type' => 'danger'],
    ],'columns' => '6']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('stats-grid'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['stats' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
        ['value' => $stats['total_reviews'], 'label' => 'Total Reviews', 'icon' => 'star-fill', 'type' => 'primary'],
        ['value' => $stats['average_rating'] . '/5', 'label' => 'Average Rating', 'icon' => 'graph-up', 'type' => 'success'],
        ['value' => $stats['excellent_count'], 'label' => 'Excellent (≥4.5)', 'icon' => 'trophy-fill', 'type' => 'success'],
        ['value' => $stats['needs_improvement'], 'label' => 'Needs Improvement (<3)', 'icon' => 'exclamation-triangle-fill', 'type' => 'warning'],
        ['value' => $stats['pending_reviews'], 'label' => 'Pending', 'icon' => 'clock', 'type' => 'info'],
        ['value' => $stats['overdue_reviews'], 'label' => 'Overdue', 'icon' => 'exclamation-circle', 'type' => 'danger'],
    ]),'columns' => '6']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal14f00bb611be156238920ca6c4a4adca)): ?>
<?php $attributes = $__attributesOriginal14f00bb611be156238920ca6c4a4adca; ?>
<?php unset($__attributesOriginal14f00bb611be156238920ca6c4a4adca); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal14f00bb611be156238920ca6c4a4adca)): ?>
<?php $component = $__componentOriginal14f00bb611be156238920ca6c4a4adca; ?>
<?php unset($__componentOriginal14f00bb611be156238920ca6c4a4adca); ?>
<?php endif; ?>

    <!-- Filters & Actions -->
    <div class="table-card mb-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">Performance Reviews</h5>
            <div class="btn-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_performance')): ?>
                <a href="<?php echo e(route('performance.goals.index')); ?>" class="btn btn-outline-primary">
                    <i class="bi bi-bullseye"></i> Goals
                </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_performance')): ?>
                <a href="<?php echo e(route('performance.self-assessments.index')); ?>" class="btn btn-outline-success">
                    <i class="bi bi-person-check"></i> Self Assessments
                </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- Filter Form -->
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-2">
                <label class="form-label">Employee</label>
                <select name="employee" class="form-select">
                    <option value="">All Employees</option>
                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($employee->id); ?>" <?php echo e(request('employee') == $employee->id ? 'selected' : ''); ?>>
                            <?php echo e($employee->full_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Period</label>
                <select name="period" class="form-select">
                    <option value="">All Periods</option>
                    <option value="Q1" <?php echo e(request('period') == 'Q1' ? 'selected' : ''); ?>>Q1</option>
                    <option value="Q2" <?php echo e(request('period') == 'Q2' ? 'selected' : ''); ?>>Q2</option>
                    <option value="Q3" <?php echo e(request('period') == 'Q3' ? 'selected' : ''); ?>>Q3</option>
                    <option value="Q4" <?php echo e(request('period') == 'Q4' ? 'selected' : ''); ?>>Q4</option>
                    <option value="Mid-Year" <?php echo e(request('period') == 'Mid-Year' ? 'selected' : ''); ?>>Mid-Year</option>
                    <option value="Yearly" <?php echo e(request('period') == 'Yearly' ? 'selected' : ''); ?>>Yearly</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Type</label>
                <select name="review_type" class="form-select">
                    <option value="">All Types</option>
                    <option value="annual" <?php echo e(request('review_type') == 'annual' ? 'selected' : ''); ?>>Annual</option>
                    <option value="mid_year" <?php echo e(request('review_type') == 'mid_year' ? 'selected' : ''); ?>>Mid-Year</option>
                    <option value="quarterly" <?php echo e(request('review_type') == 'quarterly' ? 'selected' : ''); ?>>Quarterly</option>
                    <option value="probation" <?php echo e(request('review_type') == 'probation' ? 'selected' : ''); ?>>Probation</option>
                    <option value="project_based" <?php echo e(request('review_type') == 'project_based' ? 'selected' : ''); ?>>Project Based</option>
                </select>
            </div>
            <div class="col-md-1">
                <label class="form-label">Rating</label>
                <select name="rating" class="form-select">
                    <option value="">All</option>
                    <option value="5" <?php echo e(request('rating') == '5' ? 'selected' : ''); ?>>5</option>
                    <option value="4" <?php echo e(request('rating') == '4' ? 'selected' : ''); ?>>4</option>
                    <option value="3" <?php echo e(request('rating') == '3' ? 'selected' : ''); ?>>3</option>
                    <option value="2" <?php echo e(request('rating') == '2' ? 'selected' : ''); ?>>2</option>
                    <option value="1" <?php echo e(request('rating') == '1' ? 'selected' : ''); ?>>1</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                    <option value="submitted" <?php echo e(request('status') == 'submitted' ? 'selected' : ''); ?>>Submitted</option>
                    <option value="acknowledged" <?php echo e(request('status') == 'acknowledged' ? 'selected' : ''); ?>>Acknowledged</option>
                    <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                </select>
            </div>
            <div class="col-md-1">
                <label class="form-label">Year</label>
                <select name="year" class="form-select">
                    <option value="">All</option>
                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($year); ?>" <?php echo e(request('year') == $year ? 'selected' : ''); ?>><?php echo e($year); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-funnel"></i> Filter
                </button>
            </div>
        </form>

        <!-- Reviews Table -->
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Employee</th>
                        <th>Reviewer</th>
                        <th>Review Date</th>
                        <th>Period</th>
                        <th>Type</th>
                        <th>Overall Rating</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <?php if($review->employee->photo): ?>
                                        <img src="<?php echo e(asset('storage/' . $review->employee->photo)); ?>"
                                             alt="<?php echo e($review->employee->full_name); ?>"
                                             class="rounded-circle me-2"
                                             style="width: 32px; height: 32px; object-fit: cover;">
                                    <?php else: ?>
                                        <div class="rounded-circle me-2 bg-secondary text-white d-flex align-items-center justify-content-center"
                                             style="width: 32px; height: 32px; font-size: 14px;">
                                            <?php echo e(substr($review->employee->first_name, 0, 1)); ?><?php echo e(substr($review->employee->last_name, 0, 1)); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div>
                                        <div class="fw-bold"><?php echo e($review->employee->full_name); ?></div>
                                        <small class="text-muted"><?php echo e($review->employee->employee_code); ?></small>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo e($review->reviewer->full_name ?? 'N/A'); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($review->review_date)->format('M d, Y')); ?></td>
                            <td><span class="badge bg-info"><?php echo e($review->review_period); ?></span></td>
                            <td><span class="badge bg-<?php echo e($review->review_type_color); ?>"><?php echo e(ucfirst(str_replace('_', ' ', $review->review_type))); ?></span></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="me-2"><?php echo e(number_format($review->overall_rating, 1)); ?></div>
                                    <div>
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <?php if($i <= $review->overall_rating): ?>
                                                <i class="bi bi-star-fill text-warning"></i>
                                            <?php else: ?>
                                                <i class="bi bi-star text-muted"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($review->status === 'completed' ? 'success' : ($review->status === 'draft' ? 'secondary' : 'primary')); ?>">
                                    <?php echo e(ucfirst($review->status)); ?>

                                </span>
                                <?php if($review->isOverdue()): ?>
                                    <span class="badge bg-danger ms-1">Overdue</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $review)): ?>
                                    <a href="<?php echo e(route('performance.show', $review)); ?>"
                                       class="btn btn-outline-primary"
                                       title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $review)): ?>
                                    <a href="<?php echo e(route('performance.edit', $review)); ?>"
                                       class="btn btn-outline-secondary"
                                       title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $review)): ?>
                                    <form action="<?php echo e(route('performance.destroy', $review)); ?>"
                                          method="POST"
                                          class="d-inline"
                                          onsubmit="return confirm('Are you sure you want to delete this review?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit"
                                                class="btn btn-outline-danger"
                                                title="Delete">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-4 text-muted">
                                <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                No performance reviews found.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="mt-3">
            <?php echo e($reviews->links()); ?>

        </div>
    </div>
</div>

<?php if(session('success')): ?>
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div class="toast show" role="alert">
            <div class="toast-header bg-success text-white">
                <i class="bi bi-check-circle me-2"></i>
                <strong class="me-auto">Success</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
            </div>
            <div class="toast-body">
                <?php echo e(session('success')); ?>

            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/performance/index.blade.php ENDPATH**/ ?>