<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Application - <?php echo e($application->jobPosting->organization->name); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                
                <!-- Back Button -->
                <div class="mb-4">
                    <a href="<?php echo e(route('candidate.track', $application->tracking_token)); ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Dashboard
                    </a>
                </div>

                <!-- Update Form -->
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-pencil"></i> Update Your Application</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i> You can update your application once. Please review all changes carefully before submitting.
                        </div>

                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('candidate.update', $application->tracking_token)); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="first_name" class="form-label">First Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="first_name" name="first_name" 
                                           value="<?php echo e(old('first_name', $application->first_name)); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="last_name" class="form-label">Last Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="last_name" name="last_name" 
                                           value="<?php echo e(old('last_name', $application->last_name)); ?>" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone Number <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" id="phone" name="phone" 
                                       value="<?php echo e(old('phone', $application->phone)); ?>" required>
                            </div>

                            <div class="mb-3">
                                <label for="cv" class="form-label">Update CV/Resume (Optional)</label>
                                <input type="file" class="form-control" id="cv" name="cv" accept=".pdf,.doc,.docx">
                                <div class="form-text">Leave empty to keep your current CV. Accepted formats: PDF, DOC, DOCX. Maximum size: 5MB</div>
                                <div class="mt-2">
                                    <small class="text-muted">Current CV: <a href="<?php echo e(route('candidate.cv.download', $application->tracking_token)); ?>">Download</a></small>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="cover_letter" class="form-label">Cover Letter (Optional)</label>
                                <textarea class="form-control" id="cover_letter" name="cover_letter" rows="4"><?php echo e(old('cover_letter', $application->cover_letter)); ?></textarea>
                                <div class="form-text">Maximum 2000 characters</div>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="bi bi-check-circle"></i> Update Application
                                </button>
                                <a href="<?php echo e(route('candidate.track', $application->tracking_token)); ?>" class="btn btn-outline-secondary">
                                    Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // File size validation
        document.getElementById('cv').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file && file.size > 5 * 1024 * 1024) {
                alert('File size must be less than 5MB');
                e.target.value = '';
            }
        });
    </script>
</body>
</html>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/candidate/portal/edit.blade.php ENDPATH**/ ?>