<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Message from Candidate</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .email-wrapper {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
        }
        .header {
            background-color: #4F46E5;
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px 20px;
        }
        .info-box {
            background-color: #F3F4F6;
            border-left: 4px solid #4F46E5;
            padding: 15px;
            margin: 20px 0;
        }
        .credentials-box {
            background-color: #FEF3C7;
            border: 2px solid #F59E0B;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .credential-item {
            margin: 10px 0;
        }
        .credential-label {
            font-weight: bold;
            color: #4F46E5;
        }
        .warning {
            background-color: #FEE2E2;
            border-left: 4px solid #DC2626;
            padding: 15px;
            margin: 20px 0;
        }
        .success-box {
            background-color: #D1FAE5;
            border-left: 4px solid #10B981;
            padding: 15px;
            margin: 20px 0;
        }
        .button {
            display: inline-block;
            background-color: #4F46E5;
            color: #ffffff;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 4px;
            margin: 20px 0;
        }
        .footer {
            background-color: #F9FAFB;
            padding: 20px;
            text-align: center;
            color: #6B7280;
            font-size: 14px;
        }
        ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="header">
            <h1>New Message from Candidate</h1>
        </div>

        <div class="content">
            <h2>New Message Received</h2>
            
            <p><?php echo e($application->full_name); ?> has sent you a message regarding their application for <strong><?php echo e($application->jobPosting->title); ?></strong>.</p>

            <div class="success-box">
                <h3 style="margin-top: 0;">Message</h3>
                <p><?php echo e($message->message); ?></p>
                <p style="font-size: 12px; color: #6B7280; margin-top: 15px;">
                    From: <?php echo e($application->full_name); ?> (<?php echo e($application->email); ?>)<br>
                    Sent: <?php echo e($message->created_at->format('F j, Y \a\t g:i A')); ?>

                </p>
            </div>

            <div style="text-align: center;">
                <a href="<?php echo e($applicationUrl); ?>" class="button">View Application & Reply</a>
            </div>

            <div class="info-box">
                <h3 style="margin-top: 0;">Candidate Details</h3>
                <p>
                    <strong>Name:</strong> <?php echo e($application->full_name); ?><br>
                    <strong>Email:</strong> <?php echo e($application->email); ?><br>
                    <strong>Phone:</strong> <?php echo e($application->phone); ?><br>
                    <strong>Status:</strong> <?php echo e(ucfirst($application->status)); ?>

                </p>
            </div>
        </div>

        <div class="footer">
            <p>This is an automated notification from your recruitment system.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/emails/new-message-from-candidate.blade.php ENDPATH**/ ?>