<?php $__env->startSection('title', 'Two-Factor Authentication'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-md w-full space-y-8">
    <div>
        <div class="mx-auto h-12 w-12 flex items-center justify-center rounded-full bg-blue-100">
            <svg class="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
            </svg>
        </div>
        <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">
            Two-Factor Authentication
        </h2>
        <p class="mt-2 text-center text-sm text-gray-600">
            Please enter the 6-digit code from your authenticator app
        </p>
    </div>

    <?php if($errors->any()): ?>
        <div class="rounded-md bg-red-50 p-4">
            <div class="flex">
                <div class="shrink-0">
                    <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-red-800">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($error); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('two-factor.verify')); ?>" method="POST" class="mt-8 space-y-6">
        <?php echo csrf_field(); ?>
        
        <div>
            <label for="code" class="block text-sm font-medium text-gray-700">
                Authentication Code
            </label>
            <div class="mt-1">
                <input type="text" 
                       name="code" 
                       id="code" 
                       required 
                       maxlength="10"
                       placeholder="000000"
                       class="appearance-none block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 text-center text-lg font-mono tracking-widest"
                       autofocus>
            </div>
            <p class="mt-2 text-sm text-gray-500">
                Enter the 6-digit code from your authenticator app or use a recovery code
            </p>
        </div>

        <div>
            <button type="submit" class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                    <svg class="h-5 w-5 text-blue-500 group-hover:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path>
                    </svg>
                </span>
                Verify Code
            </button>
        </div>

        <div class="text-center">
            <p class="text-sm text-gray-600">
                Lost your device? 
                <button type="button" onclick="toggleRecoveryHelp()" class="font-medium text-blue-600 hover:text-blue-500">
                    Use a recovery code
                </button>
            </p>
        </div>
    </form>

    <div id="recovery-help" class="hidden mt-4 p-4 bg-gray-50 rounded-md">
        <h3 class="text-sm font-medium text-gray-900 mb-2">Using Recovery Codes</h3>
        <p class="text-sm text-gray-600 mb-2">
            If you've lost access to your authenticator app, you can use one of your recovery codes instead. 
            Enter the recovery code in the field above.
        </p>
        <p class="text-sm text-gray-500">
            Recovery codes are 10-character codes that were provided when you set up 2FA.
        </p>
    </div>

    <div class="text-center">
        <a href="<?php echo e(route('login')); ?>" class="font-medium text-gray-600 hover:text-gray-500">
            Back to Login
        </a>
    </div>
</div>

<script>
function toggleRecoveryHelp() {
    const helpDiv = document.getElementById('recovery-help');
    helpDiv.classList.toggle('hidden');
}

// Auto-format the input as user types
document.getElementById('code').addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, ''); // Remove non-digits
    if (value.length <= 6) {
        e.target.value = value;
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/auth/two-factor-challenge.blade.php ENDPATH**/ ?>