<?php $__env->startSection('title', 'Employees'); ?>
<?php $__env->startSection('page-title', 'Employees'); ?>

<?php $__env->startSection('content'); ?>
    <?php if (isset($component)) { $__componentOriginale19f62b34dfe0bfdf95075badcb45bc2 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale19f62b34dfe0bfdf95075badcb45bc2 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.breadcrumb','data' => ['items' => [
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Employees']
    ]]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['items' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Employees']
    ])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale19f62b34dfe0bfdf95075badcb45bc2)): ?>
<?php $attributes = $__attributesOriginale19f62b34dfe0bfdf95075badcb45bc2; ?>
<?php unset($__attributesOriginale19f62b34dfe0bfdf95075badcb45bc2); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale19f62b34dfe0bfdf95075badcb45bc2)): ?>
<?php $component = $__componentOriginale19f62b34dfe0bfdf95075badcb45bc2; ?>
<?php unset($__componentOriginale19f62b34dfe0bfdf95075badcb45bc2); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Employees','description' => 'Manage employee records']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Employees','description' => 'Manage employee records']); ?>
         <?php $__env->slot('actions', null, []); ?> 
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_employees')): ?>
            <div class="btn-group me-2" role="group">
                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="bi bi-upload"></i> Import
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="<?php echo e(route('employees.import.view')); ?>">
                        <i class="bi bi-upload"></i> Import from Excel/CSV
                    </a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('employees.template')); ?>">
                        <i class="bi bi-download"></i> Download Template
                    </a></li>
                </ul>
            </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employees')): ?>
            <div class="btn-group me-2" role="group">
                <button type="button" class="btn btn-outline-success dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="bi bi-download"></i> Export
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="<?php echo e(route('employees.export', array_merge(request()->all(), ['format' => 'xlsx']))); ?>">
                        <i class="bi bi-file-excel"></i> Export to Excel
                    </a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('employees.export', array_merge(request()->all(), ['format' => 'csv']))); ?>">
                        <i class="bi bi-filetype-csv"></i> Export to CSV
                    </a></li>
                </ul>
            </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_employees')): ?>
            <a href="<?php echo e(route('employees.create')); ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Add Employee
            </a>
            <?php endif; ?>
         <?php $__env->endSlot(); ?>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginal5194778a3a7b899dcee5619d0610f5cf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.alert','data' => ['type' => 'success','message' => session('success')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'success','message' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('success'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $attributes = $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $component = $__componentOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>

    <!-- Filters -->
    <?php if (isset($component)) { $__componentOriginal934f921620666b609fa7806109faa21b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal934f921620666b609fa7806109faa21b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.filter-form','data' => ['action' => route('employees.index')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('filter-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('employees.index'))]); ?>
        <div class="col-md-3">
            <input type="text" name="search" class="form-control" placeholder="Search by name, code, email..." value="<?php echo e(request('search')); ?>">
        </div>
        <div class="col-md-2">
            <select name="department" class="form-select">
                <option value="">All Departments</option>
                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($dept->id); ?>" <?php echo e(request('department') == $dept->id ? 'selected' : ''); ?>>
                        <?php echo e($dept->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="status" class="form-select">
                <option value="">All Status</option>
                <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                <option value="on_leave" <?php echo e(request('status') == 'on_leave' ? 'selected' : ''); ?>>On Leave</option>
                <option value="terminated" <?php echo e(request('status') == 'terminated' ? 'selected' : ''); ?>>Terminated</option>
            </select>
        </div>
        <div class="col-md-3">
            <select name="group_by" class="form-select">
                <option value="">No Grouping</option>
                <option value="department" <?php echo e(request('group_by') == 'department' ? 'selected' : ''); ?>>Group by Department</option>
                <option value="status" <?php echo e(request('group_by') == 'status' ? 'selected' : ''); ?>>Group by Status</option>
                <option value="position" <?php echo e(request('group_by') == 'position' ? 'selected' : ''); ?>>Group by Position</option>
            </select>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal934f921620666b609fa7806109faa21b)): ?>
<?php $attributes = $__attributesOriginal934f921620666b609fa7806109faa21b; ?>
<?php unset($__attributesOriginal934f921620666b609fa7806109faa21b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal934f921620666b609fa7806109faa21b)): ?>
<?php $component = $__componentOriginal934f921620666b609fa7806109faa21b; ?>
<?php unset($__componentOriginal934f921620666b609fa7806109faa21b); ?>
<?php endif; ?>

    <!-- Employees Table -->
    <div class="table-card">
        <?php if($groupedEmployees): ?>
            <?php $__currentLoopData = $groupedEmployees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $groupItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="mb-4">
                    <h5 class="bg-light p-3 rounded">
                        <i class="bi bi-folder"></i> <?php echo e($groupName ?: 'Ungrouped'); ?>

                        <span class="badge bg-primary"><?php echo e($groupItems->count()); ?></span>
                    </h5>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="d-none d-md-table-cell">Code</th>
                                    <th>Name</th>
                                    <th class="d-none d-sm-table-cell">Email</th>
                                    <?php if(request('group_by') != 'department'): ?>
                                    <th class="d-none d-lg-table-cell">Department</th>
                                    <?php endif; ?>
                                    <?php if(request('group_by') != 'position'): ?>
                                    <th class="d-none d-lg-table-cell">Position</th>
                                    <?php endif; ?>
                                    <th class="d-none d-md-table-cell">Payroll Ready</th>
                                    <?php if(request('group_by') != 'status'): ?>
                                    <th class="d-none d-sm-table-cell">Status</th>
                                    <?php endif; ?>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $groupItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="d-none d-md-table-cell"><?php echo e($employee->employee_code); ?></td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employee_details')): ?>
                                            <a href="<?php echo e(route('employees.show', $employee)); ?>">
                                                <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?>

                                            </a>
                                            <?php else: ?>
                                            <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?>

                                            <?php endif; ?>
                                            <!-- Show additional info on mobile -->
                                            <div class="d-md-none">
                                                <small class="text-muted d-block"><?php echo e($employee->employee_code); ?></small>
                                                <small class="text-muted d-block d-sm-none"><?php echo e($employee->email); ?></small>
                                            </div>
                                        </td>
                                        <td class="d-none d-sm-table-cell"><?php echo e($employee->email); ?></td>
                                        <?php if(request('group_by') != 'department'): ?>
                                        <td class="d-none d-lg-table-cell"><?php echo e($employee->department->name ?? 'N/A'); ?></td>
                                        <?php endif; ?>
                                        <?php if(request('group_by') != 'position'): ?>
                                        <td class="d-none d-lg-table-cell"><?php echo e($employee->position->name ?? 'N/A'); ?></td>
                                        <?php endif; ?>
                                        <td class="d-none d-md-table-cell">
                                            <?php if($employee->hasCompleteKraInfo() && $employee->effective_basic_salary > 0): ?>
                                                <span class="badge bg-success" title="Ready for payroll generation">
                                                    <i class="bi bi-check-circle"></i> Ready
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark" title="Missing KRA PIN, NHIF, NSSF, or Basic Salary">
                                                    <i class="bi bi-exclamation-triangle"></i> Incomplete
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <?php if(request('group_by') != 'status'): ?>
                                        <td class="d-none d-sm-table-cell">
                                            <?php if($employee->status == 'active'): ?>
                                                <span class="badge bg-success">Active</span>
                                            <?php elseif($employee->status == 'inactive'): ?>
                                                <span class="badge bg-secondary">Inactive</span>
                                            <?php elseif($employee->status == 'on_leave'): ?>
                                                <span class="badge bg-warning">On Leave</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Terminated</span>
                                            <?php endif; ?>
                                        </td>
                                        <?php endif; ?>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employee_details')): ?>
                                            <a href="<?php echo e(route('employees.show', $employee)); ?>" class="btn btn-sm btn-info">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_employees')): ?>
                                                <?php if (! (auth()->user()->hasRole('org_admin'))): ?>
                                                <a href="<?php echo e(route('employees.edit', $employee)); ?>" class="btn btn-sm btn-warning d-none d-sm-inline-block">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Department</th>
                        <th>Position</th>
                        <th>Payroll Ready</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($employee->employee_code); ?></td>
                            <td>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employee_details')): ?>
                                <a href="<?php echo e(route('employees.show', $employee)); ?>">
                                    <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?>

                                </a>
                                <?php else: ?>
                                <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($employee->email); ?></td>
                            <td><?php echo e($employee->department->name ?? 'N/A'); ?></td>
                            <td><?php echo e($employee->position->name ?? 'N/A'); ?></td>
                            <td>
                                <?php if($employee->hasCompleteKraInfo() && $employee->effective_basic_salary > 0): ?>
                                    <span class="badge bg-success" title="Ready for payroll generation">
                                        <i class="bi bi-check-circle"></i> Ready
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-warning text-dark" title="Missing KRA PIN, NHIF, NSSF, or Basic Salary">
                                        <i class="bi bi-exclamation-triangle"></i> Incomplete
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge badge-status-<?php echo e($employee->status); ?>">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $employee->status))); ?>

                                </span>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_employee_details')): ?>
                                    <a href="<?php echo e(route('employees.show', $employee)); ?>" class="btn btn-info" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_employees')): ?>
                                        <?php if (! (auth()->user()->hasRole('org_admin'))): ?>
                                        <a href="<?php echo e(route('employees.edit', $employee)); ?>" class="btn btn-warning" title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_employees')): ?>
                                        <?php if (! (auth()->user()->hasRole('org_admin'))): ?>
                                        <form action="<?php echo e(route('employees.destroy', $employee)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm" title="Delete" onclick="return confirm('Are you sure?')">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center">No employees found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if($employees): ?>
        <div class="mt-3">
            <?php echo e($employees->links()); ?>

        </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/employees/index.blade.php ENDPATH**/ ?>