<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Attendance Report</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin: 0;
            color: #714b67;
        }
        .meta-info {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #714b67;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Attendance Report</h1>
        <p><?php echo e(config('app.name')); ?></p>
    </div>

    <div class="meta-info">
        <p><strong>Generated:</strong> <?php echo e(now()->format('F d, Y h:i A')); ?></p>
        <?php if(request('start_date') && request('end_date')): ?>
        <p><strong>Period:</strong> <?php echo e(request('start_date')); ?> to <?php echo e(request('end_date')); ?></p>
        <?php endif; ?>
        <?php if(request('department_id')): ?>
        <p><strong>Department:</strong> <?php echo e($departments->find(request('department_id'))->name ?? 'All'); ?></p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Employee</th>
                <th>Department</th>
                <th>Check In</th>
                <th>Check Out</th>
                <th>Hours</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($attendance->date); ?></td>
                <td><?php echo e($attendance->employee->first_name); ?> <?php echo e($attendance->employee->last_name); ?></td>
                <td><?php echo e($attendance->employee->department?->name); ?></td>
                <td><?php echo e($attendance->check_in); ?></td>
                <td><?php echo e($attendance->check_out); ?></td>
                <td><?php echo e($attendance->work_hours); ?></td>
                <td><?php echo e(ucfirst($attendance->status)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <p>This is a system-generated report. Generated on <?php echo e(now()->format('F d, Y h:i A')); ?></p>
    </div>
</body>
</html>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/exports/attendance-pdf.blade.php ENDPATH**/ ?>