<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Training Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .summary {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }
        .summary-item {
            display: table-cell;
            text-align: center;
            padding: 15px;
            border: 1px solid #ddd;
            background-color: #f8f9fa;
        }
        .summary-item h3 {
            margin: 0;
            color: #007bff;
            font-size: 18px;
        }
        .summary-item p {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 11px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            color: #333;
        }
        .badge {
            display: inline-block;
            padding: 2px 6px;
            font-size: 10px;
            font-weight: bold;
            border-radius: 3px;
            color: white;
        }
        .badge-success { background-color: #28a745; }
        .badge-warning { background-color: #ffc107; color: #212529; }
        .badge-danger { background-color: #dc3545; }
        .badge-primary { background-color: #007bff; }
        .badge-info { background-color: #17a2b8; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .mb-20 { margin-bottom: 20px; }
        .page-break {
            page-break-before: always;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Training Report</h1>
        <p>Period: <?php echo e(\Carbon\Carbon::parse($startDate)->format('F j, Y')); ?> - <?php echo e(\Carbon\Carbon::parse($endDate)->format('F j, Y')); ?></p>
        <p>Generated on: <?php echo e(now()->format('F j, Y g:i A')); ?></p>
    </div>

    <div class="summary mb-20">
        <div class="summary-item">
            <h3><?php echo e($summary['total_sessions']); ?></h3>
            <p>Total Sessions</p>
        </div>
        <div class="summary-item">
            <h3><?php echo e($summary['total_enrollments']); ?></h3>
            <p>Total Enrollments</p>
        </div>
        <div class="summary-item">
            <h3><?php echo e($summary['completed_enrollments']); ?></h3>
            <p>Completed</p>
        </div>
        <div class="summary-item">
            <h3><?php echo e($summary['completion_rate']); ?>%</h3>
            <p>Completion Rate</p>
        </div>
    </div>

    <?php if($sessions->count() > 0): ?>
        <h2>Training Sessions Detail</h2>
        <table>
            <thead>
                <tr>
                    <th>Program</th>
                    <th>Category</th>
                    <th>Session Date</th>
                    <th>Status</th>
                    <th>Enrollments</th>
                    <th>Completed</th>
                    <th>Completion Rate</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <strong><?php echo e($session->program->title); ?></strong><br>
                            <small><?php echo e($session->session_code); ?></small>
                        </td>
                        <td><?php echo e($session->program->category->name); ?></td>
                        <td><?php echo e($session->start_datetime->format('M j, Y g:i A')); ?></td>
                        <td>
                            <span class="badge badge-<?php echo e($session->status == 'completed' ? 'success' : ($session->status == 'in_progress' ? 'warning' : 'primary')); ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $session->status))); ?>

                            </span>
                        </td>
                        <td class="text-center"><?php echo e($session->enrollments->count()); ?></td>
                        <td class="text-center"><?php echo e($session->enrollments->where('status', 'completed')->count()); ?></td>
                        <td class="text-center">
                            <?php
                                $completionRate = $session->enrollments->count() > 0 
                                    ? round(($session->enrollments->where('status', 'completed')->count() / $session->enrollments->count()) * 100, 1)
                                    : 0;
                            ?>
                            <span class="badge badge-<?php echo e($completionRate >= 80 ? 'success' : ($completionRate >= 60 ? 'warning' : 'danger')); ?>">
                                <?php echo e($completionRate); ?>%
                            </span>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php if($sessions->count() > 10): ?>
            <div class="page-break"></div>
            
            <h2>Enrollment Details</h2>
            <table>
                <thead>
                    <tr>
                        <th>Employee</th>
                        <th>Department</th>
                        <th>Program</th>
                        <th>Session Date</th>
                        <th>Status</th>
                        <th>Enrollment Type</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $sessions->flatMap->enrollments->sortBy('employee.full_name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($enrollment->employee->full_name); ?></td>
                            <td><?php echo e($enrollment->employee->department->name ?? 'N/A'); ?></td>
                            <td><?php echo e($enrollment->session->program->title); ?></td>
                            <td><?php echo e($enrollment->session->start_datetime->format('M j, Y')); ?></td>
                            <td>
                                <span class="badge badge-<?php echo e($enrollment->status == 'completed' ? 'success' : ($enrollment->status == 'attended' ? 'info' : ($enrollment->status == 'no_show' ? 'danger' : 'warning'))); ?>">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $enrollment->status))); ?>

                                </span>
                            </td>
                            <td><?php echo e(ucfirst(str_replace('_', ' ', $enrollment->enrollment_type))); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php endif; ?>
    <?php else: ?>
        <div class="text-center" style="padding: 50px;">
            <h3>No Training Sessions Found</h3>
            <p>No training sessions match the selected criteria for the specified date range.</p>
        </div>
    <?php endif; ?>

    <div class="footer">
        <p>Training Report - <?php echo e(config('app.name')); ?> | Page <span class="pagenum"></span></p>
    </div>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/exports/training-pdf.blade.php ENDPATH**/ ?>