<?php $__env->startSection('title', 'Self Assessments'); ?>
<?php $__env->startSection('page-title', 'Self Assessments'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="stat-card primary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-person-check"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Total Assessments</h6>
                        <h3 class="mb-0"><?php echo e($stats['total_assessments']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card success">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-check-circle"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Submitted</h6>
                        <h3 class="mb-0"><?php echo e($stats['submitted_assessments']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card warning">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-pencil"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Drafts</h6>
                        <h3 class="mb-0"><?php echo e($stats['draft_assessments']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card info">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-emoji-smile"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Avg Satisfaction</h6>
                        <h3 class="mb-0"><?php echo e($stats['average_satisfaction'] ?? 0); ?>/5</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters & Actions -->
    <div class="table-card mb-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">Self Assessments</h5>
            <div class="btn-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\PerformanceSelfAssessment::class)): ?>
                <a href="<?php echo e(route('performance.self-assessments.create')); ?>" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> New Assessment
                </a>
                <?php endif; ?>
                <a href="<?php echo e(route('performance.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Reviews
                </a>
            </div>
        </div>

        <!-- Filter Form -->
        <?php if(auth()->user()->can('view_all_assessments')): ?>
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-4">
                <label class="form-label">Employee</label>
                <select name="employee" class="form-select">
                    <option value="">All Employees</option>
                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($employee->id); ?>" <?php echo e(request('employee') == $employee->id ? 'selected' : ''); ?>>
                            <?php echo e($employee->full_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Period</label>
                <select name="period" class="form-select">
                    <option value="">All Periods</option>
                    <option value="Q1" <?php echo e(request('period') == 'Q1' ? 'selected' : ''); ?>>Q1</option>
                    <option value="Q2" <?php echo e(request('period') == 'Q2' ? 'selected' : ''); ?>>Q2</option>
                    <option value="Q3" <?php echo e(request('period') == 'Q3' ? 'selected' : ''); ?>>Q3</option>
                    <option value="Q4" <?php echo e(request('period') == 'Q4' ? 'selected' : ''); ?>>Q4</option>
                    <option value="Mid-Year" <?php echo e(request('period') == 'Mid-Year' ? 'selected' : ''); ?>>Mid-Year</option>
                    <option value="Annual" <?php echo e(request('period') == 'Annual' ? 'selected' : ''); ?>>Annual</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                    <option value="submitted" <?php echo e(request('status') == 'submitted' ? 'selected' : ''); ?>>Submitted</option>
                    <option value="reviewed" <?php echo e(request('status') == 'reviewed' ? 'selected' : ''); ?>>Reviewed</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-funnel"></i> Filter
                </button>
            </div>
        </form>
        <?php endif; ?>

        <!-- Assessments Table -->
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <?php if(auth()->user()->can('view_all_assessments')): ?>
                        <th>Employee</th>
                        <?php endif; ?>
                        <th>Assessment Date</th>
                        <th>Period</th>
                        <th>Satisfaction</th>
                        <th>Status</th>
                        <th>Submitted</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $assessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assessment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <?php if(auth()->user()->can('view_all_assessments')): ?>
                            <td>
                                <div class="d-flex align-items-center">
                                    <?php if($assessment->employee->photo): ?>
                                        <img src="<?php echo e(asset('storage/' . $assessment->employee->photo)); ?>"
                                             alt="<?php echo e($assessment->employee->full_name); ?>"
                                             class="rounded-circle me-2"
                                             style="width: 32px; height: 32px; object-fit: cover;">
                                    <?php else: ?>
                                        <div class="rounded-circle me-2 bg-secondary text-white d-flex align-items-center justify-content-center"
                                             style="width: 32px; height: 32px; font-size: 14px;">
                                            <?php echo e(substr($assessment->employee->first_name, 0, 1)); ?><?php echo e(substr($assessment->employee->last_name, 0, 1)); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div>
                                        <div class="fw-bold"><?php echo e($assessment->employee->full_name); ?></div>
                                        <small class="text-muted"><?php echo e($assessment->employee->employee_code); ?></small>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                            <td><?php echo e($assessment->assessment_date->format('M d, Y')); ?></td>
                            <td><span class="badge bg-info"><?php echo e($assessment->period); ?></span></td>
                            <td>
                                <?php if($assessment->overall_satisfaction): ?>
                                    <div class="d-flex align-items-center">
                                        <span class="me-2"><?php echo e(number_format($assessment->overall_satisfaction, 1)); ?></span>
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <?php if($i <= $assessment->overall_satisfaction): ?>
                                                <i class="bi bi-star-fill text-warning"></i>
                                            <?php else: ?>
                                                <i class="bi bi-star text-muted"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </div>
                                <?php else: ?>
                                    <span class="text-muted">Not rated</span>
                                <?php endif; ?>
                            </td>
                            <td><span class="badge bg-<?php echo e($assessment->status_color); ?>"><?php echo e(ucfirst($assessment->status)); ?></span></td>
                            <td>
                                <?php if($assessment->submitted_at): ?>
                                    <?php echo e($assessment->submitted_at->format('M d, Y')); ?>

                                <?php else: ?>
                                    <span class="text-muted">Not submitted</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $assessment)): ?>
                                    <a href="<?php echo e(route('performance.self-assessments.show', $assessment)); ?>"
                                       class="btn btn-outline-primary"
                                       title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <?php endif; ?>
                                    <?php if($assessment->status === 'draft'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $assessment)): ?>
                                        <a href="<?php echo e(route('performance.self-assessments.edit', $assessment)); ?>"
                                           class="btn btn-outline-secondary"
                                           title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $assessment)): ?>
                                        <form action="<?php echo e(route('performance.self-assessments.submit', $assessment)); ?>"
                                              method="POST"
                                              class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to submit this assessment?');">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit"
                                                    class="btn btn-outline-success"
                                                    title="Submit">
                                                <i class="bi bi-check"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($assessment->status === 'draft'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $assessment)): ?>
                                        <form action="<?php echo e(route('performance.self-assessments.destroy', $assessment)); ?>"
                                              method="POST"
                                              class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this assessment?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit"
                                                    class="btn btn-outline-danger"
                                                    title="Delete">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="<?php echo e(auth()->user()->can('view_all_assessments') ? '7' : '6'); ?>" class="text-center py-4 text-muted">
                                <i class="bi bi-person-check fs-1 d-block mb-2"></i>
                                No self assessments found.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="mt-3">
            <?php echo e($assessments->links()); ?>

        </div>
    </div>
</div>

<?php if(session('success')): ?>
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div class="toast show" role="alert">
            <div class="toast-header bg-success text-white">
                <i class="bi bi-check-circle me-2"></i>
                <strong class="me-auto">Success</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
            </div>
            <div class="toast-body">
                <?php echo e(session('success')); ?>

            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/performance/self-assessments/index.blade.php ENDPATH**/ ?>