<?php $__env->startSection('title', 'Leave Balances'); ?>
<?php $__env->startSection('page-title', 'Leave Balances'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4 d-flex justify-content-between align-items-center">
        <div>
            <h5 class="mb-0">Employee Leave Balances</h5>
            <p class="text-muted mb-0">View and manage leave balances for all employees</p>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-12">
            <div class="table-card">
                <form method="GET" action="<?php echo e(route('leaves.balances')); ?>" class="row g-3 mb-4">
                    <div class="col-md-4">
                        <input type="text" class="form-control" name="search"
                               placeholder="Search by name or employee code..."
                               value="<?php echo e(request('search')); ?>">
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" name="department">
                            <option value="">All Departments</option>
                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($department->id); ?>" <?php echo e(request('department') == $department->id ? 'selected' : ''); ?>>
                                    <?php echo e($department->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" name="leave_type">
                            <option value="">All Leave Types</option>
                            <?php $__currentLoopData = $leaveTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id); ?>" <?php echo e(request('leave_type') == $type->id ? 'selected' : ''); ?>>
                                    <?php echo e($type->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="bi bi-search"></i> Search
                        </button>
                    </div>
                </form>

                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Employee</th>
                                <th>Department</th>
                                <?php $__currentLoopData = $leaveTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th class="text-center" title="<?php echo e($type->name); ?>">
                                        <span class="badge" style="background-color: <?php echo e($type->color); ?>">
                                            <?php echo e($type->code ?? substr($type->name, 0, 2)); ?>

                                        </span>
                                    </th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <th class="text-center">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?php if($employee->photo): ?>
                                                <img src="<?php echo e(asset('storage/' . $employee->photo)); ?>"
                                                     alt="<?php echo e($employee->full_name); ?>"
                                                     class="rounded-circle me-2"
                                                     style="width: 32px; height: 32px; object-fit: cover;">
                                            <?php else: ?>
                                                <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center me-2"
                                                     style="width: 32px; height: 32px; font-size: 12px;">
                                                    <?php echo e(substr($employee->first_name, 0, 1)); ?><?php echo e(substr($employee->last_name, 0, 1)); ?>

                                                </div>
                                            <?php endif; ?>
                                            <div>
                                                <a href="<?php echo e(route('employees.show', $employee)); ?>">
                                                    <?php echo e($employee->full_name); ?>

                                                </a>
                                                <br>
                                                <small class="text-muted"><?php echo e($employee->employee_code); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e($employee->department->name ?? 'N/A'); ?></td>
                                    <?php
                                        $totalAvailable = 0;
                                        $totalDays = 0;
                                    ?>
                                    <?php $__currentLoopData = $leaveTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $balance = $employee->leaveBalances->firstWhere('leave_type_id', $type->id);
                                            $available = $balance ? $balance->available_days : $type->default_days;
                                            $total = $balance ? $balance->total_days : $type->default_days;
                                            $totalAvailable += $available;
                                            $totalDays += $total;
                                        ?>
                                        <td class="text-center">
                                            <span class="badge <?php echo e($available > 0 ? 'bg-success' : 'bg-danger'); ?>">
                                                <?php echo e($available); ?>

                                            </span>
                                            <small class="text-muted">/ <?php echo e($total); ?></small>
                                        </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <td class="text-center">
                                        <strong><?php echo e($totalAvailable); ?></strong> / <?php echo e($totalDays); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="<?php echo e(3 + $leaveTypes->count()); ?>" class="text-center py-4">
                                        <i class="bi bi-people" style="font-size: 48px; color: #ccc;"></i>
                                        <p class="text-muted mt-3 mb-0">No employees found</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($employees->hasPages()): ?>
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($employees->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="table-card">
                <h5 class="mb-3">Leave Type Legend</h5>
                <div class="row">
                    <?php $__currentLoopData = $leaveTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-3 mb-3">
                            <div class="d-flex align-items-center">
                                <span class="badge" style="background-color: <?php echo e($type->color); ?>; min-width: 60px;">
                                    <?php echo e($type->code ?? substr($type->name, 0, 2)); ?>

                                </span>
                                <div class="ms-3">
                                    <div class="fw-bold"><?php echo e($type->name); ?></div>
                                    <small class="text-muted"><?php echo e($type->default_days); ?> days/year</small>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/leaves/balances.blade.php ENDPATH**/ ?>