<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Typography</h5>
        <p class="text-muted mb-0 small">Choose fonts for your organization</p>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label fw-bold">Primary Font (Body Text)</label>
                <select class="form-select" name="primary_font">
                    <option value="">Use base theme font</option>
                    <option value="Inter, system-ui, sans-serif" <?php echo e($themeSetting?->primary_font === 'Inter, system-ui, sans-serif' ? 'selected' : ''); ?>>Inter</option>
                    <option value="Roboto, sans-serif" <?php echo e($themeSetting?->primary_font === 'Roboto, sans-serif' ? 'selected' : ''); ?>>Roboto</option>
                    <option value="Open Sans, sans-serif" <?php echo e($themeSetting?->primary_font === 'Open Sans, sans-serif' ? 'selected' : ''); ?>>Open Sans</option>
                    <option value="Lato, sans-serif" <?php echo e($themeSetting?->primary_font === 'Lato, sans-serif' ? 'selected' : ''); ?>>Lato</option>
                    <option value="Poppins, sans-serif" <?php echo e($themeSetting?->primary_font === 'Poppins, sans-serif' ? 'selected' : ''); ?>>Poppins</option>
                    <option value="Montserrat, sans-serif" <?php echo e($themeSetting?->primary_font === 'Montserrat, sans-serif' ? 'selected' : ''); ?>>Montserrat</option>
                    <option value="Source Sans Pro, sans-serif" <?php echo e($themeSetting?->primary_font === 'Source Sans Pro, sans-serif' ? 'selected' : ''); ?>>Source Sans Pro</option>
                    <option value="Nunito, sans-serif" <?php echo e($themeSetting?->primary_font === 'Nunito, sans-serif' ? 'selected' : ''); ?>>Nunito</option>
                    <option value="Arial, sans-serif" <?php echo e($themeSetting?->primary_font === 'Arial, sans-serif' ? 'selected' : ''); ?>>Arial</option>
                    <option value="Helvetica, sans-serif" <?php echo e($themeSetting?->primary_font === 'Helvetica, sans-serif' ? 'selected' : ''); ?>>Helvetica</option>
                    <option value="Georgia, serif" <?php echo e($themeSetting?->primary_font === 'Georgia, serif' ? 'selected' : ''); ?>>Georgia</option>
                    <option value="Times New Roman, serif" <?php echo e($themeSetting?->primary_font === 'Times New Roman, serif' ? 'selected' : ''); ?>>Times New Roman</option>
                </select>
                <div class="font-preview mt-2" style="font-family: <?php echo e($themeSetting?->primary_font ?? 'inherit'); ?>">
                    The quick brown fox jumps over the lazy dog. 0123456789
                </div>
            </div>
            
            <div class="col-md-6 mb-3">
                <label class="form-label fw-bold">Heading Font</label>
                <select class="form-select" name="heading_font">
                    <option value="">Use base theme font</option>
                    <option value="Inter, system-ui, sans-serif" <?php echo e($themeSetting?->heading_font === 'Inter, system-ui, sans-serif' ? 'selected' : ''); ?>>Inter</option>
                    <option value="Roboto, sans-serif" <?php echo e($themeSetting?->heading_font === 'Roboto, sans-serif' ? 'selected' : ''); ?>>Roboto</option>
                    <option value="Open Sans, sans-serif" <?php echo e($themeSetting?->heading_font === 'Open Sans, sans-serif' ? 'selected' : ''); ?>>Open Sans</option>
                    <option value="Lato, sans-serif" <?php echo e($themeSetting?->heading_font === 'Lato, sans-serif' ? 'selected' : ''); ?>>Lato</option>
                    <option value="Poppins, sans-serif" <?php echo e($themeSetting?->heading_font === 'Poppins, sans-serif' ? 'selected' : ''); ?>>Poppins</option>
                    <option value="Montserrat, sans-serif" <?php echo e($themeSetting?->heading_font === 'Montserrat, sans-serif' ? 'selected' : ''); ?>>Montserrat</option>
                    <option value="Source Sans Pro, sans-serif" <?php echo e($themeSetting?->heading_font === 'Source Sans Pro, sans-serif' ? 'selected' : ''); ?>>Source Sans Pro</option>
                    <option value="Nunito, sans-serif" <?php echo e($themeSetting?->heading_font === 'Nunito, sans-serif' ? 'selected' : ''); ?>>Nunito</option>
                    <option value="Playfair Display, serif" <?php echo e($themeSetting?->heading_font === 'Playfair Display, serif' ? 'selected' : ''); ?>>Playfair Display</option>
                    <option value="Merriweather, serif" <?php echo e($themeSetting?->heading_font === 'Merriweather, serif' ? 'selected' : ''); ?>>Merriweather</option>
                    <option value="Arial, sans-serif" <?php echo e($themeSetting?->heading_font === 'Arial, sans-serif' ? 'selected' : ''); ?>>Arial</option>
                    <option value="Georgia, serif" <?php echo e($themeSetting?->heading_font === 'Georgia, serif' ? 'selected' : ''); ?>>Georgia</option>
                </select>
                <div class="font-preview mt-2" style="font-family: <?php echo e($themeSetting?->heading_font ?? 'inherit'); ?>">
                    <h4 class="mb-0">Heading Preview Text</h4>
                </div>
            </div>
        </div>
        
        <div class="alert alert-info">
            <i class="bi bi-info-circle"></i>
            <strong>Note:</strong> Font changes will apply to all text throughout the application. 
            Choose fonts that are easy to read and professional.
        </div>
    </div>
</div>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/settings/theme/partials/font-selector.blade.php ENDPATH**/ ?>