<?php $__env->startSection('title', 'Edit Subscription'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2><i class="bi bi-pencil"></i> Edit Subscription</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('systemadmin.dashboard')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('systemadmin.subscriptions.index')); ?>">Subscriptions</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('systemadmin.subscriptions.show', $subscription)); ?>"><?php echo e($subscription->organization->name); ?></a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-star"></i> Subscription Details</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('systemadmin.subscriptions.update', $subscription)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <!-- Organization Info (Read-only) -->
                        <div class="mb-4">
                            <h6>Organization</h6>
                            <p class="text-muted"><?php echo e($subscription->organization->name); ?></p>
                        </div>

                        <!-- Plan Selection -->
                        <div class="mb-3">
                            <label for="plan_id" class="form-label">Subscription Plan <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['plan_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="plan_id" 
                                    name="plan_id" 
                                    required>
                                <option value="">Select a plan</option>
                                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>" 
                                            <?php echo e(old('plan_id', $subscription->plan_id) == $plan->id ? 'selected' : ''); ?>>
                                        <?php echo e($plan->name); ?> - KES <?php echo e(number_format($plan->price_monthly, 0)); ?>/month
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['plan_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Billing Cycle -->
                        <div class="mb-3">
                            <label for="billing_cycle" class="form-label">Billing Cycle <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['billing_cycle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="billing_cycle" 
                                    name="billing_cycle" 
                                    required>
                                <option value="monthly" <?php echo e(old('billing_cycle', $subscription->billing_cycle) === 'monthly' ? 'selected' : ''); ?>>
                                    Monthly
                                </option>
                                <option value="annual" <?php echo e(old('billing_cycle', $subscription->billing_cycle) === 'annual' ? 'selected' : ''); ?>>
                                    Annual
                                </option>
                            </select>
                            <?php $__errorArgs = ['billing_cycle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Status -->
                        <div class="mb-3">
                            <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="status" 
                                    name="status" 
                                    required>
                                <option value="trial" <?php echo e(old('status', $subscription->status) === 'trial' ? 'selected' : ''); ?>>
                                    Trial
                                </option>
                                <option value="active" <?php echo e(old('status', $subscription->status) === 'active' ? 'selected' : ''); ?>>
                                    Active
                                </option>
                                <option value="suspended" <?php echo e(old('status', $subscription->status) === 'suspended' ? 'selected' : ''); ?>>
                                    Suspended
                                </option>
                                <option value="cancelled" <?php echo e(old('status', $subscription->status) === 'cancelled' ? 'selected' : ''); ?>>
                                    Cancelled
                                </option>
                                <option value="expired" <?php echo e(old('status', $subscription->status) === 'expired' ? 'selected' : ''); ?>>
                                    Expired
                                </option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Trial End Date -->
                        <div class="mb-3" id="trial-end-group" style="display: <?php echo e(old('status', $subscription->status) === 'trial' ? 'block' : 'none'); ?>;">
                            <label for="trial_ends_at" class="form-label">Trial End Date</label>
                            <input type="date" 
                                   class="form-control <?php $__errorArgs = ['trial_ends_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="trial_ends_at" 
                                   name="trial_ends_at" 
                                   value="<?php echo e(old('trial_ends_at', $subscription->trial_ends_at ? $subscription->trial_ends_at->format('Y-m-d') : '')); ?>">
                            <?php $__errorArgs = ['trial_ends_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Current Period End Date -->
                        <div class="mb-3">
                            <label for="current_period_ends_at" class="form-label">Current Period End Date</label>
                            <input type="date" 
                                   class="form-control <?php $__errorArgs = ['current_period_ends_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="current_period_ends_at" 
                                   name="current_period_ends_at" 
                                   value="<?php echo e(old('current_period_ends_at', $subscription->current_period_ends_at ? $subscription->current_period_ends_at->format('Y-m-d') : '')); ?>">
                            <?php $__errorArgs = ['current_period_ends_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Started At -->
                        <div class="mb-3">
                            <label for="started_at" class="form-label">Started At</label>
                            <input type="datetime-local" 
                                   class="form-control <?php $__errorArgs = ['started_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="started_at" 
                                   name="started_at" 
                                   value="<?php echo e(old('started_at', $subscription->started_at ? $subscription->started_at->format('Y-m-d\TH:i') : '')); ?>">
                            <?php $__errorArgs = ['started_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Ends At -->
                        <div class="mb-3">
                            <label for="ends_at" class="form-label">Ends At</label>
                            <input type="date" 
                                   class="form-control <?php $__errorArgs = ['ends_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="ends_at" 
                                   name="ends_at" 
                                   value="<?php echo e(old('ends_at', $subscription->ends_at ? $subscription->ends_at->format('Y-m-d') : '')); ?>">
                            <small class="form-text text-muted">Leave empty for ongoing subscription</small>
                            <?php $__errorArgs = ['ends_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Update Subscription
                            </button>
                            <a href="<?php echo e(route('systemadmin.subscriptions.show', $subscription)); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Help Section -->
        <div class="col-md-4">
            <div class="card border-info">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="bi bi-info-circle"></i> Help</h6>
                </div>
                <div class="card-body">
                    <h6>Status Meanings:</h6>
                    <ul class="small">
                        <li><strong>Trial:</strong> Organization is in trial period</li>
                        <li><strong>Active:</strong> Paid and active subscription</li>
                        <li><strong>Suspended:</strong> Temporarily suspended by admin</li>
                        <li><strong>Cancelled:</strong> Cancelled by user or admin</li>
                        <li><strong>Expired:</strong> Subscription has expired</li>
                    </ul>

                    <h6 class="mt-3">Important Notes:</h6>
                    <ul class="small">
                        <li>Changing the plan will affect resource limits immediately</li>
                        <li>Trial end date is only used when status is "Trial"</li>
                        <li>Current period end date determines next billing date</li>
                        <li>Be careful when changing status manually</li>
                    </ul>
                </div>
            </div>

            <div class="card mt-3 border-warning">
                <div class="card-header bg-warning text-dark">
                    <h6 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Warning</h6>
                </div>
                <div class="card-body">
                    <p class="small mb-0">
                        Manual changes to subscriptions should be done carefully. 
                        Consider using the action buttons on the subscription details page instead.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('status').addEventListener('change', function() {
    const trialEndGroup = document.getElementById('trial-end-group');
    if (this.value === 'trial') {
        trialEndGroup.style.display = 'block';
    } else {
        trialEndGroup.style.display = 'none';
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('systemadmin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/systemadmin/subscriptions/edit.blade.php ENDPATH**/ ?>