<?php $__env->startSection('title', 'Training Recommendations'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Recommendations</h1>
                <div class="btn-group">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingRecommendation::class)): ?>
                        <a href="<?php echo e(route('training.recommendations.create')); ?>" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Create Recommendation
                        </a>
                        <button type="button" class="btn btn-outline-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">
                            <span class="visually-hidden">Toggle Dropdown</span>
                        </button>
                        <ul class="dropdown-menu">
                            <li>
                                <form method="POST" action="<?php echo e(route('training.recommendations.generate')); ?>" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="recommendation_type" value="skill_gap">
                                    <button type="submit" class="dropdown-item">
                                        <i class="bi bi-cpu"></i> Generate Skill Gap Recommendations
                                    </button>
                                </form>
                            </li>
                            <li>
                                <form method="POST" action="<?php echo e(route('training.recommendations.generate')); ?>" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="recommendation_type" value="performance_improvement">
                                    <button type="submit" class="dropdown-item">
                                        <i class="bi bi-graph-up"></i> Generate Performance Recommendations
                                    </button>
                                </form>
                            </li>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['total']); ?></h4>
                                    <p class="mb-0">Total Recommendations</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-lightbulb fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['pending']); ?></h4>
                                    <p class="mb-0">Pending</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-clock fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['accepted']); ?></h4>
                                    <p class="mb-0">Accepted</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-check-circle fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-danger text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['high_priority']); ?></h4>
                                    <p class="mb-0">High Priority</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-exclamation-triangle fs-2"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('training.recommendations.index')); ?>">
                        <div class="row">
                            <div class="col-md-3">
                                <select name="status" class="form-select">
                                    <option value="">All Statuses</option>
                                    <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                    <option value="accepted" <?php echo e(request('status') == 'accepted' ? 'selected' : ''); ?>>Accepted</option>
                                    <option value="declined" <?php echo e(request('status') == 'declined' ? 'selected' : ''); ?>>Declined</option>
                                    <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="type" class="form-select">
                                    <option value="">All Types</option>
                                    <option value="skill_gap" <?php echo e(request('type') == 'skill_gap' ? 'selected' : ''); ?>>Skill Gap</option>
                                    <option value="performance_improvement" <?php echo e(request('type') == 'performance_improvement' ? 'selected' : ''); ?>>Performance Improvement</option>
                                    <option value="career_development" <?php echo e(request('type') == 'career_development' ? 'selected' : ''); ?>>Career Development</option>
                                    <option value="mandatory" <?php echo e(request('type') == 'mandatory' ? 'selected' : ''); ?>>Mandatory</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="priority" class="form-select">
                                    <option value="">All Priorities</option>
                                    <option value="high" <?php echo e(request('priority') == 'high' ? 'selected' : ''); ?>>High (80+)</option>
                                    <option value="medium" <?php echo e(request('priority') == 'medium' ? 'selected' : ''); ?>>Medium (50-79)</option>
                                    <option value="low" <?php echo e(request('priority') == 'low' ? 'selected' : ''); ?>>Low (<50)</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="bi bi-funnel"></i> Filter
                                </button>
                                <a href="<?php echo e(route('training.recommendations.index')); ?>" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Recommendations List -->
            <div class="card">
                <div class="card-body">
                    <?php if($recommendations->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Employee</th>
                                        <th>Training Program</th>
                                        <th>Type</th>
                                        <th>Priority</th>
                                        <th>Status</th>
                                        <th>Recommended</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $recommendations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recommendation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <strong><?php echo e($recommendation->employee->full_name); ?></strong><br>
                                                        <small class="text-muted"><?php echo e($recommendation->employee->position?->title); ?></small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <strong><?php echo e($recommendation->trainingProgram->title); ?></strong><br>
                                                <small class="text-muted"><?php echo e($recommendation->trainingProgram->category->name); ?></small>
                                            </td>
                                            <td>
                                                <span class="badge bg-info"><?php echo e($recommendation->recommendation_type_display); ?></span>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?php echo e($recommendation->priority_color); ?>">
                                                    <?php echo e($recommendation->priority_level); ?> (<?php echo e($recommendation->priority_score); ?>)
                                                </span>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?php echo e($recommendation->status === 'pending' ? 'warning' : ($recommendation->status === 'accepted' ? 'success' : 'secondary')); ?>">
                                                    <?php echo e(ucfirst($recommendation->status)); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <?php echo e($recommendation->recommended_at->format('M j, Y')); ?><br>
                                                <small class="text-muted">by <?php echo e($recommendation->recommendedBy->name); ?></small>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $recommendation)): ?>
                                                        <a href="<?php echo e(route('training.recommendations.show', $recommendation)); ?>" class="btn btn-outline-primary">
                                                            <i class="bi bi-eye"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('respond', $recommendation)): ?>
                                                        <?php if($recommendation->status === 'pending'): ?>
                                                            <button type="button" class="btn btn-outline-success" data-bs-toggle="modal" data-bs-target="#respondModal<?php echo e($recommendation->id); ?>">
                                                                <i class="bi bi-reply"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>

                                        <!-- Response Modal -->
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('respond', $recommendation)): ?>
                                            <?php if($recommendation->status === 'pending'): ?>
                                                <div class="modal fade" id="respondModal<?php echo e($recommendation->id); ?>" tabindex="-1">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <form method="POST" action="<?php echo e(route('training.recommendations.respond', $recommendation)); ?>">
                                                                <?php echo csrf_field(); ?>
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title">Respond to Recommendation</h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="mb-3">
                                                                        <label class="form-label">Response</label>
                                                                        <div>
                                                                            <div class="form-check">
                                                                                <input class="form-check-input" type="radio" name="response" value="accept" id="accept<?php echo e($recommendation->id); ?>">
                                                                                <label class="form-check-label" for="accept<?php echo e($recommendation->id); ?>">
                                                                                    Accept Recommendation
                                                                                </label>
                                                                            </div>
                                                                            <div class="form-check">
                                                                                <input class="form-check-input" type="radio" name="response" value="decline" id="decline<?php echo e($recommendation->id); ?>">
                                                                                <label class="form-check-label" for="decline<?php echo e($recommendation->id); ?>">
                                                                                    Decline Recommendation
                                                                                </label>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label for="response_notes<?php echo e($recommendation->id); ?>" class="form-label">Notes (Optional)</label>
                                                                        <textarea class="form-control" id="response_notes<?php echo e($recommendation->id); ?>" name="response_notes" rows="3"></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit Response</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            <?php echo e($recommendations->appends(request()->query())->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="bi bi-lightbulb fs-1 text-muted"></i>
                            <h4 class="mt-3">No Training Recommendations</h4>
                            <p class="text-muted">No training recommendations found matching your criteria.</p>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingRecommendation::class)): ?>
                                <a href="<?php echo e(route('training.recommendations.create')); ?>" class="btn btn-primary">
                                    Create First Recommendation
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/recommendations/index.blade.php ENDPATH**/ ?>