<?php $__env->startSection('title', 'Recruitment Reports'); ?>
<?php $__env->startSection('page-title', 'Recruitment Analytics'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('job-postings.index')); ?>">Recruitment</a></li>
                <li class="breadcrumb-item active">Reports</li>
            </ol>
        </nav>
    </div>

    <!-- Date Range Filter -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row align-items-end">
                <div class="col-md-3">
                    <label class="form-label">Date Range</label>
                    <select name="date_range" class="form-select" onchange="this.form.submit()">
                        <option value="7" <?php echo e($dateRange == '7' ? 'selected' : ''); ?>>Last 7 days</option>
                        <option value="30" <?php echo e($dateRange == '30' ? 'selected' : ''); ?>>Last 30 days</option>
                        <option value="90" <?php echo e($dateRange == '90' ? 'selected' : ''); ?>>Last 90 days</option>
                        <option value="365" <?php echo e($dateRange == '365' ? 'selected' : ''); ?>>Last year</option>
                    </select>
                </div>
                <div class="col-md-9 text-end">
                    <a href="<?php echo e(route('recruitment.reports.detailed')); ?>" class="btn btn-outline-primary">
                        <i class="bi bi-table"></i> Detailed Report
                    </a>
                    <a href="<?php echo e(route('recruitment.reports.export')); ?>?format=csv&date_range=<?php echo e($dateRange); ?>" class="btn btn-success">
                        <i class="bi bi-download"></i> Export CSV
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Key Metrics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-primary"><?php echo e($metrics['total_job_postings']); ?></h3>
                            <small class="text-muted">Total Job Postings</small>
                        </div>
                        <div class="text-primary">
                            <i class="bi bi-briefcase fs-2"></i>
                        </div>
                    </div>
                    <small class="text-success"><?php echo e($metrics['active_job_postings']); ?> active</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-success"><?php echo e($metrics['total_applications']); ?></h3>
                            <small class="text-muted">Total Applications</small>
                        </div>
                        <div class="text-success">
                            <i class="bi bi-people fs-2"></i>
                        </div>
                    </div>
                    <small class="text-info"><?php echo e($metrics['applications_this_period']); ?> this period</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-warning"><?php echo e($metrics['avg_time_to_hire']); ?></h3>
                            <small class="text-muted">Avg. Time to Hire (days)</small>
                        </div>
                        <div class="text-warning">
                            <i class="bi bi-clock fs-2"></i>
                        </div>
                    </div>
                    <small class="text-muted">Industry avg: 23 days</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-info"><?php echo e($metrics['conversion_rate']); ?>%</h3>
                            <small class="text-muted">Conversion Rate</small>
                        </div>
                        <div class="text-info">
                            <i class="bi bi-graph-up fs-2"></i>
                        </div>
                    </div>
                    <small class="text-muted"><?php echo e($metrics['offers_extended']); ?> offers extended</small>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Application Status Distribution -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Application Status Distribution</h5>
                </div>
                <div class="card-body">
                    <canvas id="statusChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <!-- Applications Over Time -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Applications Over Time</h5>
                </div>
                <div class="card-body">
                    <canvas id="timeChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Top Performing Job Postings -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Top Performing Job Postings</h5>
                </div>
                <div class="card-body">
                    <?php if($topJobPostings->count() > 0): ?>
                        <?php $__currentLoopData = $topJobPostings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div>
                                    <h6 class="mb-1"><?php echo e($job->title); ?></h6>
                                    <small class="text-muted"><?php echo e($job->department->name ?? 'N/A'); ?></small>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-primary"><?php echo e($job->applications_count); ?> applications</span>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p class="text-muted text-center">No job postings found</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Department Performance -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Department Performance</h5>
                </div>
                <div class="card-body">
                    <?php if($departmentStats->count() > 0): ?>
                        <?php $__currentLoopData = $departmentStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-1">
                                    <h6 class="mb-0"><?php echo e($dept->department_name); ?></h6>
                                    <small class="text-muted"><?php echo e($dept->applications_count); ?> applications</small>
                                </div>
                                <div class="progress" style="height: 6px;">
                                    <div class="progress-bar" role="progressbar" 
                                         style="width: <?php echo e(min($dept->offer_rate, 100)); ?>%" 
                                         aria-valuenow="<?php echo e($dept->offer_rate); ?>" 
                                         aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                                <small class="text-muted"><?php echo e(number_format($dept->offer_rate, 1)); ?>% offer rate</small>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p class="text-muted text-center">No department data available</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Applications -->
    <div class="card shadow-sm">
        <div class="card-header bg-white">
            <h5 class="mb-0">Recent Applications</h5>
        </div>
        <div class="card-body">
            <?php if($recentApplications->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Applicant</th>
                                <th>Position</th>
                                <th>Department</th>
                                <th>Status</th>
                                <th>Applied</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $recentApplications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($application->full_name); ?></strong><br>
                                        <small class="text-muted"><?php echo e($application->email); ?></small>
                                    </td>
                                    <td><?php echo e($application->jobPosting->title); ?></td>
                                    <td><?php echo e($application->jobPosting->department->name ?? 'N/A'); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($application->status === 'new' ? 'primary' : ($application->status === 'offered' ? 'success' : 'secondary')); ?>">
                                            <?php echo e(ucfirst($application->status)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($application->applied_at->diffForHumans()); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-muted text-center">No recent applications</p>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Status Distribution Chart
    const statusCtx = document.getElementById('statusChart').getContext('2d');
    const statusData = <?php echo json_encode($statusDistribution, 15, 512) ?>;
    
    new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: Object.keys(statusData).map(status => status.charAt(0).toUpperCase() + status.slice(1)),
            datasets: [{
                data: Object.values(statusData),
                backgroundColor: [
                    '#0d6efd', '#6c757d', '#28a745', '#ffc107', '#dc3545', '#6f42c1'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Applications Over Time Chart
    const timeCtx = document.getElementById('timeChart').getContext('2d');
    const timeData = <?php echo json_encode($applicationsOverTime, 15, 512) ?>;
    
    new Chart(timeCtx, {
        type: 'line',
        data: {
            labels: timeData.map(item => item.date),
            datasets: [{
                label: 'Applications',
                data: timeData.map(item => item.count),
                borderColor: '#0d6efd',
                backgroundColor: 'rgba(13, 110, 253, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/recruitment/reports/index.blade.php ENDPATH**/ ?>