<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'item',
    'resource',
    'canView' => true,
    'canEdit' => true,
    'canDelete' => true,
    'viewRoute' => null,
    'editRoute' => null,
    'deleteRoute' => null,
    'deleteConfirm' => 'Are you sure you want to delete this item?',
    'size' => 'sm',
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'item',
    'resource',
    'canView' => true,
    'canEdit' => true,
    'canDelete' => true,
    'viewRoute' => null,
    'editRoute' => null,
    'deleteRoute' => null,
    'deleteConfirm' => 'Are you sure you want to delete this item?',
    'size' => 'sm',
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $viewRoute = $viewRoute ?? route($resource . '.show', $item);
    $editRoute = $editRoute ?? route($resource . '.edit', $item);
    $deleteRoute = $deleteRoute ?? route($resource . '.destroy', $item);
    $btnSize = $size === 'sm' ? 'btn-sm' : '';
?>

<div class="btn-group btn-group-<?php echo e($size); ?>">
    <?php if($canView): ?>
        <a href="<?php echo e($viewRoute); ?>" class="btn btn-outline-primary <?php echo e($btnSize); ?>" title="View">
            <i class="bi bi-eye"></i>
        </a>
    <?php endif; ?>
    
    <?php if($canEdit): ?>
        <a href="<?php echo e($editRoute); ?>" class="btn btn-outline-secondary <?php echo e($btnSize); ?>" title="Edit">
            <i class="bi bi-pencil"></i>
        </a>
    <?php endif; ?>
    
    <?php if(isset($extra)): ?>
        <?php echo e($extra); ?>

    <?php endif; ?>
    
    <?php if($canDelete): ?>
        <form action="<?php echo e($deleteRoute); ?>" method="POST" class="d-inline">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" class="btn btn-outline-danger <?php echo e($btnSize); ?>" 
                    onclick="return confirm('<?php echo e($deleteConfirm); ?>')" title="Delete">
                <i class="bi bi-trash"></i>
            </button>
        </form>
    <?php endif; ?>
</div>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/components/action-buttons.blade.php ENDPATH**/ ?>