<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Offer</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .email-wrapper {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
        }
        .header {
            background-color: #4F46E5;
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px 20px;
        }
        .info-box {
            background-color: #F3F4F6;
            border-left: 4px solid #4F46E5;
            padding: 15px;
            margin: 20px 0;
        }
        .credentials-box {
            background-color: #FEF3C7;
            border: 2px solid #F59E0B;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .credential-item {
            margin: 10px 0;
        }
        .credential-label {
            font-weight: bold;
            color: #4F46E5;
        }
        .warning {
            background-color: #FEE2E2;
            border-left: 4px solid #DC2626;
            padding: 15px;
            margin: 20px 0;
        }
        .success-box {
            background-color: #D1FAE5;
            border-left: 4px solid #10B981;
            padding: 15px;
            margin: 20px 0;
        }
        .button {
            display: inline-block;
            background-color: #4F46E5;
            color: #ffffff;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 4px;
            margin: 20px 0;
        }
        .footer {
            background-color: #F9FAFB;
            padding: 20px;
            text-align: center;
            color: #6B7280;
            font-size: 14px;
        }
        ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="header">
            <h1>🎉 Congratulations!</h1>
            <p style="margin: 10px 0 0 0;">Job Offer</p>
        </div>

        <div class="content">
            <h2>Hello <?php echo e($offer->application->full_name); ?>,</h2>
            
            <p>We are thrilled to extend you an offer for the position of <strong><?php echo e($offer->position_title); ?></strong> at <?php echo e($offer->application->jobPosting->organization->name); ?>!</p>

            <div class="success-box">
                <h3 style="margin-top: 0;">Offer Summary</h3>
                <p>
                    <strong>Position:</strong> <?php echo e($offer->position_title); ?><br>
                    <strong>Salary:</strong> <?php echo e($offer->formatted_salary); ?><br>
                    <strong>Start Date:</strong> <?php echo e($offer->start_date->format('F j, Y')); ?>

                    <?php if($offer->expires_at): ?>
                    <br><strong>Offer Expires:</strong> <?php echo e($offer->expires_at->format('F j, Y')); ?>

                    <?php endif; ?>
                </p>
            </div>

            <div style="text-align: center;">
                <a href="<?php echo e($offerUrl); ?>" class="button">View Full Offer & Respond</a>
            </div>

            <p>Please review the complete offer details and respond at your earliest convenience.</p>

            <p>We look forward to welcoming you to our team!</p>

            <p>Best regards,<br>
            <strong><?php echo e($offer->application->jobPosting->organization->name); ?> HR Team</strong></p>
        </div>

        <div class="footer">
            <p>This is an automated message from <?php echo e($offer->application->jobPosting->organization->name); ?>.<br>
            Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/emails/job-offer-sent.blade.php ENDPATH**/ ?>