<?php $__env->startSection('title', 'Reset Password'); ?>

<?php $__env->startSection('full-page', true); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .forgot-password-image-section {
        background-image: url('<?php echo e(asset('images/landing/login.jpg')); ?>');
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="login-container">
    <!-- Image Section -->
    <div class="image-section forgot-password-image-section">
        <div class="image-content">
            <h1>Reset Your <span class="highlight">Password</span></h1>
            <p>Don't worry, it happens to the best of us. Enter your email address and we'll send you a link to reset your password.</p>
            
            <ul class="feature-list">
                <li><i class="bi bi-check-circle-fill"></i> Secure Password Recovery</li>
                <li><i class="bi bi-check-circle-fill"></i> Email Verification</li>
                <li><i class="bi bi-check-circle-fill"></i> Account Protection</li>
                <li><i class="bi bi-check-circle-fill"></i> Quick Access Restoration</li>
            </ul>

            <div class="footer-text">
                &copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.
            </div>
        </div>
    </div>

    <!-- Form Section -->
    <div class="auth-form-section">
        <div class="auth-form">
            <div class="auth-header">
                <i class="bi bi-key"></i>
                <h2>Forgot Password</h2>
                <p>Enter your email to reset your password</p>
            </div>

            <?php if(session('status')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle me-2"></i><?php echo e(session('status')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($error); ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('password.email')); ?>">
                <?php echo csrf_field(); ?>

                <div class="mb-3">
                    <label for="email" class="form-label">Email Address</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-envelope"></i>
                        </span>
                        <input type="email"
                               class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               id="email"
                               name="email"
                               value="<?php echo e(old('email')); ?>"
                               placeholder="Enter your email address"
                               required
                               autofocus>
                    </div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <button type="submit" class="btn-auth-primary">
                    <i class="bi bi-send me-2"></i>Send Reset Link
                </button>
            </form>

            <div class="auth-footer-link">
                Remember your password? <a href="<?php echo e(route('login')); ?>">Back to login</a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/auth/passwords/email.blade.php ENDPATH**/ ?>