<?php $__env->startSection('title', 'Learning Path Progress'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0"><?php echo e($enrollment->learningPath->title); ?> - Progress</h1>
                <div class="btn-group">
                    <a href="<?php echo e(route('training.learning-paths.show', $enrollment->learningPath)); ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Learning Path
                    </a>
                    <a href="<?php echo e(route('training.learning-paths.my-paths')); ?>" class="btn btn-outline-primary">
                        <i class="bi bi-person"></i> My Learning Paths
                    </a>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <!-- Progress Overview -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="mb-0">Overall Progress</h5>
                                <span class="badge bg-<?php echo e($enrollment->status === 'completed' ? 'success' : ($enrollment->status === 'in_progress' ? 'warning' : 'info')); ?>">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $enrollment->status))); ?>

                                </span>
                            </div>
                            
                            <div class="progress mb-3" style="height: 20px;">
                                <div class="progress-bar bg-<?php echo e($enrollment->status === 'completed' ? 'success' : 'primary'); ?>" 
                                     style="width: <?php echo e($enrollment->progress_percentage); ?>%">
                                    <?php echo e(number_format($enrollment->progress_percentage, 1)); ?>%
                                </div>
                            </div>

                            <div class="row text-center">
                                <div class="col-md-3">
                                    <h6 class="text-muted">Current Step</h6>
                                    <h4><?php echo e($enrollment->current_step); ?>/<?php echo e($enrollment->learningPath->total_steps); ?></h4>
                                </div>
                                <div class="col-md-3">
                                    <h6 class="text-muted">Enrolled</h6>
                                    <p class="mb-0"><?php echo e($enrollment->enrolled_at->format('M j, Y')); ?></p>
                                </div>
                                <div class="col-md-3">
                                    <h6 class="text-muted">Started</h6>
                                    <p class="mb-0"><?php echo e($enrollment->started_at ? $enrollment->started_at->format('M j, Y') : 'Not started'); ?></p>
                                </div>
                                <div class="col-md-3">
                                    <h6 class="text-muted">Estimated Duration</h6>
                                    <p class="mb-0"><?php echo e($enrollment->learningPath->estimated_duration_hours); ?> hours</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Learning Steps Progress -->
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0"><i class="bi bi-list-check"></i> Learning Steps</h5>
                            <form method="POST" action="<?php echo e(route('training.learning-paths.update-progress', $enrollment)); ?>" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-outline-primary btn-sm">
                                    <i class="bi bi-arrow-clockwise"></i> Update Progress
                                </button>
                            </form>
                        </div>
                        <div class="card-body">
                            <?php if($enrollment->learningPath->steps->count() > 0): ?>
                                <?php $__currentLoopData = $enrollment->learningPath->steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $isCompleted = $stepProgress[$step->id]['completed'] ?? false;
                                        $isCurrent = $step->step_order == $enrollment->current_step;
                                        $isPast = $step->step_order < $enrollment->current_step;
                                        $isFuture = $step->step_order > $enrollment->current_step;
                                    ?>
                                    
                                    <div class="d-flex align-items-start mb-4 <?php echo e(!$loop->last ? 'border-bottom pb-4' : ''); ?>">
                                        <div class="flex-shrink-0 me-3">
                                            <div class="rounded-circle d-flex align-items-center justify-content-center" 
                                                 style="width: 50px; height: 50px;"
                                                 class="bg-<?php echo e($isCompleted ? 'success' : ($isCurrent ? 'primary' : ($isPast ? 'warning' : 'light'))); ?> 
                                                        text-<?php echo e($isCompleted || $isCurrent || $isPast ? 'white' : 'dark'); ?>">
                                                <?php if($isCompleted): ?>
                                                    <i class="bi bi-check-lg"></i>
                                                <?php elseif($isCurrent): ?>
                                                    <i class="bi bi-play-fill"></i>
                                                <?php else: ?>
                                                    <?php echo e($step->step_order); ?>

                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <div>
                                                    <h6 class="mb-1">
                                                        Step <?php echo e($step->step_order); ?>: <?php echo e($step->trainingProgram->title); ?>

                                                        <?php if($isCurrent): ?>
                                                            <span class="badge bg-primary ms-2">Current</span>
                                                        <?php endif; ?>
                                                    </h6>
                                                    <div class="mb-2">
                                                        <?php if($step->is_required): ?>
                                                            <span class="badge bg-danger">Required</span>
                                                        <?php else: ?>
                                                            <span class="badge bg-secondary">Optional</span>
                                                        <?php endif; ?>
                                                        <?php if($isCompleted): ?>
                                                            <span class="badge bg-success">Completed</span>
                                                        <?php elseif($isCurrent): ?>
                                                            <span class="badge bg-warning">In Progress</span>
                                                        <?php elseif($isFuture): ?>
                                                            <span class="badge bg-light text-dark">Upcoming</span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <p class="text-muted mb-2"><?php echo e(Str::limit($step->trainingProgram->description, 150)); ?></p>
                                            
                                            <div class="row align-items-center">
                                                <div class="col-md-6">
                                                    <small class="text-muted">
                                                        <i class="bi bi-clock"></i> <?php echo e($step->trainingProgram->duration_hours); ?> hours
                                                        <i class="bi bi-tag ms-2"></i> <?php echo e($step->trainingProgram->category->name); ?>

                                                        <i class="bi bi-signal ms-2"></i> <?php echo e(ucfirst($step->trainingProgram->difficulty_level)); ?>

                                                    </small>
                                                </div>
                                                <div class="col-md-6 text-end">
                                                    <div class="btn-group btn-group-sm">
                                                        <a href="<?php echo e(route('training.programs.show', $step->trainingProgram)); ?>" 
                                                           class="btn btn-outline-primary">
                                                            <i class="bi bi-eye"></i> View Program
                                                        </a>
                                                        <?php if($isCurrent && !$isCompleted): ?>
                                                            <a href="<?php echo e(route('training.index')); ?>" 
                                                               class="btn btn-primary">
                                                                <i class="bi bi-play"></i> Start Training
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php if($step->hasPrerequisites()): ?>
                                                <div class="mt-2">
                                                    <small class="text-muted">
                                                        <i class="bi bi-info-circle"></i> 
                                                        Prerequisites: Complete steps <?php echo e(implode(', ', $step->prerequisites)); ?> first
                                                    </small>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="bi bi-list-check fs-1 text-muted"></i>
                                    <h5 class="mt-3">No Steps Available</h5>
                                    <p class="text-muted">This learning path doesn't have any steps configured yet.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <!-- Quick Stats -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-graph-up"></i> Your Progress</h5>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6 mb-3">
                                    <h6 class="text-muted">Completed Steps</h6>
                                    <h3 class="text-success"><?php echo e(collect($stepProgress)->where('completed', true)->count()); ?></h3>
                                </div>
                                <div class="col-6 mb-3">
                                    <h6 class="text-muted">Remaining Steps</h6>
                                    <h3 class="text-primary"><?php echo e(collect($stepProgress)->where('completed', false)->count()); ?></h3>
                                </div>
                                <div class="col-12">
                                    <h6 class="text-muted">Overall Progress</h6>
                                    <h3 class="text-info"><?php echo e(number_format($enrollment->progress_percentage, 1)); ?>%</h3>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Learning Path Info -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-info-circle"></i> Learning Path Info</h5>
                        </div>
                        <div class="card-body">
                            <h6><?php echo e($enrollment->learningPath->title); ?></h6>
                            <p class="text-muted small"><?php echo e(Str::limit($enrollment->learningPath->description, 100)); ?></p>
                            
                            <?php if($enrollment->learningPath->learning_outcomes): ?>
                                <div class="mb-3">
                                    <small class="text-muted">Learning Outcomes:</small>
                                    <ul class="small mb-0">
                                        <?php $__currentLoopData = array_slice($enrollment->learningPath->learning_outcomes, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outcome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($outcome); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($enrollment->learningPath->learning_outcomes) > 3): ?>
                                            <li class="text-muted">+<?php echo e(count($enrollment->learningPath->learning_outcomes) - 3); ?> more...</li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <div class="row text-center">
                                <div class="col-6">
                                    <small class="text-muted">Difficulty</small><br>
                                    <span class="badge bg-<?php echo e($enrollment->learningPath->difficulty_color); ?>">
                                        <?php echo e(ucfirst($enrollment->learningPath->difficulty_level)); ?>

                                    </span>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Duration</small><br>
                                    <strong><?php echo e($enrollment->learningPath->estimated_duration_hours); ?>h</strong>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Next Steps -->
                    <?php if($enrollment->status !== 'completed'): ?>
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="bi bi-arrow-right-circle"></i> Next Steps</h5>
                            </div>
                            <div class="card-body">
                                <?php
                                    $currentStepDetails = $enrollment->getCurrentStepDetails();
                                    $nextStepDetails = $enrollment->getNextStepDetails();
                                ?>
                                
                                <?php if($currentStepDetails): ?>
                                    <div class="mb-3">
                                        <h6 class="text-primary">Current Step:</h6>
                                        <p class="mb-1"><strong><?php echo e($currentStepDetails->trainingProgram->title); ?></strong></p>
                                        <small class="text-muted"><?php echo e($currentStepDetails->trainingProgram->duration_hours); ?> hours</small>
                                    </div>
                                    
                                    <a href="<?php echo e(route('training.programs.show', $currentStepDetails->trainingProgram)); ?>" 
                                       class="btn btn-primary w-100 mb-3">
                                        <i class="bi bi-play"></i> Continue Current Step
                                    </a>
                                <?php endif; ?>

                                <?php if($nextStepDetails): ?>
                                    <div class="mb-3">
                                        <h6 class="text-muted">Next Step:</h6>
                                        <p class="mb-1"><?php echo e($nextStepDetails->trainingProgram->title); ?></p>
                                        <small class="text-muted"><?php echo e($nextStepDetails->trainingProgram->duration_hours); ?> hours</small>
                                    </div>
                                <?php endif; ?>

                                <div class="alert alert-info">
                                    <small>
                                        <i class="bi bi-lightbulb"></i>
                                        Complete your current step to automatically advance to the next one.
                                    </small>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="card">
                            <div class="card-body text-center">
                                <i class="bi bi-trophy fs-1 text-warning"></i>
                                <h5 class="mt-3 text-success">Congratulations!</h5>
                                <p class="text-muted">You have successfully completed this learning path.</p>
                                <small class="text-muted">
                                    Completed on <?php echo e($enrollment->completed_at->format('M j, Y')); ?>

                                </small>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/learning-paths/progress.blade.php ENDPATH**/ ?>