<?php $__env->startSection('title', 'Payment History'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2><i class="bi bi-clock-history"></i> Payment History</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('organization.payments.index')); ?>">Invoices & Payments</a></li>
                    <li class="breadcrumb-item active">Payment History</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">All Payments</h5>
                <a href="<?php echo e(route('organization.payments.index')); ?>" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-arrow-left"></i> Back to Invoices
                </a>
            </div>
        </div>
        <div class="card-body">
            <?php if($payments->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Invoice</th>
                                <th>Method</th>
                                <th>Transaction ID</th>
                                <th>M-Pesa Receipt</th>
                                <th class="text-end">Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($payment->completed_at): ?>
                                        <?php echo e($payment->completed_at->format('M d, Y H:i')); ?>

                                    <?php elseif($payment->initiated_at): ?>
                                        <?php echo e($payment->initiated_at->format('M d, Y H:i')); ?>

                                    <?php else: ?>
                                        <?php echo e($payment->created_at->format('M d, Y H:i')); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($payment->invoice): ?>
                                        <a href="<?php echo e(route('organization.payments.show', $payment->invoice)); ?>">
                                            <?php echo e($payment->invoice->invoice_number); ?>

                                        </a>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($payment->payment_method === 'mpesa'): ?>
                                        <i class="bi bi-phone text-success"></i> M-Pesa
                                    <?php else: ?>
                                        <?php echo e(ucfirst($payment->payment_method)); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small class="font-monospace"><?php echo e($payment->transaction_id ?? '-'); ?></small>
                                </td>
                                <td>
                                    <?php if($payment->mpesa_receipt_number): ?>
                                        <span class="badge bg-success"><?php echo e($payment->mpesa_receipt_number); ?></span>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="text-end">
                                    <strong><?php echo e($payment->currency); ?> <?php echo e(number_format($payment->amount, 2)); ?></strong>
                                </td>
                                <td>
                                    <?php if($payment->status === 'completed'): ?>
                                        <span class="badge bg-success">
                                            <i class="bi bi-check-circle"></i> Completed
                                        </span>
                                    <?php elseif($payment->status === 'pending'): ?>
                                        <span class="badge bg-warning">
                                            <i class="bi bi-clock"></i> Pending
                                        </span>
                                    <?php elseif($payment->status === 'failed'): ?>
                                        <span class="badge bg-danger">
                                            <i class="bi bi-x-circle"></i> Failed
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e(ucfirst($payment->status)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($payment->status === 'pending'): ?>
                                        <form method="POST" action="<?php echo e(route('organization.payments.query', $payment)); ?>" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-primary" title="Check Status">
                                                <i class="bi bi-arrow-clockwise"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    
                                    <?php if($payment->invoice): ?>
                                        <a href="<?php echo e(route('organization.payments.show', $payment->invoice)); ?>" 
                                           class="btn btn-sm btn-outline-secondary" 
                                           title="View Invoice">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr class="table-light">
                                <td colspan="5" class="text-end"><strong>Total Paid:</strong></td>
                                <td class="text-end">
                                    <strong>
                                        KES <?php echo e(number_format($payments->where('status', 'completed')->sum('amount'), 2)); ?>

                                    </strong>
                                </td>
                                <td colspan="2"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="mt-3">
                    <?php echo e($payments->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="bi bi-clock-history text-muted" style="font-size: 3rem;"></i>
                    <p class="text-muted mt-3">No payment history yet</p>
                    <p class="text-muted">Payments will appear here once you make your first payment</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Payment Statistics -->
    <?php if($payments->count() > 0): ?>
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h6 class="card-title">Completed Payments</h6>
                    <h3><?php echo e($payments->where('status', 'completed')->count()); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <h6 class="card-title">Pending Payments</h6>
                    <h3><?php echo e($payments->where('status', 'pending')->count()); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-danger">
                <div class="card-body">
                    <h6 class="card-title">Failed Payments</h6>
                    <h3><?php echo e($payments->where('status', 'failed')->count()); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <h6 class="card-title">Total Amount</h6>
                    <h3>KES <?php echo e(number_format($payments->sum('amount'), 0)); ?></h3>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Help Section -->
    <div class="card mt-4 border-info">
        <div class="card-body">
            <h6><i class="bi bi-info-circle text-info"></i> About Payment History</h6>
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Payment Status:</strong></p>
                    <ul class="small">
                        <li><span class="badge bg-success">Completed</span> - Payment successfully processed</li>
                        <li><span class="badge bg-warning">Pending</span> - Payment initiated, awaiting confirmation</li>
                        <li><span class="badge bg-danger">Failed</span> - Payment was unsuccessful</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <p><strong>Need Help?</strong></p>
                    <ul class="small">
                        <li>For pending payments, click the refresh icon to check status</li>
                        <li>Failed payments can be retried from the invoice page</li>
                        <li>Contact support if you have questions about a payment</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/organization/payments/history.blade.php ENDPATH**/ ?>