<?php $__env->startSection('title', 'Edit Training Performance Impact'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Edit Training Performance Impact</h1>
                <a href="<?php echo e(route('training.performance.show', $impact)); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Details
                </a>
            </div>

            <div class="card">
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('training.performance.update', $impact)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Employee</label>
                                    <input type="text" class="form-control" value="<?php echo e($impact->employee->full_name); ?> - <?php echo e($impact->employee->position?->title); ?>" readonly>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Training Program</label>
                                    <input type="text" class="form-control" value="<?php echo e($impact->trainingProgram->title); ?> (<?php echo e($impact->trainingProgram->category->name); ?>)" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="performance_score_before" class="form-label">Performance Score Before Training <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['performance_score_before'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="performance_score_before" name="performance_score_before" 
                                           min="0" max="5" step="0.1" value="<?php echo e(old('performance_score_before', $impact->performance_score_before)); ?>" required>
                                    <div class="form-text">Scale: 0.0 - 5.0</div>
                                    <?php $__errorArgs = ['performance_score_before'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="performance_score_after" class="form-label">Performance Score After Training <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['performance_score_after'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="performance_score_after" name="performance_score_after" 
                                           min="0" max="5" step="0.1" value="<?php echo e(old('performance_score_after', $impact->performance_score_after)); ?>" required>
                                    <div class="form-text">Scale: 0.0 - 5.0</div>
                                    <?php $__errorArgs = ['performance_score_after'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="training_completed_date" class="form-label">Training Completed Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control <?php $__errorArgs = ['training_completed_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="training_completed_date" name="training_completed_date" 
                                           value="<?php echo e(old('training_completed_date', $impact->training_completed_date->format('Y-m-d'))); ?>" required>
                                    <?php $__errorArgs = ['training_completed_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="performance_measured_date" class="form-label">Performance Measured Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control <?php $__errorArgs = ['performance_measured_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="performance_measured_date" name="performance_measured_date" 
                                           value="<?php echo e(old('performance_measured_date', $impact->performance_measured_date->format('Y-m-d'))); ?>" required>
                                    <div class="form-text">Must be on or after training completion date</div>
                                    <?php $__errorArgs = ['performance_measured_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Skill Improvements</label>
                            <div id="skill-improvements">
                                <?php if(old('skill_improvements_skill') || $impact->skill_improvements): ?>
                                    <?php
                                        $skills = old('skill_improvements_skill') ? 
                                            array_combine(old('skill_improvements_skill'), old('skill_improvements_value')) : 
                                            ($impact->skill_improvements ?? []);
                                    ?>
                                    <?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill => $improvement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="row mb-2">
                                            <div class="col-md-6">
                                                <input type="text" class="form-control" name="skill_improvements_skill[]" 
                                                       value="<?php echo e($skill); ?>" placeholder="Skill name">
                                            </div>
                                            <div class="col-md-4">
                                                <input type="number" class="form-control" name="skill_improvements_value[]" 
                                                       value="<?php echo e($improvement); ?>" min="-5" max="5" step="0.1" 
                                                       placeholder="Improvement (+/-)">
                                            </div>
                                            <div class="col-md-2">
                                                <button type="button" class="btn btn-outline-danger remove-skill">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div class="row mb-2">
                                        <div class="col-md-6">
                                            <input type="text" class="form-control" name="skill_improvements_skill[]" 
                                                   placeholder="Skill name">
                                        </div>
                                        <div class="col-md-4">
                                            <input type="number" class="form-control" name="skill_improvements_value[]" 
                                                   min="-5" max="5" step="0.1" placeholder="Improvement (+/-)">
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-outline-danger remove-skill">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-skill">
                                <i class="bi bi-plus"></i> Add Skill Improvement
                            </button>
                        </div>

                        <div class="mb-3">
                            <label for="impact_notes" class="form-label">Impact Notes</label>
                            <textarea class="form-control <?php $__errorArgs = ['impact_notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="impact_notes" name="impact_notes" rows="4" 
                                      placeholder="Additional notes about the training impact, observations, feedback..."><?php echo e(old('impact_notes', $impact->impact_notes)); ?></textarea>
                            <?php $__errorArgs = ['impact_notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            <strong>Performance Impact Calculation:</strong>
                            <div id="impact-preview" class="mt-2">
                                <span class="badge bg-secondary">Enter scores to see impact calculation</span>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a href="<?php echo e(route('training.performance.show', $impact)); ?>" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check"></i> Update Impact
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const beforeScore = document.getElementById('performance_score_before');
    const afterScore = document.getElementById('performance_score_after');
    const impactPreview = document.getElementById('impact-preview');
    
    function updateImpactPreview() {
        const before = parseFloat(beforeScore.value) || 0;
        const after = parseFloat(afterScore.value) || 0;
        
        if (before > 0 && after > 0) {
            const improvement = after - before;
            const percentage = ((improvement / before) * 100).toFixed(1);
            
            let badgeClass = 'bg-secondary';
            let icon = 'dash';
            
            if (improvement > 0) {
                badgeClass = 'bg-success';
                icon = 'arrow-up';
            } else if (improvement < 0) {
                badgeClass = 'bg-danger';
                icon = 'arrow-down';
            }
            
            impactPreview.innerHTML = `
                <span class="badge ${badgeClass}">
                    <i class="bi bi-${icon}"></i> 
                    ${improvement > 0 ? '+' : ''}${improvement.toFixed(2)} points 
                    (${improvement > 0 ? '+' : ''}${percentage}%)
                </span>
            `;
        }
    }
    
    beforeScore.addEventListener('input', updateImpactPreview);
    afterScore.addEventListener('input', updateImpactPreview);
    
    // Initialize preview
    updateImpactPreview();
    
    // Add skill improvement
    document.getElementById('add-skill').addEventListener('click', function() {
        const container = document.getElementById('skill-improvements');
        const div = document.createElement('div');
        div.className = 'row mb-2';
        div.innerHTML = `
            <div class="col-md-6">
                <input type="text" class="form-control" name="skill_improvements_skill[]" 
                       placeholder="Skill name">
            </div>
            <div class="col-md-4">
                <input type="number" class="form-control" name="skill_improvements_value[]" 
                       min="-5" max="5" step="0.1" placeholder="Improvement (+/-)">
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-outline-danger remove-skill">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
        `;
        container.appendChild(div);
    });
    
    // Remove skill improvement
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-skill')) {
            const skills = document.querySelectorAll('#skill-improvements .row');
            if (skills.length > 1) {
                e.target.closest('.row').remove();
            }
        }
    });
    
    // Validate performance measured date
    const trainingDate = document.getElementById('training_completed_date');
    const measuredDate = document.getElementById('performance_measured_date');
    
    trainingDate.addEventListener('change', function() {
        measuredDate.min = this.value;
        if (measuredDate.value && measuredDate.value < this.value) {
            measuredDate.value = this.value;
        }
    });
    
    // Set initial min date
    measuredDate.min = trainingDate.value;
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/performance/edit.blade.php ENDPATH**/ ?>