<?php $__env->startSection('title', 'Subscription Plans'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12 text-center mb-5">
            <h2>Choose Your Plan</h2>
            <p class="text-muted">Select the perfect plan for your organization</p>
        </div>
    </div>

    <div class="row justify-content-center">
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-4 mb-4">
            <div class="card h-100 <?php echo e($currentSubscription && $currentSubscription->subscription_plan_id == $plan->id ? 'border-primary' : ''); ?>">
                <?php if($currentSubscription && $currentSubscription->subscription_plan_id == $plan->id): ?>
                <div class="card-header bg-primary text-white text-center">
                    <strong><i class="bi bi-check-circle"></i> Current Plan</strong>
                </div>
                <?php endif; ?>
                
                <div class="card-body text-center">
                    <h3 class="card-title"><?php echo e($plan->name); ?></h3>
                    <h2 class="text-primary my-4">
                        KES <?php echo e(number_format($plan->price_monthly, 0)); ?>

                        <small class="text-muted fs-6">/month</small>
                    </h2>
                    <p class="text-muted"><?php echo e($plan->description); ?></p>
                    
                    <hr>
                    
                    <ul class="list-unstyled text-start">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <strong><?php echo e($plan->max_employees ?? 'Unlimited'); ?></strong> Employees
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <strong><?php echo e($plan->max_users ?? 'Unlimited'); ?></strong> Users
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <strong><?php echo e($plan->storage_limit_gb); ?> GB</strong> Storage
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <strong><?php echo e(count($plan->features['modules'])); ?></strong> Modules
                        </li>
                        <?php if($plan->hasApiAccess()): ?>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            API Access
                        </li>
                        <?php endif; ?>
                        <?php if($plan->hasFeature('white_label')): ?>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            White Label
                        </li>
                        <?php endif; ?>
                        <?php if($plan->hasFeature('custom_domain')): ?>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            Custom Domain
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
                
                <div class="card-footer text-center">
                    <?php if($currentSubscription && $currentSubscription->subscription_plan_id == $plan->id): ?>
                        <button class="btn btn-secondary" disabled>Current Plan</button>
                    <?php else: ?>
                        <a href="<?php echo e(route('subscription.upgrade', $plan)); ?>" class="btn btn-primary">
                            <?php if($currentSubscription): ?>
                                <?php if($plan->price_monthly > $currentSubscription->plan->price_monthly): ?>
                                    Upgrade to <?php echo e($plan->name); ?>

                                <?php else: ?>
                                    Downgrade to <?php echo e($plan->name); ?>

                                <?php endif; ?>
                            <?php else: ?>
                                Select <?php echo e($plan->name); ?>

                            <?php endif; ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/organization/subscription/plans.blade.php ENDPATH**/ ?>