<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['type' => null, 'daysRemaining' => null, 'endsAt' => null, 'upgradeUrl' => null]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['type' => null, 'daysRemaining' => null, 'endsAt' => null, 'upgradeUrl' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php if($type === 'trial'): ?>
    <!-- Trial Banner -->
    <div class="alert alert-info alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="bi bi-clock-history fs-4 me-3"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Trial Period Active</h5>
                <p class="mb-0">
                    You have <strong><?php echo e($daysRemaining); ?> days</strong> remaining in your trial. 
                    Enjoying your plan? 
                    <a href="<?php echo e($upgradeUrl); ?>" class="alert-link">Upgrade now</a> to continue after trial ends.
                </p>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php elseif($type === 'expired'): ?>
    <!-- Expired Banner -->
    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="bi bi-exclamation-triangle fs-4 me-3"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Trial Expired</h5>
                <p class="mb-0">
                    Your trial period has ended. 
                    <a href="<?php echo e($upgradeUrl); ?>" class="alert-link fw-bold">Subscribe now</a> to continue using all features.
                </p>
            </div>
        </div>
    </div>
<?php elseif($type === 'past_due'): ?>
    <!-- Past Due Banner -->
    <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="bi bi-exclamation-circle fs-4 me-3"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Payment Overdue</h5>
                <p class="mb-0">
                    Your subscription payment is overdue. 
                    <a href="<?php echo e(route('organization.payments.index')); ?>" class="alert-link fw-bold">Pay now</a> to avoid service interruption.
                </p>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php elseif($type === 'cancelled'): ?>
    <!-- Cancelled Banner -->
    <div class="alert alert-secondary alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="bi bi-info-circle fs-4 me-3"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Subscription Cancelled</h5>
                <p class="mb-0">
                    Your subscription will remain active until <?php echo e($endsAt?->format('M d, Y')); ?>. 
                    <a href="<?php echo e(route('subscription.show')); ?>" class="alert-link">Reactivate subscription</a>
                </p>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/components/subscription-banner.blade.php ENDPATH**/ ?>