<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('full-page', true); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Login specific background image */
    .login-image-section {
        background-image: url('<?php echo e(asset('images/landing/login.jpg')); ?>');
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="login-container">
    <!-- Image Section -->
    <div class="image-section login-image-section">
        <div class="image-content">
            <h1>Welcome to <span class="highlight">Qaya</span><br>HRMS</h1>
            <p>Streamline your human resource management with our comprehensive solution. Track, manage, and optimize your workforce with ease.</p>
            
            <ul class="feature-list">
                <li><i class="bi bi-check-circle-fill"></i> Real-time Employee Tracking</li>
                <li><i class="bi bi-check-circle-fill"></i> Advanced Analytics & Reports</li>
                <li><i class="bi bi-check-circle-fill"></i> Multi-location Management</li>
                <li><i class="bi bi-check-circle-fill"></i> Automated Payroll Processing</li>
            </ul>

            <div class="footer-text">
                &copy; <?php echo e(date('Y')); ?> Qaya HRM. All rights reserved.
            </div>
        </div>
    </div>

    <!-- Form Section -->
    <div class="auth-form-section">
        <div class="auth-form">
            <div class="auth-header">
                <i class="bi bi-building"></i>
                <h2>Qaya HRM</h2>
                <p>Welcome back! Please sign in to your account.</p>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Test Credentials Button -->
            <button type="button" class="btn-auth-secondary mb-3" onclick="fillTestCredentials()">
                <i class="bi bi-person-gear me-2"></i>Use Test Credentials (Admin)
            </button>

            <form method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>

                <div class="mb-3">
                    <label for="email" class="form-label">Email Address</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-envelope"></i>
                        </span>
                        <input type="email"
                               class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               id="email"
                               name="email"
                               value="<?php echo e(old('email')); ?>"
                               placeholder="Enter your email"
                               required
                               autofocus>
                    </div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-lock"></i>
                        </span>
                        <input type="password"
                               class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               id="password"
                               name="password"
                               placeholder="Enter your password"
                               required>
                        <button class="btn btn-outline-secondary" type="button" id="togglePassword" style="border-left: 0;">
                            <i class="bi bi-eye" id="togglePasswordIcon"></i>
                        </button>
                    </div>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-4 d-flex justify-content-between align-items-center">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="remember" name="remember">
                        <label class="form-check-label" for="remember">
                            Remember me
                        </label>
                    </div>
                    <a href="<?php echo e(route('password.request')); ?>" class="auth-link" style="font-size: 0.9rem;">Forgot Password?</a>
                </div>

                <button type="submit" class="btn-auth-primary">
                    <i class="bi bi-box-arrow-in-right me-2"></i>Sign In
                </button>
            </form>

            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Password toggle functionality
    const togglePassword = document.getElementById('togglePassword');
    const passwordField = document.getElementById('password');
    const togglePasswordIcon = document.getElementById('togglePasswordIcon');
    
    togglePassword.addEventListener('click', function() {
        // Toggle the type attribute
        const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', type);
        
        // Toggle the icon
        if (type === 'password') {
            togglePasswordIcon.classList.remove('bi-eye-slash');
            togglePasswordIcon.classList.add('bi-eye');
        } else {
            togglePasswordIcon.classList.remove('bi-eye');
            togglePasswordIcon.classList.add('bi-eye-slash');
        }
    });
    
    function fillTestCredentials() {
        document.getElementById('email').value = 'qayacreatives@gmail.com';
        document.getElementById('password').value = 'password';
        
        // Add a subtle animation to show the fields were filled
        const emailField = document.getElementById('email');
        const passwordField = document.getElementById('password');
        
        emailField.style.transform = 'scale(1.02)';
        passwordField.style.transform = 'scale(1.02)';
        
        setTimeout(() => {
            emailField.style.transform = 'scale(1)';
            passwordField.style.transform = 'scale(1)';
        }, 200);
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/auth/login.blade.php ENDPATH**/ ?>