<?php $__env->startSection('title', 'Subscription Management'); ?>
<?php $__env->startSection('page-title', 'Subscription Management'); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Subscription Management','description' => 'Manage all organization subscriptions']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Subscription Management','description' => 'Manage all organization subscriptions']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

<?php if (isset($component)) { $__componentOriginal5194778a3a7b899dcee5619d0610f5cf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.alert','data' => ['type' => 'success','message' => session('success')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'success','message' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('success'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $attributes = $__attributesOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__attributesOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf)): ?>
<?php $component = $__componentOriginal5194778a3a7b899dcee5619d0610f5cf; ?>
<?php unset($__componentOriginal5194778a3a7b899dcee5619d0610f5cf); ?>
<?php endif; ?>

<!-- Statistics Cards -->
<?php if (isset($component)) { $__componentOriginal14f00bb611be156238920ca6c4a4adca = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal14f00bb611be156238920ca6c4a4adca = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.stats-grid','data' => ['stats' => [
    ['value' => $stats['total'], 'label' => 'Total Subscriptions', 'icon' => 'receipt', 'type' => 'primary'],
    ['value' => $stats['active'], 'label' => 'Active', 'icon' => 'check-circle', 'type' => 'success'],
    ['value' => $stats['trial'], 'label' => 'On Trial', 'icon' => 'clock-history', 'type' => 'info'],
    ['value' => $stats['suspended'], 'label' => 'Suspended', 'icon' => 'pause-circle', 'type' => 'warning'],
]]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('stats-grid'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['stats' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
    ['value' => $stats['total'], 'label' => 'Total Subscriptions', 'icon' => 'receipt', 'type' => 'primary'],
    ['value' => $stats['active'], 'label' => 'Active', 'icon' => 'check-circle', 'type' => 'success'],
    ['value' => $stats['trial'], 'label' => 'On Trial', 'icon' => 'clock-history', 'type' => 'info'],
    ['value' => $stats['suspended'], 'label' => 'Suspended', 'icon' => 'pause-circle', 'type' => 'warning'],
])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal14f00bb611be156238920ca6c4a4adca)): ?>
<?php $attributes = $__attributesOriginal14f00bb611be156238920ca6c4a4adca; ?>
<?php unset($__attributesOriginal14f00bb611be156238920ca6c4a4adca); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal14f00bb611be156238920ca6c4a4adca)): ?>
<?php $component = $__componentOriginal14f00bb611be156238920ca6c4a4adca; ?>
<?php unset($__componentOriginal14f00bb611be156238920ca6c4a4adca); ?>
<?php endif; ?>

<!-- Filters -->
<?php if (isset($component)) { $__componentOriginal934f921620666b609fa7806109faa21b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal934f921620666b609fa7806109faa21b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.filter-form','data' => ['action' => route('systemadmin.subscriptions.index')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('filter-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('systemadmin.subscriptions.index'))]); ?>
    <div class="col-md-3">
        <input type="text" name="search" class="form-control" placeholder="Search organization..." value="<?php echo e(request('search')); ?>">
    </div>
    <div class="col-md-3">
        <select name="status" class="form-select">
            <option value="">All Statuses</option>
            <option value="trial" <?php echo e(request('status') == 'trial' ? 'selected' : ''); ?>>Trial</option>
            <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
            <option value="suspended" <?php echo e(request('status') == 'suspended' ? 'selected' : ''); ?>>Suspended</option>
            <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
        </select>
    </div>
    <div class="col-md-3">
        <select name="plan_id" class="form-select">
            <option value="">All Plans</option>
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($plan->id); ?>" <?php echo e(request('plan_id') == $plan->id ? 'selected' : ''); ?>>
                    <?php echo e($plan->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-md-3">
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-search"></i> Filter
        </button>
        <a href="<?php echo e(route('systemadmin.subscriptions.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-x"></i> Clear
        </a>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal934f921620666b609fa7806109faa21b)): ?>
<?php $attributes = $__attributesOriginal934f921620666b609fa7806109faa21b; ?>
<?php unset($__attributesOriginal934f921620666b609fa7806109faa21b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal934f921620666b609fa7806109faa21b)): ?>
<?php $component = $__componentOriginal934f921620666b609fa7806109faa21b; ?>
<?php unset($__componentOriginal934f921620666b609fa7806109faa21b); ?>
<?php endif; ?>

<!-- Subscriptions Table -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Subscriptions</h5>
    </div>
    <div class="card-body">
        <?php if($subscriptions->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Organization</th>
                            <th>Plan</th>
                            <th>Status</th>
                            <th>Billing Cycle</th>
                            <th>Next Billing</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <strong><?php echo e($subscription->organization->name); ?></strong>
                                <br><small class="text-muted"><?php echo e($subscription->organization->slug); ?></small>
                            </td>
                            <td>
                                <span class="badge bg-primary"><?php echo e($subscription->plan->name); ?></span>
                            </td>
                            <td>
                                <?php
                                    $statusColors = [
                                        'trial' => 'info',
                                        'active' => 'success',
                                        'suspended' => 'warning',
                                        'cancelled' => 'danger',
                                        'expired' => 'secondary'
                                    ];
                                    $color = $statusColors[$subscription->status] ?? 'secondary';
                                ?>
                                <span class="badge bg-<?php echo e($color); ?>"><?php echo e(ucfirst($subscription->status)); ?></span>
                                <?php if($subscription->onTrial()): ?>
                                    <br><small class="text-muted"><?php echo e($subscription->trialDaysRemaining()); ?> days left</small>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(ucfirst($subscription->billing_cycle)); ?></td>
                            <td>
                                <?php if($subscription->next_billing_date): ?>
                                    <?php echo e($subscription->next_billing_date->format('M d, Y')); ?>

                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('systemadmin.subscriptions.show', $subscription)); ?>" 
                                       class="btn btn-sm btn-outline-primary" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('systemadmin.subscriptions.edit', $subscription)); ?>" 
                                       class="btn btn-sm btn-outline-secondary" title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-center mt-3">
                <?php echo e($subscriptions->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-receipt display-4 text-muted"></i>
                <h4 class="mt-3">No Subscriptions Found</h4>
                <p class="text-muted">No subscriptions match your filters.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('systemadmin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/systemadmin/subscriptions/index.blade.php ENDPATH**/ ?>