<?php $__env->startSection('title', $title ?? 'Page Not Found'); ?>
<?php $__env->startSection('code', '404'); ?>

<?php $__env->startSection('content'); ?>
    <div class="error-icon text-warning">
        <i class="bi bi-compass"></i>
    </div>
    
    <p class="error-message">
        <?php echo e($message ?? "Oops! The page you're looking for seems to have wandered off. Don't worry, even the best explorers sometimes take a wrong turn."); ?>

    </p>

    <div class="error-details">
        <h6><i class="bi bi-info-circle me-2"></i>What happened?</h6>
        <p>The URL you entered might be incorrect, or the page may have been moved or deleted. This could also happen if you followed an outdated link.</p>
    </div>

    <div class="error-actions">
        <?php if(auth()->guard()->check()): ?>
            <a href="<?php echo e(route('dashboard')); ?>" class="btn-primary-custom">
                <i class="bi bi-house"></i>
                Go to Dashboard
            </a>
        <?php else: ?>
            <a href="<?php echo e(route('login')); ?>" class="btn-primary-custom">
                <i class="bi bi-box-arrow-in-right"></i>
                Login
            </a>
        <?php endif; ?>
        
        <a href="javascript:history.back()" class="btn-secondary-custom">
            <i class="bi bi-arrow-left"></i>
            Go Back
        </a>
        
        <a href="mailto:support@qayahrms.com" class="btn-success-custom">
            <i class="bi bi-envelope"></i>
            Contact Support
        </a>
    </div>

    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-lightbulb me-1"></i>
            <strong>Tip:</strong> Try checking the URL for typos or use the navigation menu to find what you're looking for.
        </small>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-redirect after 30 seconds if user is authenticated
    <?php if(auth()->guard()->check()): ?>
    setTimeout(function() {
        if (confirm('Would you like to be redirected to the dashboard?')) {
            window.location.href = '<?php echo e(route("dashboard")); ?>';
        }
    }, 30000);
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('errors.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/errors/404.blade.php ENDPATH**/ ?>