<?php $__env->startSection('title', 'My Loans'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">My Loans</h1>
                <a href="<?php echo e(route('loans.request')); ?>" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> Request Loan
                </a>
            </div>

            <!-- Loan Summary Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body text-center">
                            <h4 class="mb-0"><?php echo e($loans->whereIn('status', ['approved', 'disbursed', 'active'])->count()); ?></h4>
                            <small>Active Loans</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body text-center">
                            <h4 class="mb-0"><?php echo e($loans->where('status', 'pending')->count()); ?></h4>
                            <small>Pending Approval</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body text-center">
                            <h4 class="mb-0">KES <?php echo e(number_format($loans->whereIn('status', ['active'])->sum('balance'), 2)); ?></h4>
                            <small>Total Balance</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body text-center">
                            <h4 class="mb-0"><?php echo e($loans->where('status', 'completed')->count()); ?></h4>
                            <small>Completed Loans</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Loans List -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">My Loan History</h5>
                </div>
                <div class="card-body">
                    <?php if($loans->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Loan Number</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Monthly Payment</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><code><?php echo e($loan->loan_number); ?></code></td>
                                        <td><span class="badge bg-info"><?php echo e(ucwords(str_replace('_', ' ', $loan->loan_type))); ?></span></td>
                                        <td>KES <?php echo e(number_format($loan->principal_amount, 2)); ?></td>
                                        <td>KES <?php echo e(number_format($loan->balance, 2)); ?></td>
                                        <td>KES <?php echo e(number_format($loan->monthly_deduction, 2)); ?></td>
                                        <td>
                                            <?php
                                                $statusColors = [
                                                    'pending' => 'warning',
                                                    'approved' => 'info',
                                                    'disbursed' => 'primary',
                                                    'active' => 'success',
                                                    'completed' => 'secondary',
                                                    'defaulted' => 'danger',
                                                    'cancelled' => 'dark'
                                                ];
                                            ?>
                                            <span class="badge bg-<?php echo e($statusColors[$loan->status] ?? 'secondary'); ?>">
                                                <?php echo e(ucfirst($loan->status)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('loans.show', $loan)); ?>" class="btn btn-sm btn-outline-primary">
                                                <i class="bi bi-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="bi bi-inbox" style="font-size: 3rem; color: #ccc;"></i>
                            <p class="text-muted mt-3">You don't have any loans yet</p>
                            <a href="<?php echo e(route('loans.request')); ?>" class="btn btn-primary">
                                <i class="bi bi-plus-circle"></i> Request Your First Loan
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Loan Policy Info -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">Loan Policy Information</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="bi bi-check-circle text-success"></i> Maximum Loan: KES <?php echo e(number_format($loanSettings->max_loan_amount, 2)); ?></li>
                                <li><i class="bi bi-check-circle text-success"></i> Maximum Term: <?php echo e($loanSettings->max_loan_term_months); ?> months</li>
                                <li><i class="bi bi-check-circle text-success"></i> Maximum Outstanding Loans: <?php echo e($loanSettings->max_outstanding_loans); ?></li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <ul class="list-unstyled">
                                <li><i class="bi bi-check-circle text-success"></i> Loan-to-Salary Ratio: <?php echo e($loanSettings->loan_to_salary_ratio); ?>x monthly salary</li>
                                <li><i class="bi bi-check-circle text-success"></i> Minimum Tenure: <?php echo e($loanSettings->min_employment_tenure_months); ?> months</li>
                                <li><i class="bi bi-check-circle text-success"></i> Early Repayment: <?php echo e($loanSettings->allow_early_repayment ? 'Allowed' : 'Not Allowed'); ?></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/loans/my-loans.blade.php ENDPATH**/ ?>