<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Customize Colors</h5>
        <p class="text-muted mb-0 small">Override individual colors (leave empty to use base theme colors)</p>
    </div>
    <div class="card-body">
        <div class="row">
            <!-- Primary Color -->
            <div class="col-md-4 mb-3">
                <label class="form-label">Primary Color</label>
                <div class="color-input-group">
                    <input type="color" 
                           value="<?php echo e($themeSetting?->primary_color ?? '#030213'); ?>" 
                           class="form-control-color">
                    <input type="text" 
                           class="form-control" 
                           name="primary_color"
                           value="<?php echo e($themeSetting?->primary_color ?? ''); ?>" 
                           placeholder="#030213"
                           pattern="^#[0-9A-Fa-f]{6}$">
                    <button class="btn btn-outline-secondary reset-color" type="button" title="Reset to base theme">
                        <i class="bi bi-arrow-counterclockwise"></i>
                    </button>
                </div>
            </div>
            
            <!-- Secondary Color -->
            <div class="col-md-4 mb-3">
                <label class="form-label">Secondary Color</label>
                <div class="color-input-group">
                    <input type="color" 
                           value="<?php echo e($themeSetting?->secondary_color ?? '#FF6B35'); ?>" 
                           class="form-control-color">
                    <input type="text" 
                           class="form-control" 
                           name="secondary_color"
                           value="<?php echo e($themeSetting?->secondary_color ?? ''); ?>" 
                           placeholder="#FF6B35"
                           pattern="^#[0-9A-Fa-f]{6}$">
                    <button class="btn btn-outline-secondary reset-color" type="button" title="Reset to base theme">
                        <i class="bi bi-arrow-counterclockwise"></i>
                    </button>
                </div>
            </div>
            
            <!-- Accent Color -->
            <div class="col-md-4 mb-3">
                <label class="form-label">Accent Color</label>
                <div class="color-input-group">
                    <input type="color" 
                           value="<?php echo e($themeSetting?->accent_color ?? '#00a09d'); ?>" 
                           class="form-control-color">
                    <input type="text" 
                           class="form-control" 
                           name="accent_color"
                           value="<?php echo e($themeSetting?->accent_color ?? ''); ?>" 
                           placeholder="#00a09d"
                           pattern="^#[0-9A-Fa-f]{6}$">
                    <button class="btn btn-outline-secondary reset-color" type="button" title="Reset to base theme">
                        <i class="bi bi-arrow-counterclockwise"></i>
                    </button>
                </div>
            </div>
            
            <!-- Success Color -->
            <div class="col-md-4 mb-3">
                <label class="form-label">Success Color</label>
                <div class="color-input-group">
                    <input type="color" 
                           value="<?php echo e($themeSetting?->success_color ?? '#28a745'); ?>" 
                           class="form-control-color">
                    <input type="text" 
                           class="form-control" 
                           name="success_color"
                           value="<?php echo e($themeSetting?->success_color ?? ''); ?>" 
                           placeholder="#28a745"
                           pattern="^#[0-9A-Fa-f]{6}$">
                    <button class="btn btn-outline-secondary reset-color" type="button" title="Reset to base theme">
                        <i class="bi bi-arrow-counterclockwise"></i>
                    </button>
                </div>
            </div>
            
            <!-- Warning Color -->
            <div class="col-md-4 mb-3">
                <label class="form-label">Warning Color</label>
                <div class="color-input-group">
                    <input type="color" 
                           value="<?php echo e($themeSetting?->warning_color ?? '#ffc107'); ?>" 
                           class="form-control-color">
                    <input type="text" 
                           class="form-control" 
                           name="warning_color"
                           value="<?php echo e($themeSetting?->warning_color ?? ''); ?>" 
                           placeholder="#ffc107"
                           pattern="^#[0-9A-Fa-f]{6}$">
                    <button class="btn btn-outline-secondary reset-color" type="button" title="Reset to base theme">
                        <i class="bi bi-arrow-counterclockwise"></i>
                    </button>
                </div>
            </div>
            
            <!-- Danger Color -->
            <div class="col-md-4 mb-3">
                <label class="form-label">Danger Color</label>
                <div class="color-input-group">
                    <input type="color" 
                           value="<?php echo e($themeSetting?->danger_color ?? '#dc3545'); ?>" 
                           class="form-control-color">
                    <input type="text" 
                           class="form-control" 
                           name="danger_color"
                           value="<?php echo e($themeSetting?->danger_color ?? ''); ?>" 
                           placeholder="#dc3545"
                           pattern="^#[0-9A-Fa-f]{6}$">
                    <button class="btn btn-outline-secondary reset-color" type="button" title="Reset to base theme">
                        <i class="bi bi-arrow-counterclockwise"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <div class="alert alert-info mt-3">
            <i class="bi bi-info-circle"></i>
            <strong>Tip:</strong> Leave fields empty to use the base theme's default colors. 
            Click the reset button to clear a color override.
        </div>
    </div>
</div>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/settings/theme/partials/color-picker.blade.php ENDPATH**/ ?>