<?php $__env->startSection('title', 'Learning Paths'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Learning Paths</h1>
                <div class="btn-group">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\LearningPath::class)): ?>
                        <a href="<?php echo e(route('training.learning-paths.create')); ?>" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Create Learning Path
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('training.learning-paths.my-paths')); ?>" class="btn btn-outline-primary">
                        <i class="bi bi-person"></i> My Learning Paths
                    </a>
                </div>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('training.learning-paths.index')); ?>">
                        <div class="row">
                            <div class="col-md-3">
                                <input type="text" name="search" class="form-control" placeholder="Search learning paths..." value="<?php echo e(request('search')); ?>">
                            </div>
                            <div class="col-md-3">
                                <select name="difficulty" class="form-select">
                                    <option value="">All Difficulty Levels</option>
                                    <option value="beginner" <?php echo e(request('difficulty') == 'beginner' ? 'selected' : ''); ?>>Beginner</option>
                                    <option value="intermediate" <?php echo e(request('difficulty') == 'intermediate' ? 'selected' : ''); ?>>Intermediate</option>
                                    <option value="advanced" <?php echo e(request('difficulty') == 'advanced' ? 'selected' : ''); ?>>Advanced</option>
                                </select>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_inactive_learning_paths')): ?>
                                <div class="col-md-3">
                                    <select name="status" class="form-select">
                                        <option value="">Active Only</option>
                                        <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                                        <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                    </select>
                                </div>
                            <?php endif; ?>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="bi bi-search"></i> Search
                                </button>
                                <a href="<?php echo e(route('training.learning-paths.index')); ?>" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Learning Paths Grid -->
            <?php if($learningPaths->count() > 0): ?>
                <div class="row">
                    <?php $__currentLoopData = $learningPaths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4 mb-4">
                            <div class="card h-100">
                                <?php if($path->image_path): ?>
                                    <img src="<?php echo e(asset('storage/' . $path->image_path)); ?>" class="card-img-top" alt="<?php echo e($path->title); ?>" style="height: 200px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                                        <i class="bi bi-map fs-1 text-muted"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="card-body d-flex flex-column">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h5 class="card-title"><?php echo e($path->title); ?></h5>
                                        <span class="badge bg-<?php echo e($path->difficulty_color); ?>"><?php echo e(ucfirst($path->difficulty_level)); ?></span>
                                    </div>
                                    
                                    <p class="card-text text-muted small flex-grow-1"><?php echo e(Str::limit($path->description, 100)); ?></p>
                                    
                                    <div class="mb-3">
                                        <div class="row text-center">
                                            <div class="col-4">
                                                <small class="text-muted">Steps</small><br>
                                                <strong><?php echo e($path->total_steps); ?></strong>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Duration</small><br>
                                                <strong><?php echo e($path->estimated_duration_hours); ?>h</strong>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Completion</small><br>
                                                <strong><?php echo e($path->completion_rate); ?>%</strong>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if($path->learning_outcomes): ?>
                                        <div class="mb-3">
                                            <small class="text-muted">Learning Outcomes:</small>
                                            <ul class="small mb-0">
                                                <?php $__currentLoopData = array_slice($path->learning_outcomes, 0, 2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outcome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($outcome); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(count($path->learning_outcomes) > 2): ?>
                                                    <li class="text-muted">+<?php echo e(count($path->learning_outcomes) - 2); ?> more...</li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="mt-auto">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="btn-group btn-group-sm">
                                                <a href="<?php echo e(route('training.learning-paths.show', $path)); ?>" class="btn btn-outline-primary">
                                                    <i class="bi bi-eye"></i> View
                                                </a>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $path)): ?>
                                                    <a href="<?php echo e(route('training.learning-paths.edit', $path)); ?>" class="btn btn-outline-secondary">
                                                        <i class="bi bi-pencil"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <?php if(in_array($path->id, $userEnrollments)): ?>
                                                <span class="badge bg-success">
                                                    <i class="bi bi-check-circle"></i> Enrolled
                                                </span>
                                            <?php else: ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('enroll', $path)): ?>
                                                    <form method="POST" action="<?php echo e(route('training.learning-paths.enroll', $path)); ?>" class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="btn btn-sm btn-primary">
                                                            <i class="bi bi-plus-circle"></i> Enroll
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    <?php echo e($learningPaths->appends(request()->query())->links()); ?>

                </div>
            <?php else: ?>
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-map fs-1 text-muted"></i>
                        <h4 class="mt-3">No Learning Paths Found</h4>
                        <p class="text-muted">No learning paths match your current search criteria.</p>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\LearningPath::class)): ?>
                            <a href="<?php echo e(route('training.learning-paths.create')); ?>" class="btn btn-primary">
                                <i class="bi bi-plus"></i> Create First Learning Path
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/learning-paths/index.blade.php ENDPATH**/ ?>