<?php $__env->startSection('title', $title ?? 'Service Unavailable'); ?>
<?php $__env->startSection('code', '503'); ?>

<?php $__env->startSection('content'); ?>
    <div class="error-icon text-info">
        <i class="bi bi-wrench-adjustable"></i>
    </div>
    
    <p class="error-message">
        <?php echo e($message ?? "We're currently performing scheduled maintenance to improve your experience. The system will be back online shortly."); ?>

    </p>

    <div class="error-details">
        <h6><i class="bi bi-gear me-2"></i>Maintenance in Progress</h6>
        <p>Our team is working hard to enhance the system. This temporary downtime allows us to implement important updates and improvements.</p>
    </div>

    <div class="error-actions">
        <a href="javascript:location.reload()" class="btn-primary-custom">
            <i class="bi bi-arrow-clockwise"></i>
            Check Again
        </a>
        
        <a href="mailto:support@qayahrms.com" class="btn-success-custom">
            <i class="bi bi-envelope"></i>
            Contact Support
        </a>
    </div>

    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-clock me-1"></i>
            <strong>Estimated Duration:</strong> Usually 15-30 minutes
            <br>
            <i class="bi bi-calendar me-1"></i>
            <strong>Started:</strong> <?php echo e(now()->format('M d, Y \a\t g:i A')); ?>

        </small>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto-refresh every 2 minutes
    setInterval(function() {
        location.reload();
    }, 120000);
    
    // Show a notification every 30 seconds
    setInterval(function() {
        console.log('Checking if service is back online...');
    }, 30000);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('errors.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/errors/503.blade.php ENDPATH**/ ?>