<?php $__env->startSection('title', 'Email Settings'); ?>
<?php $__env->startSection('page-title', 'Email Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="table-card">
                <div class="card-body">
                    
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <div class="mb-4">
                        <h3 class="h5 mb-2">Organization Email Configuration</h3>
                        <p class="text-muted">
                            Configure custom email settings for your organization. When enabled, all recruitment emails will be sent from your organization's email address.
                        </p>
                    </div>

                    <form method="POST" action="<?php echo e(route('settings.email.update')); ?>" id="emailSettingsForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <!-- Use Custom Mail Toggle -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input type="checkbox" name="use_custom_mail" value="1" 
                                    <?php echo e(old('use_custom_mail', $organization->use_custom_mail) ? 'checked' : ''); ?>

                                    class="form-check-input"
                                    id="use_custom_mail"
                                    onchange="toggleCustomMailFields(this.checked)">
                                <label class="form-check-label" for="use_custom_mail">
                                    Use custom email configuration
                                </label>
                            </div>
                            <small class="text-muted">If disabled, system default email settings will be used</small>
                        </div>

                        <div id="customMailFields" style="display: <?php echo e(old('use_custom_mail', $organization->use_custom_mail) ? 'block' : 'none'); ?>;">
                            <!-- Mail Driver -->
                            <div class="mb-3">
                                <label for="mail_driver" class="form-label">Mail Driver</label>
                                <select name="mail_driver" id="mail_driver" class="form-select">
                                    <option value="smtp" <?php echo e(old('mail_driver', $organization->mail_driver) == 'smtp' ? 'selected' : ''); ?>>SMTP</option>
                                    <option value="sendmail" <?php echo e(old('mail_driver', $organization->mail_driver) == 'sendmail' ? 'selected' : ''); ?>>Sendmail</option>
                                    <option value="mailgun" <?php echo e(old('mail_driver', $organization->mail_driver) == 'mailgun' ? 'selected' : ''); ?>>Mailgun</option>
                                    <option value="ses" <?php echo e(old('mail_driver', $organization->mail_driver) == 'ses' ? 'selected' : ''); ?>>Amazon SES</option>
                                    <option value="postmark" <?php echo e(old('mail_driver', $organization->mail_driver) == 'postmark' ? 'selected' : ''); ?>>Postmark</option>
                                </select>
                                <?php $__errorArgs = ['mail_driver'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Mail Host -->
                            <div class="mb-3">
                                <label for="mail_host" class="form-label">Mail Host *</label>
                                <input type="text" name="mail_host" id="mail_host" 
                                    value="<?php echo e(old('mail_host', $organization->mail_host)); ?>"
                                    placeholder="smtp.gmail.com"
                                    class="form-control">
                                <?php $__errorArgs = ['mail_host'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Mail Port -->
                            <div class="mb-3">
                                <label for="mail_port" class="form-label">Mail Port *</label>
                                <input type="number" name="mail_port" id="mail_port" 
                                    value="<?php echo e(old('mail_port', $organization->mail_port ?? 587)); ?>"
                                    placeholder="587"
                                    class="form-control">
                                <small class="text-muted">Common ports: 587 (TLS), 465 (SSL), 25 (unencrypted)</small>
                                <?php $__errorArgs = ['mail_port'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Mail Encryption -->
                            <div class="mb-3">
                                <label for="mail_encryption" class="form-label">Encryption *</label>
                                <select name="mail_encryption" id="mail_encryption" class="form-select">
                                    <option value="tls" <?php echo e(old('mail_encryption', $organization->mail_encryption) == 'tls' ? 'selected' : ''); ?>>TLS</option>
                                    <option value="ssl" <?php echo e(old('mail_encryption', $organization->mail_encryption) == 'ssl' ? 'selected' : ''); ?>>SSL</option>
                                    <option value="none" <?php echo e(old('mail_encryption', $organization->mail_encryption) == 'none' ? 'selected' : ''); ?>>None</option>
                                </select>
                                <?php $__errorArgs = ['mail_encryption'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Mail Username -->
                            <div class="mb-3">
                                <label for="mail_username" class="form-label">Username</label>
                                <input type="text" name="mail_username" id="mail_username" 
                                    value="<?php echo e(old('mail_username', $organization->mail_username)); ?>"
                                    placeholder="your-email@example.com"
                                    class="form-control">
                                <?php $__errorArgs = ['mail_username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Mail Password -->
                            <div class="mb-3">
                                <label for="mail_password" class="form-label">Password</label>
                                <input type="password" name="mail_password" id="mail_password" 
                                    placeholder="<?php echo e($organization->mail_password ? '••••••••' : 'Enter password'); ?>"
                                    class="form-control">
                                <small class="text-muted">Leave blank to keep existing password</small>
                                <?php $__errorArgs = ['mail_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- From Address -->
                            <div class="mb-3">
                                <label for="mail_from_address" class="form-label">From Email Address *</label>
                                <input type="email" name="mail_from_address" id="mail_from_address" 
                                    value="<?php echo e(old('mail_from_address', $organization->mail_from_address)); ?>"
                                    placeholder="noreply@yourcompany.com"
                                    class="form-control">
                                <small class="text-muted">This email will appear as the sender in all recruitment emails</small>
                                <?php $__errorArgs = ['mail_from_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- From Name -->
                            <div class="mb-3">
                                <label for="mail_from_name" class="form-label">From Name *</label>
                                <input type="text" name="mail_from_name" id="mail_from_name" 
                                    value="<?php echo e(old('mail_from_name', $organization->mail_from_name ?? $organization->name)); ?>"
                                    placeholder="<?php echo e($organization->name); ?>"
                                    class="form-control">
                                <?php $__errorArgs = ['mail_from_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Test Email Section -->
                            <div class="mb-4 p-3 bg-light border rounded">
                                <h6 class="mb-2">Test Email Configuration</h6>
                                <p class="small text-muted mb-3">Send a test email to verify your configuration before saving</p>
                                <div class="input-group">
                                    <input type="email" id="test_email" 
                                        placeholder="test@example.com"
                                        class="form-control">
                                    <button type="button" onclick="sendTestEmail()" class="btn btn-primary">
                                        Send Test
                                    </button>
                                </div>
                                <div id="testEmailResult" class="mt-2 small"></div>
                            </div>

                        </div>

                        <!-- Submit Button -->
                        <div class="d-flex justify-content-end mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save me-1"></i> Save Email Settings
                            </button>
                        </div>
                    </form>

                </div>
            </div>

            <!-- Email Configuration Guide -->
            <div class="table-card mt-4">
                <div class="card-body">
                    <h5 class="mb-3">Common Email Provider Settings</h5>
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="border-start border-primary border-4 ps-3">
                                <h6 class="mb-1">Gmail</h6>
                                <p class="small mb-1">Host: smtp.gmail.com | Port: 587 | Encryption: TLS</p>
                                <p class="small text-muted mb-0">Note: You need to use an App Password, not your regular Gmail password</p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="border-start border-success border-4 ps-3">
                                <h6 class="mb-1">Microsoft 365 / Outlook</h6>
                                <p class="small mb-0">Host: smtp.office365.com | Port: 587 | Encryption: TLS</p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="border-start border-info border-4 ps-3">
                                <h6 class="mb-1">SendGrid</h6>
                                <p class="small mb-1">Host: smtp.sendgrid.net | Port: 587 | Encryption: TLS</p>
                                <p class="small text-muted mb-0">Username: apikey | Password: Your SendGrid API Key</p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="border-start border-danger border-4 ps-3">
                                <h6 class="mb-1">Mailgun</h6>
                                <p class="small mb-0">Host: smtp.mailgun.org | Port: 587 | Encryption: TLS</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
        function toggleCustomMailFields(enabled) {
            document.getElementById('customMailFields').style.display = enabled ? 'block' : 'none';
        }

        function sendTestEmail() {
            const testEmail = document.getElementById('test_email').value;
            const resultDiv = document.getElementById('testEmailResult');
            
            if (!testEmail) {
                resultDiv.innerHTML = '<span class="text-danger">Please enter an email address</span>';
                return;
            }

            resultDiv.innerHTML = '<span class="text-primary">Sending test email...</span>';

            // Get all form fields
            const formData = new FormData();
            formData.append('test_email', testEmail);
            formData.append('use_custom_mail', document.querySelector('[name="use_custom_mail"]').checked ? '1' : '0');
            formData.append('mail_driver', document.querySelector('[name="mail_driver"]').value);
            formData.append('mail_host', document.querySelector('[name="mail_host"]').value);
            formData.append('mail_port', document.querySelector('[name="mail_port"]').value);
            formData.append('mail_username', document.querySelector('[name="mail_username"]').value);
            formData.append('mail_encryption', document.querySelector('[name="mail_encryption"]').value);
            formData.append('mail_from_address', document.querySelector('[name="mail_from_address"]').value);
            formData.append('mail_from_name', document.querySelector('[name="mail_from_name"]').value);
            
            // Only add password if it's filled
            const password = document.querySelector('[name="mail_password"]').value;
            if (password) {
                formData.append('mail_password', password);
            }

            fetch('<?php echo e(route('settings.email.test')); ?>', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json',
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    resultDiv.innerHTML = '<span class="text-success">✓ ' + data.message + '</span>';
                } else {
                    resultDiv.innerHTML = '<span class="text-danger">✗ ' + data.message + '</span>';
                }
            })
            .catch(error => {
                console.error('Error:', error);
                resultDiv.innerHTML = '<span class="text-danger">✗ Error sending test email. Check console for details.</span>';
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/settings/email-setup.blade.php ENDPATH**/ ?>