<?php $__env->startSection('title', 'Edit Payroll Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Edit Payroll Settings</h3>
                    <div>
                        <a href="<?php echo e(route('payroll.settings.index')); ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Back
                        </a>
                        <form action="<?php echo e(route('payroll.settings.reset')); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-warning" onclick="return confirm('Are you sure you want to reset all settings to defaults?')">
                                <i class="bi bi-undo"></i> Reset to Defaults
                            </button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('payroll.settings.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <div class="row">
                            <!-- PAYE Settings -->
                            <div class="col-md-6">
                                <h5 class="text-primary mb-3">PAYE Tax Settings</h5>
                                
                                <div class="mb-3">
                                    <label for="personal_relief" class="form-label">Personal Relief (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['personal_relief'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="personal_relief" name="personal_relief" 
                                           value="<?php echo e(old('personal_relief', $settings->personal_relief)); ?>" 
                                           step="0.01" min="0">
                                    <?php $__errorArgs = ['personal_relief'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="insurance_relief_rate" class="form-label">Insurance Relief Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['insurance_relief_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="insurance_relief_rate" name="insurance_relief_rate" 
                                           value="<?php echo e(old('insurance_relief_rate', $settings->insurance_relief_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['insurance_relief_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="insurance_relief_max" class="form-label">Insurance Relief Max (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['insurance_relief_max'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="insurance_relief_max" name="insurance_relief_max" 
                                           value="<?php echo e(old('insurance_relief_max', $settings->insurance_relief_max)); ?>" 
                                           step="0.01" min="0">
                                    <?php $__errorArgs = ['insurance_relief_max'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="pension_relief_rate" class="form-label">Pension Relief Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['pension_relief_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="pension_relief_rate" name="pension_relief_rate" 
                                           value="<?php echo e(old('pension_relief_rate', $settings->pension_relief_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['pension_relief_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="pension_relief_max" class="form-label">Pension Relief Max (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['pension_relief_max'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="pension_relief_max" name="pension_relief_max" 
                                           value="<?php echo e(old('pension_relief_max', $settings->pension_relief_max)); ?>" 
                                           step="0.01" min="0">
                                    <?php $__errorArgs = ['pension_relief_max'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- Statutory Deductions -->
                            <div class="col-md-6">
                                <h5 class="text-success mb-3">Statutory Deductions</h5>
                                
                                <h6 class="text-secondary">SHIF Settings</h6>
                                <div class="mb-3">
                                    <label for="shif_rate" class="form-label">SHIF Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['shif_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="shif_rate" name="shif_rate" 
                                           value="<?php echo e(old('shif_rate', $settings->shif_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['shif_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="shif_min_contribution" class="form-label">SHIF Min Contribution (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['shif_min_contribution'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="shif_min_contribution" name="shif_min_contribution" 
                                           value="<?php echo e(old('shif_min_contribution', $settings->shif_min_contribution)); ?>" 
                                           step="0.01" min="0">
                                    <?php $__errorArgs = ['shif_min_contribution'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <h6 class="text-secondary mt-4">NSSF Settings</h6>
                                <div class="mb-3">
                                    <label for="nssf_employee_rate" class="form-label">NSSF Employee Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['nssf_employee_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="nssf_employee_rate" name="nssf_employee_rate" 
                                           value="<?php echo e(old('nssf_employee_rate', $settings->nssf_employee_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['nssf_employee_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="nssf_employer_rate" class="form-label">NSSF Employer Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['nssf_employer_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="nssf_employer_rate" name="nssf_employer_rate" 
                                           value="<?php echo e(old('nssf_employer_rate', $settings->nssf_employer_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['nssf_employer_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="nssf_lower_limit" class="form-label">NSSF Lower Limit (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['nssf_lower_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="nssf_lower_limit" name="nssf_lower_limit" 
                                           value="<?php echo e(old('nssf_lower_limit', $settings->nssf_lower_limit)); ?>" 
                                           step="0.01" min="0">
                                    <?php $__errorArgs = ['nssf_lower_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="nssf_upper_limit" class="form-label">NSSF Upper Limit (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['nssf_upper_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="nssf_upper_limit" name="nssf_upper_limit" 
                                           value="<?php echo e(old('nssf_upper_limit', $settings->nssf_upper_limit)); ?>" 
                                           step="0.01" min="0">
                                    <?php $__errorArgs = ['nssf_upper_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <!-- Housing Levy -->
                            <div class="col-md-6">
                                <h6 class="text-secondary">Housing Levy Settings</h6>
                                <div class="mb-3">
                                    <label for="housing_levy_employee_rate" class="form-label">Employee Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['housing_levy_employee_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="housing_levy_employee_rate" name="housing_levy_employee_rate" 
                                           value="<?php echo e(old('housing_levy_employee_rate', $settings->housing_levy_employee_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['housing_levy_employee_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="housing_levy_employer_rate" class="form-label">Employer Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['housing_levy_employer_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="housing_levy_employer_rate" name="housing_levy_employer_rate" 
                                           value="<?php echo e(old('housing_levy_employer_rate', $settings->housing_levy_employer_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['housing_levy_employer_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- Default Allowances -->
                            <div class="col-md-6">
                                <h6 class="text-warning">Default Allowances</h6>
                                <div class="mb-3">
                                    <label for="default_house_allowance_rate" class="form-label">House Allowance Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['default_house_allowance_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="default_house_allowance_rate" name="default_house_allowance_rate" 
                                           value="<?php echo e(old('default_house_allowance_rate', $settings->default_house_allowance_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['default_house_allowance_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="default_transport_allowance_rate" class="form-label">Transport Allowance Rate (%)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['default_transport_allowance_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="default_transport_allowance_rate" name="default_transport_allowance_rate" 
                                           value="<?php echo e(old('default_transport_allowance_rate', $settings->default_transport_allowance_rate * 100)); ?>" 
                                           step="0.01" min="0" max="100">
                                    <?php $__errorArgs = ['default_transport_allowance_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="max_transport_allowance" class="form-label">Max Transport Allowance (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['max_transport_allowance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="max_transport_allowance" name="max_transport_allowance" 
                                           value="<?php echo e(old('max_transport_allowance', $settings->max_transport_allowance)); ?>" 
                                           step="0.01" min="0">
                                    <?php $__errorArgs = ['max_transport_allowance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="default_medical_allowance" class="form-label">Default Medical Allowance (KES)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['default_medical_allowance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="default_medical_allowance" name="default_medical_allowance" 
                                           value="<?php echo e(old('default_medical_allowance', $settings->default_medical_allowance)); ?>" 
                                           step="0.01" min="0">
                                    <?php $__errorArgs = ['default_medical_allowance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <!-- Working Days -->
                            <div class="col-md-6">
                                <h6 class="text-info">Working Days Configuration</h6>
                                <div class="mb-3">
                                    <label for="default_monthly_working_days" class="form-label">Monthly Working Days</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['default_monthly_working_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="default_monthly_working_days" name="default_monthly_working_days" 
                                           value="<?php echo e(old('default_monthly_working_days', $settings->default_monthly_working_days)); ?>" 
                                           min="1" max="31">
                                    <?php $__errorArgs = ['default_monthly_working_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="default_weekly_working_days" class="form-label">Weekly Working Days</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['default_weekly_working_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="default_weekly_working_days" name="default_weekly_working_days" 
                                           value="<?php echo e(old('default_weekly_working_days', $settings->default_weekly_working_days)); ?>" 
                                           min="1" max="7">
                                    <?php $__errorArgs = ['default_weekly_working_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="default_hours_per_day" class="form-label">Hours Per Day</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['default_hours_per_day'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="default_hours_per_day" name="default_hours_per_day" 
                                           value="<?php echo e(old('default_hours_per_day', $settings->default_hours_per_day)); ?>" 
                                           min="1" max="24">
                                    <?php $__errorArgs = ['default_hours_per_day'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- Compliance Deadlines -->
                            <div class="col-md-6">
                                <h6 class="text-secondary">Compliance Deadlines</h6>
                                <div class="mb-3">
                                    <label for="kra_submission_deadline" class="form-label">KRA Submission Deadline (Day of Month)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['kra_submission_deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="kra_submission_deadline" name="kra_submission_deadline" 
                                           value="<?php echo e(old('kra_submission_deadline', $settings->kra_submission_deadline)); ?>" 
                                           min="1" max="31">
                                    <?php $__errorArgs = ['kra_submission_deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="shif_submission_deadline" class="form-label">SHIF Submission Deadline (Day of Month)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['shif_submission_deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="shif_submission_deadline" name="shif_submission_deadline" 
                                           value="<?php echo e(old('shif_submission_deadline', $settings->shif_submission_deadline)); ?>" 
                                           min="1" max="31">
                                    <?php $__errorArgs = ['shif_submission_deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="nssf_submission_deadline" class="form-label">NSSF Submission Deadline (Day of Month)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['nssf_submission_deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="nssf_submission_deadline" name="nssf_submission_deadline" 
                                           value="<?php echo e(old('nssf_submission_deadline', $settings->nssf_submission_deadline)); ?>" 
                                           min="1" max="31">
                                    <?php $__errorArgs = ['nssf_submission_deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="housing_levy_submission_deadline" class="form-label">Housing Levy Submission Deadline (Day of Month)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['housing_levy_submission_deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="housing_levy_submission_deadline" name="housing_levy_submission_deadline" 
                                           value="<?php echo e(old('housing_levy_submission_deadline', $settings->housing_levy_submission_deadline)); ?>" 
                                           min="1" max="31">
                                    <?php $__errorArgs = ['housing_levy_submission_deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-end">
                                    <a href="<?php echo e(route('payroll.settings.index')); ?>" class="btn btn-secondary me-2">Cancel</a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save"></i> Save Settings
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/payroll/settings/edit.blade.php ENDPATH**/ ?>