<?php $__env->startSection('title', 'Training Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Dashboard</h1>
                <div>
                    <a href="<?php echo e(route('training.programs.create')); ?>" class="btn btn-primary me-2">
                        <i class="bi bi-plus"></i> New Program
                    </a>
                    <a href="<?php echo e(route('training.sessions.create')); ?>" class="btn btn-outline-primary">
                        <i class="bi bi-calendar-plus"></i> Schedule Session
                    </a>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['total_programs']); ?></h4>
                                    <p class="mb-0">Active Programs</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-book fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['active_sessions']); ?></h4>
                                    <p class="mb-0">Active Sessions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-calendar-alt fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['total_enrollments']); ?></h4>
                                    <p class="mb-0">Total Enrollments</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-users fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0"><?php echo e($stats['completion_rate']); ?>%</h4>
                                    <p class="mb-0">Completion Rate</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-chart-line fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Upcoming Sessions -->
                <div class="col-lg-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">Upcoming Sessions</h5>
                        </div>
                        <div class="card-body">
                            <?php if($upcomingSessions->count() > 0): ?>
                                <?php $__currentLoopData = $upcomingSessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d-flex justify-content-between align-items-center border-bottom pb-2 mb-2">
                                        <div>
                                            <strong><?php echo e($session->program->title); ?></strong><br>
                                            <small class="text-muted">
                                                <?php echo e($session->start_datetime->format('M j, Y g:i A')); ?>

                                                <?php if($session->instructor): ?>
                                                    | <?php echo e($session->instructor->name); ?>

                                                <?php endif; ?>
                                            </small>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge badge-primary"><?php echo e($session->enrollments->count()); ?> enrolled</span>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="text-center mt-3">
                                    <a href="<?php echo e(route('training.sessions.index')); ?>" class="btn btn-sm btn-outline-primary">View All Sessions</a>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-3">
                                    <i class="bi bi-calendar-times fa-2x text-muted mb-2"></i>
                                    <p class="text-muted">No upcoming sessions</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Popular Programs -->
                <div class="col-lg-6">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">Popular Programs</h5>
                        </div>
                        <div class="card-body">
                            <?php if($popularPrograms->count() > 0): ?>
                                <?php $__currentLoopData = $popularPrograms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d-flex justify-content-between align-items-center border-bottom pb-2 mb-2">
                                        <div>
                                            <strong><?php echo e($program->title); ?></strong><br>
                                            <small class="text-muted"><?php echo e($program->category->name); ?></small>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge badge-success"><?php echo e($program->enrollments_count); ?> enrollments</span>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="text-center mt-3">
                                    <a href="<?php echo e(route('training.programs.index')); ?>" class="btn btn-sm btn-outline-primary">View All Programs</a>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-3">
                                    <i class="bi bi-book fa-2x text-muted mb-2"></i>
                                    <p class="text-muted">No programs available</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activities -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Recent Enrollments</h5>
                </div>
                <div class="card-body">
                    <?php if($recentEnrollments->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Employee</th>
                                        <th>Program</th>
                                        <th>Session</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $recentEnrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($enrollment->employee->full_name); ?></td>
                                            <td><?php echo e($enrollment->session->program->title); ?></td>
                                            <td><?php echo e($enrollment->session->session_code); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo e($enrollment->status_color); ?>">
                                                    <?php echo e(ucfirst($enrollment->status)); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($enrollment->enrolled_at->format('M j, Y')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-3">
                            <i class="bi bi-user-plus fa-2x text-muted mb-2"></i>
                            <p class="text-muted">No recent enrollments</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/dashboard.blade.php ENDPATH**/ ?>