<?php $__env->startSection('title', 'Setup Complete'); ?>

<?php $__env->startSection('content'); ?>
<div class="step-indicator">
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Welcome</div>
    </div>
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Select Plan</div>
    </div>
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Payment</div>
    </div>
    <div class="step active">
        <div class="step-circle">4</div>
        <div class="step-label">Complete</div>
    </div>
</div>

<div class="text-center mb-4">
    <i class="bi bi-check-circle text-success" style="font-size: 5rem;"></i>
    <h3 class="mt-3">You're All Set!</h3>
    <p class="text-muted">Your organization is ready to use Qaya HRM</p>
</div>

<div class="card mb-4">
    <div class="card-body">
        <h5><i class="bi bi-star"></i> Your Subscription</h5>
        <div class="row mt-3">
            <div class="col-md-6">
                <p><strong>Plan:</strong> <?php echo e($subscription->plan->name); ?></p>
                <p><strong>Status:</strong> 
                    <?php if($subscription->status === 'trial'): ?>
                        <span class="badge bg-info">Trial (<?php echo e($subscription->trialDaysRemaining()); ?> days left)</span>
                    <?php else: ?>
                        <span class="badge bg-success">Active</span>
                    <?php endif; ?>
                </p>
            </div>
            <div class="col-md-6">
                <p><strong>Billing Cycle:</strong> <?php echo e(ucfirst($subscription->billing_cycle)); ?></p>
                <?php if($subscription->current_period_ends_at): ?>
                <p><strong>Next Billing:</strong> <?php echo e($subscription->current_period_ends_at->format('M d, Y')); ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header">
        <h6 class="mb-0"><i class="bi bi-rocket"></i> Quick Start Guide</h6>
    </div>
    <div class="card-body">
        <h6>Get started with these steps:</h6>
        <ol>
            <li><strong>Add Employees</strong> - Start by adding your team members</li>
            <li><strong>Set Up Departments</strong> - Organize your workforce</li>
            <li><strong>Configure Settings</strong> - Customize the system to your needs</li>
            <li><strong>Invite Users</strong> - Give your team access to the system</li>
        </ol>
    </div>
</div>

<div class="card mb-4 border-info">
    <div class="card-body">
        <h6><i class="bi bi-lightbulb"></i> Pro Tips</h6>
        <ul class="mb-0">
            <li>Check out the Reports section for insights</li>
            <li>Set up leave types and holidays</li>
            <li>Configure payroll settings</li>
            <li>Explore the training module</li>
        </ul>
    </div>
</div>

<div class="d-grid">
    <a href="<?php echo e(route('onboarding.finish')); ?>" class="btn btn-primary btn-lg">
        <i class="bi bi-speedometer2"></i> Go to Dashboard
    </a>
</div>

<div class="text-center mt-3">
    <small class="text-muted">
        Need help getting started? <a href="mailto:support@qayahrm.com">Contact our support team</a>
    </small>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('onboarding.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/onboarding/complete.blade.php ENDPATH**/ ?>